/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.egl;

import com.sun.nativewindow.impl.NullWindow;
import com.sun.opengl.impl.egl.EGL;
import com.sun.opengl.impl.egl.EGLDrawable;
import com.sun.opengl.impl.egl.EGLDrawableFactory;
import com.sun.opengl.impl.egl.EGLGraphicsConfiguration;
import com.sun.opengl.impl.egl.EGLGraphicsConfigurationFactory;
import com.sun.opengl.impl.egl.EGLPbufferContext;
import com.sun.opengl.impl.egl._EGLConfig;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.egl.EGLGraphicsDevice;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class EGLPbufferDrawable
extends EGLDrawable {
    private int width;
    private int height;
    private int texFormat;
    protected static final boolean useTexture = false;

    protected EGLPbufferDrawable(EGLDrawableFactory eGLDrawableFactory, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        super(eGLDrawableFactory, (NativeWindow)new NullWindow((AbstractGraphicsConfiguration)EGLPbufferDrawable.createEGLGraphicsConfiguration(gLCapabilities, gLCapabilitiesChooser)));
        if (n <= 0 || n2 <= 0) {
            throw new GLException("Width and height of pbuffer must be positive (were (" + n + ", " + n2 + "))");
        }
        gLCapabilities = (GLCapabilities)this.getNativeWindow().getGraphicsConfiguration().getNativeGraphicsConfiguration().getChosenCapabilities();
        this.width = n;
        this.height = n2;
        this.texFormat = 12380;
        NullWindow nullWindow = (NullWindow)this.getNativeWindow();
        nullWindow.setSize(n, n2);
        this.ownEGLDisplay = true;
        if (DEBUG) {
            System.out.println("Pbuffer config: " + this.getNativeWindow().getGraphicsConfiguration().getNativeGraphicsConfiguration());
        }
    }

    protected static EGLGraphicsConfiguration createEGLGraphicsConfiguration(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        long l = EGL.eglGetDisplay(0L);
        if (l == 0L) {
            throw new GLException("Failed to created EGL default display: error 0x" + Integer.toHexString(EGL.eglGetError()));
        }
        if (DEBUG) {
            System.err.println("eglDisplay(EGL_DEFAULT_DISPLAY): 0x" + Long.toHexString(l));
        }
        if (!EGL.eglInitialize(l, null, null)) {
            throw new GLException("eglInitialize failed, error 0x" + Integer.toHexString(EGL.eglGetError()));
        }
        EGLGraphicsDevice eGLGraphicsDevice = new EGLGraphicsDevice(l);
        DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen((AbstractGraphicsDevice)eGLGraphicsDevice, 0);
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilities, gLCapabilitiesChooser, (AbstractGraphicsScreen)defaultGraphicsScreen, 1);
        if (null == eGLGraphicsConfiguration) {
            EGL.eglTerminate(l);
            throw new GLException("Couldn't create EGLGraphicsConfiguration from " + defaultGraphicsScreen);
        }
        if (DEBUG) {
            System.err.println("Chosen eglConfig: " + eGLGraphicsConfiguration);
        }
        return eGLGraphicsConfiguration;
    }

    protected long createSurface(long l, _EGLConfig _EGLConfig2) {
        int[] nArray = EGLGraphicsConfiguration.CreatePBufferSurfaceAttribList(this.width, this.height, this.texFormat);
        long l2 = EGL.eglCreatePbufferSurface(l, _EGLConfig2, nArray, 0);
        if (0L == l2) {
            throw new GLException("Creation of window surface (eglCreatePbufferSurface) failed, dim " + this.width + "x" + this.height + ", error 0x" + Integer.toHexString(EGL.eglGetError()));
        }
        if (DEBUG) {
            System.err.println("setSurface result: eglSurface 0x" + Long.toHexString(l2));
        }
        return l2;
    }

    public GLContext createContext(GLContext gLContext) {
        return new EGLPbufferContext(this, gLContext);
    }

    protected void swapBuffersImpl() {
    }
}

