/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.Activator;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorRequest;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.repository.helpers.AbstractRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.repository.IRepository;
import org.eclipse.equinox.internal.provisional.spi.p2.artifact.repository.ArtifactRepositoryFactory;
import org.osgi.framework.BundleContext;

public class ArtifactRepositoryManager
extends AbstractRepositoryManager
implements IArtifactRepositoryManager {
    static /* synthetic */ Class class$0;

    public void addRepository(IArtifactRepository repository) {
        super.addRepository((IRepository)repository, true, null);
    }

    public IArtifactRequest createMirrorRequest(IArtifactKey key, IArtifactRepository destination, Properties destinationDescriptorProperties, Properties destinationRepositoryProperties) {
        return new MirrorRequest(key, destination, destinationDescriptorProperties, destinationRepositoryProperties);
    }

    public IArtifactRepository createRepository(URI location, String name, String type, Map properties) throws ProvisionException {
        return (IArtifactRepository)this.doCreateRepository(location, name, type, properties);
    }

    protected IRepository factoryCreate(URI location, String name, String type, Map properties, IExtension extension) throws ProvisionException {
        ArtifactRepositoryFactory factory = (ArtifactRepositoryFactory)this.createExecutableExtension(extension, "factory");
        if (factory == null) {
            return null;
        }
        return factory.create(location, name, type, properties);
    }

    protected IRepository factoryLoad(URI location, IExtension extension, int flags, SubMonitor monitor) throws ProvisionException {
        ArtifactRepositoryFactory factory = (ArtifactRepositoryFactory)this.createExecutableExtension(extension, "factory");
        if (factory == null) {
            return null;
        }
        return factory.load(location, flags, (IProgressMonitor)monitor.newChild(10));
    }

    protected String getBundleId() {
        return "org.eclipse.equinox.p2.artifact.repository";
    }

    protected String getDefaultSuffix() {
        return "artifacts.xml";
    }

    protected String getRepositoryProviderExtensionPointId() {
        return "org.eclipse.equinox.p2.artifact.repository.artifactRepositories";
    }

    protected String getRepositorySystemProperty() {
        return "eclipse.p2.artifactRepository";
    }

    protected int getRepositoryType() {
        return 1;
    }

    public IArtifactRepository loadRepository(URI location, IProgressMonitor monitor) throws ProvisionException {
        return this.loadRepository(location, 0, monitor);
    }

    public IArtifactRepository loadRepository(URI location, int flags, IProgressMonitor monitor) throws ProvisionException {
        return (IArtifactRepository)this.loadRepository(location, monitor, null, flags);
    }

    public IArtifactRepository refreshRepository(URI location, IProgressMonitor monitor) throws ProvisionException {
        return (IArtifactRepository)this.basicRefreshRepository(location, monitor);
    }

    protected void restoreSpecialRepositories() {
        AgentLocation location;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((location = (AgentLocation)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return;
        }
        try {
            this.loadRepository(location.getArtifactRepositoryURI(), null);
            return;
        }
        catch (ProvisionException e) {
            if (e.getStatus().getCode() != 1000) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", "Error occurred while loading download cache.", (Throwable)e));
            }
            try {
                HashMap<String, String> properties = new HashMap<String, String>(1);
                properties.put("p2.system", Boolean.TRUE.toString());
                this.createRepository(location.getArtifactRepositoryURI(), "download cache", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            }
            catch (ProvisionException e2) {
                LogHelper.log((ProvisionException)e2);
            }
            return;
        }
    }
}

