/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.wizards;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.widgets.FrameRateComboUtil;
import ch.kuramo.javie.app.widgets.GridBuilder;
import ch.kuramo.javie.app.wizards.CompositionSettings;
import ch.kuramo.javie.core.TimeCode;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class CompositionWizardPage
extends WizardPage {
    private static final int MAX_SIZE = 8192;
    private CompositionSettings _settings;
    private Text _nameText;
    private Text _widthText;
    private Text _heightText;
    private Button _freezeRatio;
    private Combo _fpsCombo;
    private Text _durationText;
    private Label _duration2;
    private Combo _colorModeCombo;
    private ModifyListener _modifyListener;
    private int _widthRatio;
    private int _heightRatio;

    public CompositionWizardPage(CompositionSettings settings) {
        super("CompositionWizardPage", "\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3", null);
        this.setDescription("\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002");
        this._settings = settings;
    }

    public void createControl(Composite parent) {
        String[] colorModeItems = new String[]{"8 bit/\u30c1\u30e3\u30f3\u30cd\u30eb", "16 bit/\u30c1\u30e3\u30f3\u30cd\u30eb", "16 bit/\u30c1\u30e3\u30f3\u30cd\u30eb\uff08\u6d6e\u52d5\u5c0f\u6570\u70b9\uff09", "32 bit/\u30c1\u30e3\u30f3\u30cd\u30eb\uff08\u6d6e\u52d5\u5c0f\u6570\u70b9\uff09"};
        GridBuilder gb = new GridBuilder(parent, 16, true);
        gb.hSpan(4).hAlign(131072).hGrab().label(0, "\u540d\u524d:");
        this._nameText = gb.hSpan(12).hAlign(4).hGrab().text(2048, this._settings.name);
        gb.hSpan(16).size(10, 10).composite(0);
        gb.hSpan(4).hAlign(131072).hGrab().label(0, "\u5e45:");
        this._widthText = gb.hSpan(3).hAlign(4).hGrab().text(2048, String.valueOf(this._settings.width));
        this._freezeRatio = gb.span(9, 2).hAlign(4).hGrab().button(32, "\u7e26\u6a2a\u6bd4\u3092\u56fa\u5b9a");
        gb.hSpan(4).hAlign(131072).hGrab().label(0, "\u9ad8\u3055:");
        this._heightText = gb.hSpan(3).hAlign(4).hGrab().tabAfter((Control)this._widthText).text(2048, String.valueOf(this._settings.height));
        gb.hSpan(4).hAlign(131072).hGrab().label(0, "\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8:");
        this._fpsCombo = gb.hSpan(3).hAlign(4).hGrab().combo(0, 0, FrameRateComboUtil.getComboItems(), FrameRateComboUtil.toComboItem(this._settings.frameDuration));
        gb.hSpan(9).hGrab().label(0, "\u30d5\u30ec\u30fc\u30e0/\u79d2");
        gb.hSpan(4).hAlign(131072).hGrab().label(0, "\u30c7\u30e5\u30ec\u30fc\u30b7\u30e7\u30f3:");
        this._durationText = gb.hSpan(3).hAlign(4).hGrab().text(2048, TimeCode.toTimeCode((Time)this._settings.duration, (Time)this._settings.frameDuration));
        this._duration2 = gb.hSpan(9).hAlign(4).hGrab().label(0, "");
        gb.hSpan(16).size(10, 10).composite(0);
        gb.hSpan(4).hAlign(131072).hGrab().label(0, "\u8272\u6df1\u5ea6:");
        this._colorModeCombo = gb.hSpan(12).hGrab().combo(8, colorModeItems, this._settings.colorMode.ordinal());
        this._modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompositionWizardPage.this.doValidate((Control)e.getSource());
            }
        };
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CompositionWizardPage.this.doValidate((Control)e.getSource());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CompositionWizardPage.this.doValidate((Control)e.getSource());
            }
        };
        this._nameText.addModifyListener(this._modifyListener);
        this._widthText.addModifyListener(this._modifyListener);
        this._heightText.addModifyListener(this._modifyListener);
        this._freezeRatio.addSelectionListener(selectionListener);
        this._fpsCombo.addModifyListener(this._modifyListener);
        this._fpsCombo.addSelectionListener(selectionListener);
        this._durationText.addModifyListener(this._modifyListener);
        Composite grid = gb.getComposite();
        grid.setTabList(gb.getTabList());
        this.doValidate(null);
        this.setControl((Control)grid);
    }

    private void doValidate(Control control) {
        int height;
        int width;
        this.setPageComplete(false);
        String wStr = this._widthText.getText().trim();
        try {
            width = Integer.parseInt(wStr);
        }
        catch (NumberFormatException numberFormatException) {
            width = 0;
        }
        String hStr = this._heightText.getText().trim();
        try {
            height = Integer.parseInt(hStr);
        }
        catch (NumberFormatException numberFormatException) {
            height = 0;
        }
        boolean frozen = this._freezeRatio.getSelection();
        if (frozen) {
            if (control == this._widthText && width > 0) {
                height = Math.max(1, width * this._heightRatio / this._widthRatio);
                this._heightText.removeModifyListener(this._modifyListener);
                this._heightText.setText(String.valueOf(height));
                this._heightText.addModifyListener(this._modifyListener);
            } else if (control == this._heightText && height > 0) {
                width = Math.max(1, height * this._widthRatio / this._heightRatio);
                this._widthText.removeModifyListener(this._modifyListener);
                this._widthText.setText(String.valueOf(width));
                this._widthText.addModifyListener(this._modifyListener);
            }
        } else if ((control == null || control == this._widthText || control == this._heightText) && width > 0 && height > 0) {
            int gcd = this.gcd(width, height);
            this._widthRatio = width / gcd;
            this._heightRatio = height / gcd;
            this._freezeRatio.setText(String.format("\u7e26\u6a2a\u6bd4\u3092%d:%d\u306b\u56fa\u5b9a", this._widthRatio, this._heightRatio));
        }
        if (this._nameText.getText().trim().length() == 0) {
            this.setErrorMessage("\u540d\u524d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        if (wStr.length() == 0) {
            this.setErrorMessage("\u5e45\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        if (width < 1 || width > 8192) {
            this.setErrorMessage(String.format("\u5e45\u306b\u306f1\u304b\u3089%d\u307e\u3067\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002", 8192));
            return;
        }
        if (hStr.length() == 0) {
            this.setErrorMessage("\u9ad8\u3055\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        if (height < 1 || height > 8192) {
            this.setErrorMessage(String.format("\u9ad8\u3055\u306b\u306f1\u304b\u3089%d\u307e\u3067\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002", 8192));
            return;
        }
        String fpsStr = this._fpsCombo.getText().trim();
        if (fpsStr.length() == 0) {
            this.setErrorMessage("\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        double fps = 0.0;
        try {
            fps = Double.parseDouble(fpsStr);
        }
        catch (NumberFormatException numberFormatException) {}
        if (fps <= 0.0) {
            this.setErrorMessage("\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8\u306b\u306f\u6b63\u306e\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
        String durationStr = this._durationText.getText().trim();
        if (durationStr.length() == 0) {
            this.setErrorMessage("\u30c7\u30e5\u30ec\u30fc\u30b7\u30e7\u30f3\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        Time frameDuration = FrameRateComboUtil.toFrameDuration(fpsStr);
        long frames = TimeCode.parseTimeCode((String)durationStr, (Time)frameDuration);
        if (frames <= 0L) {
            this.setErrorMessage("0\u4ee5\u4e0b\u306e\u30c7\u30e5\u30ec\u30fc\u30b7\u30e7\u30f3\u306f\u5165\u529b\u3067\u304d\u307e\u305b\u3093\u3002");
            return;
        }
        String timeCode = TimeCode.toTimeCode((Time)Time.fromFrameNumber((long)frames, (Time)frameDuration), (Time)frameDuration);
        int base = (int)Math.round((double)frameDuration.timeScale / (double)frameDuration.timeValue);
        boolean drop = timeCode.indexOf(59) != -1;
        this._duration2.setText(String.format("= %s (\u30d9\u30fc\u30b9 %d%s) , %d\u30d5\u30ec\u30fc\u30e0", timeCode, base, drop ? "\u30c9\u30ed\u30c3\u30d7" : "", frames));
        if (control == this._fpsCombo && !durationStr.matches("[\\d]+")) {
            this._durationText.removeModifyListener(this._modifyListener);
            this._durationText.setText(timeCode);
            this._durationText.addModifyListener(this._modifyListener);
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private int gcd(int x, int y) {
        while (y != 0) {
            int t = x % y;
            x = y;
            y = t;
        }
        return x;
    }

    public CompositionSettings getResult() {
        if (!this.isPageComplete()) {
            return null;
        }
        CompositionSettings result = new CompositionSettings();
        Time frameDuration = FrameRateComboUtil.toFrameDuration(this._fpsCombo.getText().trim());
        long frames = TimeCode.parseTimeCode((String)this._durationText.getText().trim(), (Time)frameDuration);
        result.name = this._nameText.getText().trim();
        result.width = Integer.parseInt(this._widthText.getText().trim());
        result.height = Integer.parseInt(this._heightText.getText().trim());
        result.frameDuration = frameDuration;
        result.duration = Time.fromFrameNumber((long)frames, (Time)frameDuration);
        result.colorMode = ColorMode.values()[this._colorModeCombo.getSelectionIndex()];
        return result;
    }
}

