/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.wizards;

import ch.kuramo.javie.app.UIUtil;
import ch.kuramo.javie.app.player.PlayerLock;
import ch.kuramo.javie.app.project.NewLayerCompositionOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.wizards.CompositionSettings;
import ch.kuramo.javie.app.wizards.CompositionWizardPage;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.JavieRuntimeException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbenchPage;

public class CompositionWizard
extends Wizard {
    private static CompositionSettings _defaultSettings = new CompositionSettings();
    private final ProjectManager _projectManager;
    private final Folder _parent;
    private CompositionWizardPage _page;

    public CompositionWizard(ProjectManager projectManager, Folder parent) {
        this._projectManager = projectManager;
        this._parent = parent;
        this.setWindowTitle("\u65b0\u898f\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3");
    }

    public void addPages() {
        CompositionSettings settings = _defaultSettings.clone();
        settings.name = this._projectManager.getUnusedItemName("\u30b3\u30f3\u30dd");
        this._page = new CompositionWizardPage(settings);
        this.addPage((IWizardPage)this._page);
    }

    public boolean performFinish() {
        CompositionSettings settings = this._page.getResult();
        if (settings == null) {
            return false;
        }
        NewLayerCompositionOperation op = new NewLayerCompositionOperation(this._projectManager, this._parent, settings.name, settings.width, settings.height, settings.frameDuration, settings.duration, settings.colorMode);
        this._projectManager.postOperation(op);
        String compItemId = op.getCompositionItemId();
        if (this.waitShadowOperation(compItemId)) {
            IWorkbenchPage page = this._projectManager.getWorkbenchWindow().getActivePage();
            UIUtil.showView(page, "ch.kuramo.javie.app.views.layerCompositionView", compItemId, 1);
            UIUtil.showView(page, "ch.kuramo.javie.app.views.mediaPlayerView", compItemId, 2);
        }
        _defaultSettings = settings;
        return true;
    }

    private boolean waitShadowOperation(final String compItemId) {
        final boolean[] ready = new boolean[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                int i = 0;
                while (i < 100) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    PlayerLock.readLock().lock();
                    try {
                        if (CompositionWizard.this._projectManager.getShadow().getItem(compItemId) != null) {
                            ready[0] = true;
                            break;
                        }
                    }
                    finally {
                        PlayerLock.readLock().unlock();
                    }
                    ++i;
                }
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        return ready[0];
    }
}

