/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GridBuilder {
    private final Composite _composite;
    private final List<Control> _tabList = new ArrayList<Control>();

    public GridBuilder(Composite parent, int numColumns, boolean makeColumnsEqualWidth) {
        this._composite = new Composite(parent, 0);
        this._composite.setLayout((Layout)new GridLayout(numColumns, makeColumnsEqualWidth));
    }

    public Composite getComposite() {
        return this._composite;
    }

    public Control[] getTabList() {
        return this._tabList.toArray(new Control[this._tabList.size()]);
    }

    public CellBuilder span(int hSpan, int vSpan) {
        return new CellBuilder().span(hSpan, vSpan);
    }

    public CellBuilder hSpan(int hSpan) {
        return new CellBuilder().hSpan(hSpan);
    }

    public CellBuilder vSpan(int vSpan) {
        return new CellBuilder().vSpan(vSpan);
    }

    public CellBuilder align(int hAlign, int vAlign) {
        return new CellBuilder().align(hAlign, vAlign);
    }

    public CellBuilder hAlign(int hAlign) {
        return new CellBuilder().hAlign(hAlign);
    }

    public CellBuilder vAlign(int vAlign) {
        return new CellBuilder().vAlign(vAlign);
    }

    public CellBuilder grab(boolean hGrab, boolean vGrab) {
        return new CellBuilder().grab(hGrab, vGrab);
    }

    public CellBuilder hGrab() {
        return new CellBuilder().hGrab();
    }

    public CellBuilder vGrab() {
        return new CellBuilder().vGrab();
    }

    public CellBuilder size(int width, int height) {
        return new CellBuilder().size(width, height);
    }

    public CellBuilder width(int width) {
        return new CellBuilder().width(width);
    }

    public CellBuilder height(int height) {
        return new CellBuilder().height(height);
    }

    public class CellBuilder {
        private final GridData data = new GridData();
        private Control tabBefore = null;
        private Control tabAfter = null;

        public CellBuilder span(int hSpan, int vSpan) {
            this.data.horizontalSpan = hSpan;
            this.data.verticalSpan = vSpan;
            return this;
        }

        public CellBuilder hSpan(int hSpan) {
            this.data.horizontalSpan = hSpan;
            return this;
        }

        public CellBuilder vSpan(int vSpan) {
            this.data.verticalSpan = vSpan;
            return this;
        }

        public CellBuilder align(int hAlign, int vAlign) {
            this.data.horizontalAlignment = hAlign;
            this.data.verticalAlignment = vAlign;
            return this;
        }

        public CellBuilder hAlign(int hAlign) {
            this.data.horizontalAlignment = hAlign;
            return this;
        }

        public CellBuilder vAlign(int vAlign) {
            this.data.verticalAlignment = vAlign;
            return this;
        }

        public CellBuilder grab(boolean hGrab, boolean vGrab) {
            this.data.grabExcessHorizontalSpace = hGrab;
            this.data.grabExcessVerticalSpace = vGrab;
            return this;
        }

        public CellBuilder hGrab() {
            this.data.grabExcessHorizontalSpace = true;
            return this;
        }

        public CellBuilder vGrab() {
            this.data.grabExcessVerticalSpace = true;
            return this;
        }

        public CellBuilder size(int width, int height) {
            this.data.widthHint = width;
            this.data.heightHint = height;
            return this;
        }

        public CellBuilder width(int width) {
            this.data.widthHint = width;
            return this;
        }

        public CellBuilder height(int height) {
            this.data.heightHint = height;
            return this;
        }

        public CellBuilder tabBefore(Control control) {
            this.tabBefore = control;
            return this;
        }

        public CellBuilder tabAfter(Control control) {
            this.tabAfter = control;
            return this;
        }

        private void addToTabList(Control control) {
            if (this.tabBefore != null) {
                GridBuilder.this._tabList.add(GridBuilder.this._tabList.indexOf(this.tabBefore), control);
            } else if (this.tabAfter != null) {
                GridBuilder.this._tabList.add(GridBuilder.this._tabList.indexOf(this.tabAfter) + 1, control);
            } else {
                GridBuilder.this._tabList.add(control);
            }
        }

        public Composite composite(int style) {
            Composite c = new Composite(GridBuilder.this._composite, style);
            c.setLayoutData((Object)this.data);
            return c;
        }

        public Label label(int style, String text) {
            Label label = new Label(GridBuilder.this._composite, style);
            label.setText(text);
            label.setLayoutData((Object)this.data);
            return label;
        }

        public Text text(int style, String text) {
            Text tx = new Text(GridBuilder.this._composite, style);
            tx.setText(text);
            tx.setLayoutData((Object)this.data);
            this.addToTabList((Control)tx);
            return tx;
        }

        public Button button(int style, String text) {
            Button button = new Button(GridBuilder.this._composite, style);
            button.setText(text);
            button.setLayoutData((Object)this.data);
            this.addToTabList((Control)button);
            return button;
        }

        public Combo combo(int style, String[] items) {
            return this.combo(style, items, items[0]);
        }

        public Combo combo(int style, String[] items, int defaultItem) {
            return this.combo(style, items, items[defaultItem]);
        }

        public Combo combo(int style, String[] items, String text) {
            return this.combo(style, -1, items, text);
        }

        public Combo combo(int style, int visibleItemCount, String[] items, String text) {
            Combo combo = new Combo(GridBuilder.this._composite, style);
            if (visibleItemCount >= 0) {
                combo.setVisibleItemCount(visibleItemCount > 0 ? visibleItemCount : items.length);
            }
            combo.setItems(items);
            combo.setText(text);
            combo.setLayoutData((Object)this.data);
            this.addToTabList((Control)combo);
            return combo;
        }
    }
}

