/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.ColorUtil;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.IntervalTask;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.UIUtil;
import ch.kuramo.javie.app.actions.AVIOutputAction;
import ch.kuramo.javie.app.actions.AddEffectAction;
import ch.kuramo.javie.app.actions.AddExpressionsAction;
import ch.kuramo.javie.app.actions.KeyframeInterpolationAction;
import ch.kuramo.javie.app.actions.QTMovieOutputAction;
import ch.kuramo.javie.app.actions.RemoveKeyframesAction;
import ch.kuramo.javie.app.actions.ResetAnimatableValuesAction;
import ch.kuramo.javie.app.actions.ReverseLayerTimeAction;
import ch.kuramo.javie.app.actions.SequenceOutputAction;
import ch.kuramo.javie.app.actions.TimeRemapAction;
import ch.kuramo.javie.app.actions.WaveOutputAction;
import ch.kuramo.javie.app.player.MediaPlayer;
import ch.kuramo.javie.app.player.PlayerLinkEvent;
import ch.kuramo.javie.app.player.PlayerLinkListener;
import ch.kuramo.javie.app.project.MoveEffectsOperation;
import ch.kuramo.javie.app.project.NewCameraLayerOperation;
import ch.kuramo.javie.app.project.NewLayerFromItemOperation;
import ch.kuramo.javie.app.project.NewNullLayerOperation;
import ch.kuramo.javie.app.project.NewTextLayerOperation;
import ch.kuramo.javie.app.project.ProjectEvent;
import ch.kuramo.javie.app.project.ProjectEventHub;
import ch.kuramo.javie.app.project.ProjectListener;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.RemoveEffectsOperation;
import ch.kuramo.javie.app.project.RemoveLayersOperation;
import ch.kuramo.javie.app.project.ReorderLayersOperation;
import ch.kuramo.javie.app.views.LayerCompositionContentProvider;
import ch.kuramo.javie.app.views.LayerCompositionLabelProvider;
import ch.kuramo.javie.app.views.LocalSelectionWrapper;
import ch.kuramo.javie.app.views.MediaPlayerView;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElementDelegate;
import ch.kuramo.javie.app.views.layercomp.EffectAnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.EffectElement;
import ch.kuramo.javie.app.views.layercomp.EffectsElement;
import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.LayerAnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.LayerElement;
import ch.kuramo.javie.app.views.layercomp.TimelineManager;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectDescriptor;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.Interpolation;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.ItemLayer;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.TransformableLayer;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.AnimatableValueCollector;
import ch.kuramo.javie.core.services.EffectRegistry;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeColumnViewerLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerCompositionView
extends ViewPart
implements ProjectListener,
PlayerLinkListener {
    public static final String ID = "ch.kuramo.javie.app.views.layerCompositionView";
    public static final int NAME_COL = 0;
    public static final int VALUE_COL = 1;
    public static final int MODE_COL = 2;
    public static final int TRACKMATTE_COL = 3;
    public static final int PARENT_COL = 4;
    public static final int SHOWHIDE_COL = 5;
    public static final int LABEL_COL = 6;
    public static final int TIMELINE_COL = 7;
    public static final String PROJECT_MANAGER = "PROJECT_MANAGER";
    public static final String LAYER_COMPOSITION = "LAYER_COMPOSITION";
    public static final String ANIMATABLE_VALUES = "ANIMATABLE_VALUES";
    public static final String TIMELINE_MANAGER = "TIMELINE_MANAGER";
    private static final Logger _logger = LoggerFactory.getLogger(LayerCompositionView.class);
    private static final boolean COCOA = SWT.getPlatform().equals("cocoa");
    private static final boolean WIN32 = SWT.getPlatform().equals("win32");
    private static final int ROW_PADDING = 4;
    private Composite _topLeftSpacer;
    private Composite _bottomLeftSpacer;
    private Composite _timelineMeter;
    private Scale _timelineScale;
    private Slider _timelineSlider;
    private TreeViewer _treeViewer;
    private Action _newCameraLayerAction;
    private Action _newNullLayerAction;
    private Action _newTextLayerAction;
    private Point _mouseDownPoint;
    private volatile Time _time;
    private IntervalTask _timelineUpdateTask;
    private IntervalTask _collectTask;
    private ProjectManager _projectManager;
    private CompositionItem _compItem;
    private LayerComposition _composition;
    private TimelineManager _timelineManager;
    @Inject
    private EffectRegistry _effectRegistry;
    @Inject
    private AnimatableValueCollector _collector;
    private TreeItem _shiftSelectionBaseItem;
    private final ListenerList _playerLinkListeners = new ListenerList();
    private static final Set<String> _connectingIds = Util.newSet();

    public LayerCompositionView() {
        InjectorHolder.getInjector().injectMembers((Object)this);
        this._newCameraLayerAction = new Action("\u30ab\u30e1\u30e9"){

            public void run() {
                LayerCompositionView.this.handleNewCameraLayerAction();
            }
        };
        this._newNullLayerAction = new Action("\u30cc\u30eb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8"){

            public void run() {
                LayerCompositionView.this.handleNewNullLayerAction();
            }
        };
        this._newTextLayerAction = new Action("\u30c6\u30ad\u30b9\u30c8"){

            public void run() {
                LayerCompositionView.this.handleNewTextLayerAction();
            }
        };
        this._collector.activate();
    }

    public void createPartControl(final Composite parent) {
        ProjectManager pm = ProjectManager.forWorkbenchWindow(this.getSite().getWorkbenchWindow());
        if (pm == null) {
            throw new IllegalStateException("No ProjectManager exists for this window.");
        }
        parent.setLayout((Layout)new FormLayout());
        this._topLeftSpacer = new Composite(parent, 0);
        this._bottomLeftSpacer = new Composite(parent, 0);
        this.createTreeViewer(parent);
        this.createTimelineControls(parent);
        this.setLayoutData();
        this.setupGlobalActionsAndContextMenu();
        this.setupDragAndDrop();
        this._timelineUpdateTask = new IntervalTask(parent.getDisplay(), 50){

            public void run() {
                if (!parent.isDisposed() && LayerCompositionView.this._timelineManager != null) {
                    LayerCompositionView.this._timelineManager.update(LayerCompositionView.this._time, true);
                }
            }
        };
        this._collectTask = new IntervalTask(parent.getDisplay(), 300){

            public void run() {
                if (!parent.isDisposed()) {
                    LayerCompositionView.this.collectAnimatableValues(LayerCompositionView.this._time);
                }
            }
        };
        this.setProjectManager(pm);
        ProjectEventHub.getHub().addProjectListener(this);
    }

    public void dispose() {
        ProjectEventHub.getHub().removeProjectListener(this);
        this._collector.deactivate();
        super.dispose();
    }

    public void setFocus() {
        this._treeViewer.getControl().setFocus();
    }

    private String getItemId() {
        return this.getViewSite().getSecondaryId();
    }

    private void setProjectManager(ProjectManager pm) {
        this._compItem = (CompositionItem)pm.getProject().getItem(this.getItemId());
        if (this._compItem == null) {
            throw new IllegalStateException("no such CompositionItem found: " + this.getItemId());
        }
        this._projectManager = pm;
        this._composition = (LayerComposition)this._compItem.getComposition();
        this.setPartName(this._compItem.getName());
        this._treeViewer.setData(PROJECT_MANAGER, (Object)pm);
        this._treeViewer.setData(LAYER_COMPOSITION, (Object)this._composition);
        this._treeViewer.setInput((Object)this._composition);
        this._time = Time.fromFrameNumber((long)0L, (Time)this._composition.getFrameDuration());
        this._timelineManager = new TimelineManager(pm, this._composition, this, this._timelineMeter, this._timelineScale, this._timelineSlider, this._treeViewer.getTree());
        this._treeViewer.setData(TIMELINE_MANAGER, (Object)this._timelineManager);
        this.collectAnimatableValues();
        this.connectToPlayer();
    }

    @Override
    public void handleProjectEvent(ProjectEvent event) {
        ProjectManager pm = event.getProjectManager();
        if (pm.getWorkbenchWindow() != this.getSite().getWorkbenchWindow()) {
            return;
        }
        switch (event.type) {
            case LAYER_PROPERTY_CHANGE: 
            case LAYERS_REMOVE: 
            case EFFECT_PROPERTY_CHANGE: 
            case EFFECTS_REMOVE: {
                this._timelineManager.clearKeyframeSelection();
                this._timelineManager.redraw();
            }
        }
        switch (event.type) {
            case ITEM_NAME_CHANGE: {
                this.handleItemNameChange(event);
                break;
            }
            case LAYER_PROPERTY_CHANGE: {
                this.handleLayerPropertyChange(event);
                break;
            }
            case LAYER_EXPRESSION_CHANGE: {
                this.handleLayerExpressionChange(event);
                break;
            }
            case LAYERS_ADD: 
            case LAYERS_REMOVE: 
            case LAYERS_REORDER: {
                this.handleLayersAddRemoveReorder(event);
                break;
            }
            case EXPRESSIONS_ADD: 
            case EXPRESSIONS_REMOVE: {
                this.handleExpressionsAddRemove(event);
                break;
            }
            case EFFECTS_ADD: 
            case EFFECTS_REMOVE: {
                this.handleEffectsAddRemove(event);
                break;
            }
            case EFFECT_PROPERTY_CHANGE: {
                this.handleEffectPropertyChange(event);
                break;
            }
            case EFFECT_EXPRESSION_CHANGE: {
                this.handleEffectExpressionChange(event);
                break;
            }
            case LAYER_TIMES_CHANGE: {
                this.handleLayerTimesChange(event);
                break;
            }
            case KEYFRAMES_CHANGE: {
                this.handleKeyframesChange(event);
                break;
            }
            case LAYER_SLIP_EDIT: {
                this.handleLayerSlipEdit(event);
            }
        }
    }

    private void createTimelineControls(Composite parent) {
        this._timelineMeter = new Composite(parent, WIN32 ? 0x20000000 : 0);
        this._timelineScale = new Scale(parent, 256);
        this._timelineSlider = new Slider(parent, 256);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LayerCompositionView.this._timelineManager.update(LayerCompositionView.this._time, false);
            }
        };
        this._timelineScale.addSelectionListener((SelectionListener)selectionListener);
        this._timelineSlider.addSelectionListener((SelectionListener)selectionListener);
    }

    private void createTreeViewer(Composite parent) {
        Color layerColor;
        this._treeViewer = new TreeViewer(parent, 530);
        this._treeViewer.setUseHashlookup(true);
        this._treeViewer.setContentProvider((IContentProvider)new LayerCompositionContentProvider());
        Tree tree = this._treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(!COCOA);
        class DragSourceEffect
        extends TreeDragSourceEffect {
            private boolean creatingImage;

            public DragSourceEffect(Tree tree) {
                super(tree);
            }

            public void dragStart(DragSourceEvent event) {
                this.creatingImage = true;
                try {
                    super.dragStart(event);
                }
                finally {
                    this.creatingImage = false;
                }
            }
        }
        final DragSourceEffect dragEffect = new DragSourceEffect(tree);
        tree.setData("DEFAULT_DRAG_SOURCE_EFFECT", (Object)dragEffect);
        this.createViewerColumn(0, 200, null, "\u30bd\u30fc\u30b9\u540d");
        this.createViewerColumn(1, 150, null, "");
        this.createViewerColumn(2, 50, null, "\u30e2\u30fc\u30c9");
        this.createViewerColumn(3, 50, null, "\uff84\uff97\uff6f\uff78\uff8f\uff6f\uff84");
        this.createViewerColumn(4, 100, null, "\u89aa");
        this.createViewerColumn(5, 60, null, "");
        this.createViewerColumn(6, 40, null, "");
        this.createViewerColumn(7, 300, null, "");
        ControlAdapter columnWidthAdjuster = new ControlAdapter(){
            private boolean adjusting = false;

            public void controlResized(ControlEvent e) {
                if (!this.adjusting) {
                    this.adjusting = true;
                    try {
                        LayerCompositionView.this.adjustColumnWidth();
                        if (LayerCompositionView.this._timelineManager != null) {
                            LayerCompositionView.this._timelineManager.update(LayerCompositionView.this._time, false);
                        }
                    }
                    finally {
                        this.adjusting = false;
                    }
                }
            }
        };
        tree.addControlListener((ControlListener)columnWidthAdjuster);
        TreeColumn[] treeColumnArray = tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.addControlListener((ControlListener)columnWidthAdjuster);
            ++n2;
        }
        tree.setBackground(ColorUtil.tableBackground());
        if (COCOA) {
            layerColor = ColorUtil.layerRowBackground();
            final Color lineColor = ColorUtil.tableRowLine();
            tree.addListener(40, new Listener(){
                {
                }

                public void handleEvent(Event event) {
                    if (dragEffect.creatingImage) {
                        return;
                    }
                    GC gc = event.gc;
                    TreeItem treeItem = (TreeItem)event.item;
                    Object element = treeItem.getData();
                    if (element instanceof LayerElement) {
                        gc.setBackground(layerColor);
                        gc.fillRectangle(event.x, event.y, event.width, event.height - 1);
                    }
                    int x = event.x;
                    int y = event.y + event.height - 1;
                    gc.setForeground(lineColor);
                    gc.drawLine(x, y, x + event.width, y);
                }
            });
        } else {
            layerColor = ColorUtil.layerRowBackground();
            tree.addListener(40, new Listener(){
                {
                }

                public void handleEvent(Event event) {
                    if (dragEffect.creatingImage) {
                        return;
                    }
                    TreeItem treeItem = (TreeItem)event.item;
                    Object element = treeItem.getData();
                    if (element instanceof LayerElement) {
                        GC gc = event.gc;
                        gc.setBackground(layerColor);
                        gc.fillRectangle(event.x, event.y, event.width, event.height);
                        treeItem.setBackground(layerColor);
                    }
                }
            });
        }
        tree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                Object element = event.item.getData();
                if (element instanceof Element) {
                    ((Element)element).paintColumn(event);
                }
            }
        });
        tree.addListener(41, new Listener(){

            public void handleEvent(Event e) {
                e.height = Math.max(e.height, e.gc.getFontMetrics().getHeight() + 8);
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                LayerCompositionView.this.updateCursor(e);
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (COCOA) {
                    LayerCompositionView.this._mouseDownPoint = new Point(e.x, e.y);
                }
                LayerCompositionView.this.handleMouseDown(e);
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                LayerCompositionView.this.handleKeyPressed(e);
            }
        });
        tree.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (LayerCompositionView.this._timelineManager != null) {
                    LayerCompositionView.this._timelineManager.drawTimeIndicatorLine(e);
                    if (COCOA) {
                        LayerCompositionView.this._timelineManager.drawColumnLeftLine(e);
                    }
                }
            }
        });
    }

    private TreeViewerColumn createViewerColumn(int columnIndex, int width, Image image, String name) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this._treeViewer, 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setWidth(width);
        column.setImage(image);
        column.setText(name);
        column.setMoveable(false);
        viewerColumn.setLabelProvider((CellLabelProvider)new TreeColumnViewerLabelProvider((IBaseLabelProvider)new LayerCompositionLabelProvider()));
        viewerColumn.setEditingSupport(this.createEditingSupport(columnIndex));
        return viewerColumn;
    }

    private EditingSupport createEditingSupport(final int columnIndex) {
        return new EditingSupport((ColumnViewer)this._treeViewer){

            protected boolean canEdit(Object element) {
                return element instanceof Element ? ((Element)element).canEdit(columnIndex) : false;
            }

            protected CellEditor getCellEditor(Object element) {
                return element instanceof Element ? ((Element)element).getCellEditor(columnIndex) : null;
            }

            protected Object getValue(Object element) {
                return element instanceof Element ? ((Element)element).getCellEditorValue(columnIndex) : null;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof Element) {
                    ((Element)element).setCellEditorValue(columnIndex, value);
                }
            }
        };
    }

    private void setupGlobalActionsAndContextMenu() {
        IViewSite site = this.getViewSite();
        IActionBars actionBars = site.getActionBars();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        actionBars.setGlobalActionHandler("ch.kuramo.javie.app.commands.newCameraLayer", (IAction)this._newCameraLayerAction);
        actionBars.setGlobalActionHandler("ch.kuramo.javie.app.commands.newNullLayer", (IAction)this._newNullLayerAction);
        actionBars.setGlobalActionHandler("ch.kuramo.javie.app.commands.newTextLayer", (IAction)this._newTextLayerAction);
        if (AVIOutputAction.isAvailable()) {
            actionBars.setGlobalActionHandler("ch.kuramo.javie.app.commands.AVIOutput", (IAction)new AVIOutputAction(this));
        }
        if (QTMovieOutputAction.isAvailable()) {
            actionBars.setGlobalActionHandler("ch.kuramo.javie.app.commands.QTMovieOutput", (IAction)new QTMovieOutputAction(this));
        }
        actionBars.setGlobalActionHandler("ch.kuramo.javie.app.commands.sequenceOutput", (IAction)new SequenceOutputAction(this));
        actionBars.setGlobalActionHandler("ch.kuramo.javie.app.commands.waveOutput", (IAction)new WaveOutputAction(this));
        List effectActions = Util.newList();
        for (EffectDescriptor ed : this._effectRegistry.getEffectDescriptors()) {
            AddEffectAction action = new AddEffectAction(window, (Viewer)this._treeViewer, ed);
            actionBars.setGlobalActionHandler("EFFECT." + ed.getType(), (IAction)action);
            effectActions.add(action);
        }
        MenuManager menuMgr = new MenuManager();
        MenuManager newMenu = new MenuManager("\u65b0\u898f");
        MenuManager timeMenu = new MenuManager("\u6642\u9593");
        MenuManager effectMenu = new MenuManager("\u30a8\u30d5\u30a7\u30af\u30c8");
        MenuManager animeMenu = new MenuManager("\u30a2\u30cb\u30e1\u30fc\u30b7\u30e7\u30f3");
        MenuManager interpolationMenu = new MenuManager("\u30ad\u30fc\u30d5\u30ec\u30fc\u30e0\u88dc\u9593\u6cd5");
        menuMgr.add((IContributionItem)newMenu);
        menuMgr.add((IContributionItem)timeMenu);
        menuMgr.add((IContributionItem)effectMenu);
        menuMgr.add((IContributionItem)animeMenu);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)new ResetAnimatableValuesAction(window, this._treeViewer));
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        newMenu.add((IAction)this._newCameraLayerAction);
        newMenu.add((IAction)this._newNullLayerAction);
        newMenu.add((IAction)this._newTextLayerAction);
        timeMenu.add((IAction)new TimeRemapAction(window, this._treeViewer));
        timeMenu.add((IAction)new ReverseLayerTimeAction(this._treeViewer));
        this.setupEffectContextMenu(effectMenu, effectActions);
        animeMenu.add((IContributionItem)interpolationMenu);
        animeMenu.add((IAction)new RemoveKeyframesAction(this._treeViewer));
        animeMenu.add((IAction)new AddExpressionsAction(window, (Viewer)this._treeViewer));
        interpolationMenu.add((IAction)new KeyframeInterpolationAction(this._treeViewer, Interpolation.HOLD));
        interpolationMenu.add((IAction)new KeyframeInterpolationAction(this._treeViewer, Interpolation.LINEAR));
        interpolationMenu.add((IAction)new KeyframeInterpolationAction(this._treeViewer, Interpolation.CATMULL_ROM));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this._treeViewer);
        Control treeViewControl = this._treeViewer.getControl();
        Menu treeViewMenu = menuMgr.createContextMenu(treeViewControl);
        treeViewControl.setMenu(treeViewMenu);
    }

    private void setupEffectContextMenu(MenuManager effectMenu, List<AddEffectAction> effectActions) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("ch.kuramo.javie.api.effectCategory");
        if (point == null) {
            return;
        }
        Map subMenus = Util.newMap();
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement cfgElem = iConfigurationElementArray[n4];
                if ("effect-category".equals(cfgElem.getName())) {
                    String category = cfgElem.getAttribute("category");
                    String name = cfgElem.getAttribute("name");
                    MenuManager subMenu = new MenuManager(name);
                    subMenus.put(category, subMenu);
                    effectMenu.add((IContributionItem)subMenu);
                }
                ++n4;
            }
            ++n2;
        }
        for (AddEffectAction action : effectActions) {
            MenuManager subMenu = (MenuManager)subMenus.get(action.getEffectDescriptor().getCategory());
            if (subMenu != null) {
                subMenu.add((IAction)action);
                continue;
            }
            effectMenu.add((IAction)action);
        }
    }

    private void setupDragAndDrop() {
        final LocalSelectionTransfer selectionTransfer = LocalSelectionTransfer.getTransfer();
        DragSourceListener sourceListener = new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                if (!LayerCompositionView.this.canDrag(event)) {
                    event.doit = false;
                    return;
                }
                LocalSelectionWrapper selection = new LocalSelectionWrapper((Viewer)LayerCompositionView.this._treeViewer);
                if (selection.isEmpty()) {
                    event.doit = false;
                } else {
                    selectionTransfer.setSelection((ISelection)selection);
                    selectionTransfer.setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
                    event.doit = true;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = selectionTransfer.getSelection();
            }

            public void dragFinished(DragSourceEvent event) {
                selectionTransfer.setSelection(null);
                selectionTransfer.setSelectionSetTime(0L);
            }
        };
        DropTargetAdapter targetListener = new DropTargetAdapter(){

            private <T extends Element> T getTargetElement(DropTargetEvent event, Class<T> elementClass) {
                Object data;
                TreeItem treeItem = (TreeItem)event.item;
                if (treeItem != null && elementClass.isInstance(data = treeItem.getData())) {
                    Element element = (Element)data;
                    return (T)element;
                }
                return null;
            }

            private List<LayerElement> getSourceLayerElements(DropTargetEvent event) {
                List list = Util.newList();
                ITreeSelection selection = (ITreeSelection)LocalSelectionWrapper.getSelection(selectionTransfer, (Viewer)LayerCompositionView.this._treeViewer);
                if (selection != null) {
                    for (Object o : selection.toList()) {
                        if (o instanceof LayerElement) {
                            list.add((LayerElement)o);
                            continue;
                        }
                        return null;
                    }
                }
                return list.isEmpty() ? null : list;
            }

            private List<Item> getSourceItems(DropTargetEvent event) {
                List list = Util.newList();
                ITreeSelection selection = (ITreeSelection)LocalSelectionWrapper.getSelection(selectionTransfer);
                if (selection != null) {
                    for (Object o : selection.toList()) {
                        boolean cfr_ignored_0 = o instanceof Folder;
                        if (o instanceof MediaItem) {
                            list.add((MediaItem)o);
                            continue;
                        }
                        return null;
                    }
                }
                return list.isEmpty() ? null : list;
            }

            private List<EffectElement> getSourceEffectElements(DropTargetEvent event) {
                List list = Util.newList();
                ITreeSelection selection = (ITreeSelection)LocalSelectionWrapper.getSelection(selectionTransfer, (Viewer)LayerCompositionView.this._treeViewer);
                if (selection != null) {
                    Layer layer = null;
                    for (Object o : selection.toList()) {
                        if (o instanceof EffectElement) {
                            EffectElement ee = (EffectElement)o;
                            LayerElement le = (LayerElement)ee.parent.parent;
                            if (layer == null) {
                                layer = le.layer;
                            } else if (le.layer != layer) {
                                return null;
                            }
                            list.add(ee);
                            continue;
                        }
                        return null;
                    }
                }
                return list.isEmpty() ? null : list;
            }

            public void dragOver(DropTargetEvent event) {
                if (!selectionTransfer.isSupportedType(event.currentDataType)) {
                    event.detail = 0;
                    event.feedback = 0;
                    return;
                }
                if (this.getSourceLayerElements(event) != null) {
                    if (event.item != null && this.getTargetElement(event, LayerElement.class) == null) {
                        event.detail = 0;
                        event.feedback = 0;
                    } else {
                        event.detail = event.operations & 2;
                        event.feedback = (event.feedback | 2) & 0xFFFFFFFE & 0xFFFFFFEF;
                    }
                    return;
                }
                if (this.getSourceItems(event) != null) {
                    if (event.item != null && this.getTargetElement(event, LayerElement.class) == null) {
                        event.detail = 0;
                        event.feedback = 0;
                    } else {
                        event.detail = event.operations & 4;
                        event.feedback = (event.feedback | 2) & 0xFFFFFFFE & 0xFFFFFFEF;
                    }
                    return;
                }
                if (this.getSourceEffectElements(event) != null && event.item != null) {
                    if (this.getTargetElement(event, EffectsElement.class) != null) {
                        event.detail = (event.operations & 2) == 2 ? 2 : event.operations & 1;
                        event.feedback = (event.feedback | 1) & 0xFFFFFFEF;
                    } else if (this.getTargetElement(event, EffectElement.class) != null) {
                        event.detail = (event.operations & 2) == 2 ? 2 : event.operations & 1;
                        event.feedback = (event.feedback | 2) & 0xFFFFFFFE & 0xFFFFFFEF;
                    } else {
                        event.detail = 0;
                        event.feedback = 0;
                    }
                    return;
                }
                event.detail = 0;
                event.feedback = 0;
            }

            public void dropAccept(DropTargetEvent event) {
                this.dragOver(event);
            }

            public void drop(DropTargetEvent event) {
                List<LayerElement> sourceLayerElements = this.getSourceLayerElements(event);
                if (sourceLayerElements != null) {
                    LayerCompositionView.this.moveLayers(sourceLayerElements, this.getTargetElement(event, LayerElement.class));
                    return;
                }
                List<Item> sourceItems = this.getSourceItems(event);
                if (sourceItems != null) {
                    LayerCompositionView.this.newLayers(sourceItems, this.getTargetElement(event, LayerElement.class));
                    return;
                }
                List<EffectElement> sourceEffectElements = this.getSourceEffectElements(event);
                if (sourceEffectElements != null) {
                    EffectElement ee;
                    int targetIndex = -1;
                    EffectsElement effectsElement = this.getTargetElement(event, EffectsElement.class);
                    if (effectsElement == null && (ee = this.getTargetElement(event, EffectElement.class)) != null) {
                        effectsElement = (EffectsElement)ee.parent;
                        LayerElement le = (LayerElement)effectsElement.parent;
                        targetIndex = ((EffectableLayer)le.layer).getEffects().indexOf(ee.effect);
                    }
                    if (effectsElement != null) {
                        EffectableLayer dstLayer = (EffectableLayer)((LayerElement)effectsElement.parent).layer;
                        if (event.detail != 1) {
                            LayerCompositionView.this.moveEffects(sourceEffectElements, dstLayer, targetIndex);
                        }
                        return;
                    }
                }
                event.detail = 0;
            }
        };
        this._treeViewer.addDragSupport(3, new Transfer[]{selectionTransfer}, sourceListener);
        this._treeViewer.addDropSupport(7, new Transfer[]{selectionTransfer}, (DropTargetListener)targetListener);
    }

    private void setLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 12);
        data.bottom = new FormAttachment(0, 30);
        this._topLeftSpacer.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(100, COCOA ? -15 : -16);
        data.bottom = new FormAttachment(100, 0);
        this._bottomLeftSpacer.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this._topLeftSpacer, 0, 131072);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 12);
        data.bottom = new FormAttachment(0, 30);
        this._timelineMeter.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this._bottomLeftSpacer, 0, 131072);
        data.right = new FormAttachment((Control)this._bottomLeftSpacer, 150, 131072);
        data.top = new FormAttachment(100, COCOA ? -15 : -27);
        data.bottom = new FormAttachment(100, 0);
        this._timelineScale.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this._timelineScale, 0, 131072);
        data.right = new FormAttachment(100, COCOA ? -15 : -16);
        data.top = new FormAttachment(100, COCOA ? -15 : -16);
        data.bottom = new FormAttachment(100, 0);
        this._timelineSlider.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this._topLeftSpacer, 0, 1024);
        data.bottom = new FormAttachment((Control)this._timelineSlider, 0, 128);
        this._treeViewer.getTree().setLayoutData((Object)data);
    }

    private void adjustColumnWidth() {
        Tree tree = this._treeViewer.getTree();
        int clientWidth = tree.getClientArea().width;
        if (clientWidth == 0) {
            return;
        }
        TreeColumn[] columns = tree.getColumns();
        int totalColumnWidth = 0;
        TreeColumn[] treeColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            totalColumnWidth += column.getWidth();
            ++n2;
        }
        TreeColumn lastColumn = columns[columns.length - 1];
        int lastColumnWidth = lastColumn.getWidth() + clientWidth - totalColumnWidth;
        if (lastColumnWidth > 0) {
            lastColumn.setWidth(lastColumnWidth);
        }
        FormData data1 = (FormData)this._topLeftSpacer.getLayoutData();
        FormData data2 = (FormData)this._bottomLeftSpacer.getLayoutData();
        data2.right.numerator = 0;
        data1.right.numerator = 0;
        data1.right.offset = data2.right.offset = clientWidth - lastColumnWidth;
        final Composite parent = this._bottomLeftSpacer.getParent();
        parent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!parent.isDisposed()) {
                    parent.layout(new Control[]{LayerCompositionView.this._topLeftSpacer, LayerCompositionView.this._bottomLeftSpacer});
                }
            }
        });
    }

    private void updateCursor(MouseEvent e) {
        Object element;
        Point pt = new Point(e.x, e.y);
        TreeItem item = this.getItem(pt);
        if (item != null && (element = item.getData()) instanceof Element) {
            int i = 0;
            int cc = this._treeViewer.getTree().getColumnCount();
            while (i < cc) {
                if (item.getBounds(i).contains(pt)) {
                    ((Element)element).updateCursor(e, i);
                    return;
                }
                ++i;
            }
        }
        this._treeViewer.getTree().setCursor(null);
    }

    private void emulateFullSelectionMouseDown(MouseEvent e, TreeItem item, int columnIndex) {
        final Tree tree = this._treeViewer.getTree();
        Collection<TreeItem> treeItems = null;
        if ((e.stateMask & SWT.MOD1) != 0) {
            treeItems = Util.newSet(Arrays.asList(tree.getSelection()));
            if (treeItems.contains(item)) {
                treeItems.remove(item);
            } else {
                treeItems.add(item);
            }
            this._shiftSelectionBaseItem = item;
        } else if ((e.stateMask & SWT.MOD2) != 0 && this._shiftSelectionBaseItem != null) {
            List<TreeItem> list = new Object(){
                final List<TreeItem> items = Util.newList();

                List<TreeItem> getVisibleExpandedItems() {
                    this.getVisibleExpandedItems(tree.getItems());
                    return this.items;
                }

                void getVisibleExpandedItems(TreeItem[] treeItems) {
                    TreeItem[] treeItemArray = treeItems;
                    int n = treeItems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem ti = treeItemArray[n2];
                        this.items.add(ti);
                        if (ti.getExpanded()) {
                            this.getVisibleExpandedItems(ti.getItems());
                        }
                        ++n2;
                    }
                }
            }.getVisibleExpandedItems();
            int i1 = list.indexOf(this._shiftSelectionBaseItem);
            int i2 = list.indexOf(item);
            if (i1 != -1 && i2 != -1) {
                treeItems = list.subList(Math.min(i1, i2), Math.max(i1, i2) + 1);
            }
        } else if (columnIndex == 7 && (e.stateMask & SWT.BUTTON_MASK) == 0 && Arrays.asList(tree.getSelection()).contains(item)) {
            return;
        }
        if (treeItems == null) {
            treeItems = Collections.singleton(item);
            this._shiftSelectionBaseItem = item;
        }
        if (columnIndex != 0 || !item.getBounds().contains(new Point(e.x, e.y))) {
            this.selectAndReveal(treeItems);
        }
    }

    private void handleMouseDown(MouseEvent e) {
        Object element;
        Point pt = new Point(e.x, e.y);
        TreeItem item = this.getItem(pt);
        if (item != null && (element = item.getData()) instanceof Element) {
            int i = 0;
            int cc = this._treeViewer.getTree().getColumnCount();
            while (i < cc) {
                if (item.getBounds(i).contains(pt)) {
                    if (WIN32) {
                        this.emulateFullSelectionMouseDown(e, item, i);
                    }
                    ((Element)element).mouseDown(e, i);
                    return;
                }
                ++i;
            }
        }
        this._timelineManager.mouseDown(e);
    }

    private void handleKeyPressed(KeyEvent e) {
        if (e.stateMask == 0 && (e.keyCode == 127 || COCOA && e.keyCode == 8)) {
            this.removeSelectedObjects();
        }
    }

    private void removeSelectedObjects() {
        if (this._timelineManager.hasKeyframeSelection()) {
            this._timelineManager.removeSelectedKeyframes();
            return;
        }
        TreeSelection selection = (TreeSelection)this._treeViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        List layerElements = Util.newList();
        List effectElements = Util.newList();
        for (Object o : selection.toList()) {
            if (o instanceof LayerElement) {
                layerElements.add((LayerElement)o);
                continue;
            }
            if (o instanceof EffectElement) {
                effectElements.add((EffectElement)o);
                continue;
            }
            if (!(o instanceof EffectsElement)) continue;
            Element[] elementArray = ((EffectsElement)o).getChildren();
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Element child = elementArray[n2];
                effectElements.add((EffectElement)child);
                ++n2;
            }
        }
        if (effectElements.size() > 0) {
            List effects = Util.newList();
            for (EffectElement ee : effectElements) {
                effects.add(new Object[]{((LayerElement)ee.parent.parent).layer, ee.effect});
            }
            this._projectManager.postOperation(new RemoveEffectsOperation(this._projectManager, effects));
        } else if (layerElements.size() > 0) {
            List layers = Util.newList();
            for (LayerElement le : layerElements) {
                layers.add(le.layer);
            }
            Collections.reverse(layers);
            this._projectManager.postOperation(new RemoveLayersOperation(this._projectManager, layers));
        }
    }

    private boolean canDrag(DragSourceEvent e) {
        Point pt = COCOA && this._mouseDownPoint != null ? this._mouseDownPoint : new Point(e.x, e.y);
        TreeItem item = this.getItem(pt);
        if (item == null || !item.getBounds(0).contains(pt)) {
            return false;
        }
        TreeSelection selection = (TreeSelection)this._treeViewer.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        Object first = selection.getFirstElement();
        if (first instanceof LayerElement) {
            for (Object o : selection.toList()) {
                if (o instanceof LayerElement) continue;
                return false;
            }
            return true;
        }
        if (first instanceof EffectElement) {
            Element parent = ((Element)first).parent;
            for (Object o : selection.toList()) {
                if (!(o instanceof EffectElement)) {
                    return false;
                }
                if (((Element)o).parent == parent) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private TreeItem getItem(Point pt) {
        return this.getItem(pt, this._treeViewer.getTree().getItems());
    }

    private TreeItem getItem(Point pt, TreeItem[] items) {
        int i = items.length - 1;
        while (i >= 0) {
            TreeItem item = items[i];
            Rectangle bounds = item.getBounds();
            if (bounds.y <= pt.y) {
                if (bounds.y + bounds.height > pt.y) {
                    return item;
                }
                if (item.getExpanded()) {
                    return this.getItem(pt, item.getItems());
                }
            }
            --i;
        }
        return null;
    }

    private void moveLayers(List<LayerElement> layerElements, LayerElement moveBefore) {
        List current = Util.newList();
        TreeItem[] treeItemArray = this._treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            current.add((LayerElement)treeItem.getData());
            ++n2;
        }
        int moveToIndex = moveBefore != null ? current.indexOf(moveBefore) : current.size();
        List frontSub = Util.newList(current.subList(0, moveToIndex));
        List backSub = Util.newList(current.subList(moveToIndex, current.size()));
        frontSub.removeAll(layerElements);
        backSub.removeAll(layerElements);
        List newOrderOfElements = Util.newList();
        newOrderOfElements.addAll(frontSub);
        newOrderOfElements.addAll(layerElements);
        newOrderOfElements.addAll(backSub);
        Collections.reverse(newOrderOfElements);
        List newOrder = Util.newList();
        for (LayerElement e : newOrderOfElements) {
            newOrder.add(e.layer);
        }
        List layers = Util.newList();
        for (LayerElement e : layerElements) {
            layers.add(e.layer);
        }
        this._projectManager.postOperation(new ReorderLayersOperation(this._projectManager, newOrder, layers));
    }

    private void newLayers(List<Item> items, LayerElement insertBefore) {
        TreeItem[] treeItems = this._treeViewer.getTree().getItems();
        int insertIndex = -1;
        if (insertBefore == null) {
            insertIndex = treeItems.length;
        } else {
            int i = 0;
            while (i < treeItems.length) {
                if (treeItems[i].getData() == insertBefore) {
                    insertIndex = i;
                    break;
                }
                ++i;
            }
            if (insertIndex == -1) {
                throw new IllegalArgumentException("no such layerElement found");
            }
        }
        insertIndex = treeItems.length - insertIndex;
        items = Util.newList(items);
        Collections.reverse(items);
        this._projectManager.postOperation(new NewLayerFromItemOperation(this._projectManager, this._composition, insertIndex, items));
    }

    private void moveEffects(List<EffectElement> effectElements, EffectableLayer dstLayer, int moveBefore) {
        LayerElement le = (LayerElement)effectElements.get((int)0).parent.parent;
        EffectableLayer srcLayer = (EffectableLayer)le.layer;
        List effects = Util.newList();
        for (EffectElement ee : effectElements) {
            if (((LayerElement)ee.parent.parent).layer != srcLayer) {
                throw new IllegalArgumentException();
            }
            effects.add(ee.effect);
        }
        this._projectManager.postOperation(new MoveEffectsOperation(this._projectManager, srcLayer, effects, dstLayer, moveBefore));
    }

    private void collectAnimatableValues() {
        this.collectAnimatableValues(this._timelineManager.getCurrentTime());
    }

    private void collectAnimatableValues(Time time) {
        this._collector.reset();
        this._collector.setTime(time);
        this._composition.prepareExpression(this._collector.createInitialExpressionScope((Composition)this._composition));
        this._treeViewer.setData(ANIMATABLE_VALUES, (Object)this._collector.collect());
        this.updateProperties();
    }

    private void updateProperties() {
        this.updateProperties(this._treeViewer.getTree().getItems());
    }

    private void updateProperties(TreeItem[] treeItems) {
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            AnimatableValueElement avalueElement;
            TreeItem item = treeItemArray[n2];
            Object element = item.getData();
            if (element instanceof AnimatableValueElement && (avalueElement = (AnimatableValueElement)element).updateValue()) {
                Rectangle bounds = item.getBounds(1);
                this._treeViewer.getTree().redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
            }
            if (item.getExpanded()) {
                this.updateProperties(item.getItems());
            }
            ++n2;
        }
    }

    private TreeItem findLayerAnimatableValueItem(TreeItem layerItem, final String property) {
        return new Object(){

            TreeItem find(TreeItem treeItem) {
                Object element = treeItem.getData();
                if (element instanceof LayerAnimatableValueElement && ((LayerAnimatableValueElement)element).getProperty().equals(property)) {
                    return treeItem;
                }
                if (treeItem.getItemCount() > 0) {
                    boolean expanded = LayerCompositionView.this._treeViewer.getExpandedState(element);
                    LayerCompositionView.this._treeViewer.getTree().setRedraw(false);
                    try {
                        LayerCompositionView.this._treeViewer.setExpandedState(element, true);
                        TreeItem[] treeItemArray = treeItem.getItems();
                        int n = treeItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem ti = treeItemArray[n2];
                            if ((ti = this.find(ti)) != null) {
                                TreeItem treeItem2 = ti;
                                return treeItem2;
                            }
                            ++n2;
                        }
                        return null;
                    }
                    finally {
                        LayerCompositionView.this._treeViewer.setExpandedState(element, expanded);
                        LayerCompositionView.this._treeViewer.getTree().setRedraw(true);
                    }
                }
                return null;
            }
        }.find(layerItem);
    }

    private TreeItem findEffectAnimatableValueItem(TreeItem layerItem, final Effect effect, final String property) {
        return new Object(){

            TreeItem find(TreeItem treeItem) {
                Object element = treeItem.getData();
                if (element instanceof EffectAnimatableValueElement && ((EffectAnimatableValueElement)element).getProperty().equals(property)) {
                    return treeItem;
                }
                if ((element instanceof LayerElement || element instanceof EffectsElement || element instanceof EffectElement) && treeItem.getItemCount() > 0) {
                    if (element instanceof EffectElement && ((EffectElement)element).effect != effect) {
                        return null;
                    }
                    boolean expanded = LayerCompositionView.this._treeViewer.getExpandedState(element);
                    LayerCompositionView.this._treeViewer.getTree().setRedraw(false);
                    try {
                        LayerCompositionView.this._treeViewer.setExpandedState(element, true);
                        TreeItem[] treeItemArray = treeItem.getItems();
                        int n = treeItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem ti = treeItemArray[n2];
                            if ((ti = this.find(ti)) != null) {
                                TreeItem treeItem2 = ti;
                                return treeItem2;
                            }
                            ++n2;
                        }
                        return null;
                    }
                    finally {
                        LayerCompositionView.this._treeViewer.setExpandedState(element, expanded);
                        LayerCompositionView.this._treeViewer.getTree().setRedraw(true);
                    }
                }
                return null;
            }
        }.find(layerItem);
    }

    private TreeItem findEffectItem(TreeItem layerItem, final Effect effect) {
        return new Object(){

            TreeItem find(TreeItem treeItem) {
                Object element = treeItem.getData();
                if (element instanceof EffectElement) {
                    return ((EffectElement)element).effect == effect ? treeItem : null;
                }
                if ((element instanceof LayerElement || element instanceof EffectsElement) && treeItem.getItemCount() > 0) {
                    boolean expanded = LayerCompositionView.this._treeViewer.getExpandedState(element);
                    LayerCompositionView.this._treeViewer.getTree().setRedraw(false);
                    try {
                        LayerCompositionView.this._treeViewer.setExpandedState(element, true);
                        TreeItem[] treeItemArray = treeItem.getItems();
                        int n = treeItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem ti = treeItemArray[n2];
                            if ((ti = this.find(ti)) != null) {
                                TreeItem treeItem2 = ti;
                                return treeItem2;
                            }
                            ++n2;
                        }
                        return null;
                    }
                    finally {
                        LayerCompositionView.this._treeViewer.setExpandedState(element, expanded);
                        LayerCompositionView.this._treeViewer.getTree().setRedraw(true);
                    }
                }
                return null;
            }
        }.find(layerItem);
    }

    private void selectAndReveal(TreeItem treeItem) {
        if (treeItem == null) {
            this._treeViewer.setSelection(null);
            return;
        }
        this.selectAndReveal(Collections.singleton(treeItem));
    }

    private void selectAndReveal(Collection<TreeItem> treeItems) {
        if (treeItems == null || treeItems.isEmpty()) {
            this._treeViewer.setSelection(null);
            return;
        }
        List list = Util.newList();
        for (TreeItem treeItem : treeItems) {
            LinkedList segmentList = Util.newLinkedList();
            do {
                segmentList.addFirst(treeItem.getData());
            } while ((treeItem = treeItem.getParentItem()) != null);
            list.add(new TreePath(segmentList.toArray()));
        }
        this._treeViewer.setSelection((ISelection)new TreeSelection(list.toArray(new TreePath[list.size()])), true);
    }

    private void handleLayerPropertyChange(ProjectEvent event) {
        if (event.composition != this._composition) {
            return;
        }
        Tree tree = this._treeViewer.getTree();
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            LayerElement layerElement = (LayerElement)treeItem.getData();
            if (layerElement.layer == event.layer) {
                if (ProjectEvent.propertyIsAnimatable(event)) {
                    treeItem = this.findLayerAnimatableValueItem(treeItem, event.property);
                } else {
                    if (layerElement.layer instanceof TransformableLayer && event.property.equals("threeD")) {
                        this._treeViewer.refresh((Object)layerElement, true);
                    } else {
                        this._treeViewer.update((Object)layerElement, null);
                    }
                    Rectangle bounds = treeItem.getBounds();
                    if (WIN32) {
                        Rectangle clientArea = tree.getClientArea();
                        bounds.x = clientArea.x;
                        bounds.width = clientArea.width;
                    }
                    tree.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
                }
                this.selectAndReveal(treeItem);
                break;
            }
            ++n2;
        }
        this.collectAnimatableValues();
    }

    private void handleLayerExpressionChange(ProjectEvent event) {
        if (event.composition != this._composition) {
            return;
        }
        TreeItem[] treeItemArray = this._treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            LayerElement layerElement = (LayerElement)treeItem.getData();
            if (layerElement.layer == event.layer) {
                if ((treeItem = this.findLayerAnimatableValueItem(treeItem, event.property)) == null) break;
                Element element = (Element)treeItem.getData();
                this._treeViewer.setExpandedState((Object)element, false);
                this._treeViewer.refresh((Object)element, false);
                if (treeItem.getItemCount() > 0) {
                    this._treeViewer.setExpandedState((Object)element, true);
                    treeItem = treeItem.getItem(0);
                }
                this.selectAndReveal(treeItem);
                break;
            }
            ++n2;
        }
        this.collectAnimatableValues();
    }

    private void handleLayersAddRemoveReorder(ProjectEvent event) {
        if (event.composition != this._composition) {
            return;
        }
        this._treeViewer.getTree().setRedraw(false);
        try {
            Object[] expandedElements = this._treeViewer.getExpandedElements();
            this._treeViewer.refresh();
            this._treeViewer.setExpandedElements(expandedElements);
            if (event.type == ProjectEvent.Type.LAYERS_ADD || event.type == ProjectEvent.Type.LAYERS_REORDER) {
                Set<Layer> layers = ProjectEvent.getLayers(event);
                Set treeItems = Util.newSet();
                TreeItem[] treeItemArray = this._treeViewer.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    LayerElement layerElement = (LayerElement)treeItem.getData();
                    if (layers.contains(layerElement.layer)) {
                        treeItems.add(treeItem);
                    }
                    ++n2;
                }
                this.selectAndReveal(treeItems);
            }
        }
        finally {
            this._treeViewer.getTree().setRedraw(true);
        }
        this.collectAnimatableValues();
    }

    private void handleItemNameChange(ProjectEvent event) {
        if (event.getProjectManager() != this._projectManager) {
            return;
        }
        Item item = ProjectEvent.getItem(event);
        Set elements = Util.newSet();
        TreeItem[] treeItemArray = this._treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemLayer parentLayer;
            ItemLayer itemLayer;
            TreeItem treeItem = treeItemArray[n2];
            LayerElement element = (LayerElement)treeItem.getData();
            if (element.layer instanceof ItemLayer && (itemLayer = (ItemLayer)element.layer).getItem() == item) {
                elements.add(element);
            }
            if (element.layer.getParent() instanceof ItemLayer && (parentLayer = (ItemLayer)element.layer.getParent()).getItem() == item) {
                elements.add(element);
            }
            ++n2;
        }
        if (!elements.isEmpty()) {
            this._treeViewer.update(elements.toArray(), null);
        }
    }

    private void handleExpressionsAddRemove(ProjectEvent event) {
        if (event.composition != this._composition) {
            return;
        }
        boolean add = event.type == ProjectEvent.Type.EXPRESSIONS_ADD;
        Map layerToTreeItem = Util.newMap();
        TreeItem[] treeItemArray = this._treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            LayerElement element = (LayerElement)treeItem.getData();
            layerToTreeItem.put(element.layer, treeItem);
            ++n2;
        }
        Set treeItems = Util.newSet();
        Object[][] objectArray = (Object[][])event.data;
        int n3 = objectArray.length;
        n = 0;
        while (n < n3) {
            Object[] o = objectArray[n];
            TreeItem treeItem = (TreeItem)layerToTreeItem.get(o[0]);
            if (o[1] instanceof String) {
                String property = (String)o[1];
                treeItem = this.findLayerAnimatableValueItem(treeItem, property);
            } else if (o[1] instanceof Integer) {
                EffectableLayer layer = (EffectableLayer)o[0];
                Effect effect = (Effect)layer.getEffects().get((Integer)o[1]);
                String property = (String)o[2];
                treeItem = this.findEffectAnimatableValueItem(treeItem, effect, property);
            } else {
                throw new Error();
            }
            if (treeItem != null) {
                if (add) {
                    treeItem = treeItem.getItem(0);
                }
                treeItems.add(treeItem);
            }
            ++n;
        }
        this.selectAndReveal(treeItems);
    }

    private void handleEffectsAddRemove(ProjectEvent event) {
        if (event.composition != this._composition) {
            return;
        }
        this.selectAndReveal((TreeItem)null);
        boolean add = event.type == ProjectEvent.Type.EFFECTS_ADD;
        Map layerToTreeItem = Util.newMap();
        TreeItem[] treeItemArray = this._treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            LayerElement element = (LayerElement)treeItem.getData();
            layerToTreeItem.put(element.layer, treeItem);
            ++n2;
        }
        Set treeItems = Util.newSet();
        Object[][] objectArray = (Object[][])event.data;
        int n3 = objectArray.length;
        n = 0;
        while (n < n3) {
            Object[] o = objectArray[n];
            TreeItem treeItem = (TreeItem)layerToTreeItem.get(o[0]);
            LayerElement element = (LayerElement)treeItem.getData();
            Integer effectIndex = (Integer)o[1];
            this._treeViewer.refresh((Object)element);
            this._treeViewer.setExpandedState((Object)element, true);
            TreeItem itemToSelect = treeItem;
            TreeItem[] treeItemArray2 = treeItem.getItems();
            int n4 = treeItemArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                TreeItem child = treeItemArray2[n5];
                if (child.getData() instanceof EffectsElement) {
                    if (add) {
                        this._treeViewer.setExpandedState(child.getData(), true);
                        itemToSelect = child.getItem(effectIndex.intValue());
                        break;
                    }
                    itemToSelect = child;
                    break;
                }
                ++n5;
            }
            treeItems.add(itemToSelect);
            ++n;
        }
        this.selectAndReveal(treeItems);
        this.collectAnimatableValues();
    }

    private void handleEffectPropertyChange(ProjectEvent event) {
        if (event.composition != this._composition) {
            return;
        }
        EffectableLayer layer = (EffectableLayer)event.layer;
        Effect effect = (Effect)layer.getEffects().get(event.effectIndex);
        TreeItem[] treeItemArray = this._treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            LayerElement layerElement = (LayerElement)treeItem.getData();
            if (layerElement.layer == layer) {
                if (ProjectEvent.propertyIsAnimatable(event)) {
                    treeItem = this.findEffectAnimatableValueItem(treeItem, effect, event.property);
                } else if (event.property.equals("enabled")) {
                    treeItem = this.findEffectItem(treeItem, effect);
                }
                this.selectAndReveal(treeItem);
                break;
            }
            ++n2;
        }
        this.collectAnimatableValues();
    }

    private void handleEffectExpressionChange(ProjectEvent event) {
        if (event.composition != this._composition) {
            return;
        }
        EffectableLayer layer = (EffectableLayer)event.layer;
        Effect effect = (Effect)layer.getEffects().get(event.effectIndex);
        TreeItem[] treeItemArray = this._treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            LayerElement layerElement = (LayerElement)treeItem.getData();
            if (layerElement.layer == layer) {
                treeItem = this.findEffectAnimatableValueItem(treeItem, effect, event.property);
                Element element = (Element)treeItem.getData();
                this._treeViewer.setExpandedState((Object)element, false);
                this._treeViewer.refresh((Object)element, false);
                if (treeItem.getItemCount() > 0) {
                    this._treeViewer.setExpandedState((Object)element, true);
                    treeItem = treeItem.getItem(0);
                }
                this.selectAndReveal(treeItem);
                break;
            }
            ++n2;
        }
        this.collectAnimatableValues();
    }

    private void handleLayerTimesChange(ProjectEvent event) {
        if (event.composition != this._composition) {
            return;
        }
        Tree tree = this._treeViewer.getTree();
        Map layerToTreeItem = Util.newMap();
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            LayerElement element = (LayerElement)treeItem.getData();
            layerToTreeItem.put(element.layer, treeItem);
            ++n2;
        }
        Set treeItems = Util.newSet();
        Collection layers = (Collection)event.data;
        for (Layer layer : layers) {
            TreeItem treeItem = (TreeItem)layerToTreeItem.get(layer);
            treeItems.add(treeItem);
        }
        this._timelineManager.redraw();
        this.selectAndReveal(treeItems);
        this.collectAnimatableValues();
    }

    private void handleKeyframesChange(ProjectEvent event) {
        Object[][] data;
        if (event.composition != this._composition) {
            return;
        }
        Map layerToTreeItem = Util.newMap();
        TreeItem[] treeItemArray = this._treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            LayerElement element = (LayerElement)treeItem.getData();
            layerToTreeItem.put(element.layer, treeItem);
            ++n2;
        }
        Set treeItems = Util.newSet();
        this._timelineManager.clearKeyframeSelection();
        Object[][] objectArray = data = (Object[][])event.data;
        int n3 = data.length;
        int n4 = 0;
        while (n4 < n3) {
            AnimatableValue avalue;
            TreeItem treeItem;
            Object[] o = objectArray[n4];
            Layer layer = (Layer)o[0];
            int effectIndex = (Integer)o[1];
            String property = (String)o[2];
            Time time = (Time)o[3];
            TreeItem layerItem = (TreeItem)layerToTreeItem.get(layer);
            if (effectIndex == -1) {
                treeItem = this.findLayerAnimatableValueItem(layerItem, property);
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
                if (property.equals("timeRemap")) {
                    if (treeItem == null && avalue.hasKeyframe()) {
                        this._treeViewer.refresh(layerItem.getData(), false);
                        treeItem = this.findLayerAnimatableValueItem(layerItem, property);
                    } else if (treeItem != null && !avalue.hasKeyframe()) {
                        this._treeViewer.refresh(layerItem.getData(), false);
                        treeItem = null;
                        treeItems.add(layerItem);
                    }
                }
            } else {
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(effectIndex);
                treeItem = this.findEffectAnimatableValueItem(layerItem, effect, property);
                avalue = (AnimatableValue)PropertyUtil.getProperty(effect, property);
            }
            if (treeItem != null) {
                treeItems.add(treeItem);
                AnimatableValueElement element = (AnimatableValueElement)treeItem.getData();
                this._treeViewer.update((Object)element, null);
                if (time != null) {
                    Keyframe kf = avalue.getKeyframe(time);
                    this._timelineManager.addKeyframeSelection(kf, element);
                }
            }
            ++n4;
        }
        this.selectAndReveal(treeItems);
        this.collectAnimatableValues();
    }

    private void handleLayerSlipEdit(ProjectEvent event) {
        Object[][] data;
        if (event.composition != this._composition) {
            return;
        }
        Tree tree = this._treeViewer.getTree();
        Map layerToTreeItem = Util.newMap();
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            LayerElement element = (LayerElement)treeItem.getData();
            layerToTreeItem.put(element.layer, treeItem);
            ++n2;
        }
        Set treeItems = Util.newSet();
        Collection layers = (Collection)((Object[])event.data)[0];
        for (Layer layer : layers) {
            TreeItem treeItem = (TreeItem)layerToTreeItem.get(layer);
            treeItems.add(treeItem);
            this._treeViewer.update(treeItem.getData(), null);
            Rectangle bounds = treeItem.getBounds();
            if (WIN32) {
                Rectangle clientArea = tree.getClientArea();
                bounds.x = clientArea.x;
                bounds.width = clientArea.width;
            }
            tree.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
        }
        this._timelineManager.clearKeyframeSelection();
        Object[][] objectArray = data = (Object[][])((Object[])event.data)[1];
        int n3 = data.length;
        int n4 = 0;
        while (n4 < n3) {
            AnimatableValue avalue;
            TreeItem treeItem;
            Object[] o = objectArray[n4];
            Layer layer = (Layer)o[0];
            int effectIndex = (Integer)o[1];
            String property = (String)o[2];
            Time time = (Time)o[3];
            if (effectIndex == -1) {
                treeItem = this.findLayerAnimatableValueItem((TreeItem)layerToTreeItem.get(layer), property);
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
            } else {
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(effectIndex);
                treeItem = this.findEffectAnimatableValueItem((TreeItem)layerToTreeItem.get(layer), effect, property);
                avalue = (AnimatableValue)PropertyUtil.getProperty(effect, property);
            }
            treeItems.add(treeItem);
            AnimatableValueElement element = (AnimatableValueElement)treeItem.getData();
            this._treeViewer.update((Object)element, null);
            if (time != null) {
                Keyframe kf = avalue.getKeyframe(time);
                this._timelineManager.addKeyframeSelection(kf, element);
            }
            ++n4;
        }
        this.selectAndReveal(treeItems);
        this.collectAnimatableValues();
    }

    private void handleNewCameraLayerAction() {
        if (this._projectManager != null && this._composition != null) {
            this._projectManager.postOperation(new NewCameraLayerOperation(this._projectManager, this._composition));
        }
    }

    private void handleNewNullLayerAction() {
        if (this._projectManager != null && this._composition != null) {
            this._projectManager.postOperation(new NewNullLayerOperation(this._projectManager, this._composition));
        }
    }

    private void handleNewTextLayerAction() {
        if (this._projectManager != null && this._composition != null) {
            this._projectManager.postOperation(new NewTextLayerOperation(this._projectManager, this._composition));
        }
    }

    public CompositionItem getCompositionItem() {
        return this._compItem;
    }

    public LayerComposition getLayerComposition() {
        return this._composition;
    }

    public void editExpression(AnimatableValueElement avalueElement) {
        this._treeViewer.setExpandedState((Object)avalueElement, true);
        AnimatableValueElementDelegate.ExpressionElement exprElement = (AnimatableValueElementDelegate.ExpressionElement)avalueElement.getChildren()[0];
        this._treeViewer.editElement((Object)exprElement, 7);
    }

    public void update(Time time) {
        if (this._playerLinkListeners.isEmpty()) {
            this._time = time;
            this.collectAnimatableValues(time);
            this._timelineManager.update(time, true);
        } else {
            this.collectAnimatableValues(time);
            this.refreshPlayer(time);
        }
    }

    public void addPlayerLinkListener(PlayerLinkListener listener) {
        this._playerLinkListeners.add((Object)listener);
    }

    public void removePlayerLinkListener(PlayerLinkListener listener) {
        this._playerLinkListeners.remove((Object)listener);
    }

    private void refreshPlayer(Time time) {
        PlayerLinkEvent event = new PlayerLinkEvent(this, time);
        Object[] objectArray = this._playerLinkListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((PlayerLinkListener)l).handlePlayerLinkEvent(event);
            ++n2;
        }
    }

    @Override
    public void handlePlayerLinkEvent(PlayerLinkEvent event) {
        this._time = event.time;
        this._timelineUpdateTask.schedule();
        this._collectTask.schedule();
    }

    private void connectToPlayer() {
        String itemId = this.getItemId();
        if (!_connectingIds.contains(itemId)) {
            _connectingIds.add(itemId);
            try {
                MediaPlayerView playerView = (MediaPlayerView)((Object)UIUtil.findView(this.getSite().getPage(), "ch.kuramo.javie.app.views.mediaPlayerView", itemId));
                LayerCompositionView.connectToPlayer(this, playerView);
            }
            finally {
                _connectingIds.remove(itemId);
            }
        }
    }

    static void connectToPlayer(MediaPlayerView playerView) {
        String itemId = playerView.getItemId();
        if (!_connectingIds.contains(itemId)) {
            _connectingIds.add(itemId);
            try {
                LayerCompositionView compView = (LayerCompositionView)UIUtil.findView(playerView.getSite().getPage(), ID, itemId);
                LayerCompositionView.connectToPlayer(compView, playerView);
            }
            finally {
                _connectingIds.remove(itemId);
            }
        }
    }

    private static void connectToPlayer(final LayerCompositionView compView, final MediaPlayerView playerView) {
        if (compView == null || playerView == null) {
            return;
        }
        final MediaPlayer player = playerView.getMediaPlayer();
        compView.addPlayerLinkListener(player);
        player.addPlayerLinkListener(compView);
        final IWorkbenchPage page = compView.getSite().getPage();
        IPartListener partListener = new IPartListener(){

            public void partClosed(IWorkbenchPart part) {
                if (part == playerView || part == compView) {
                    compView.removePlayerLinkListener(player);
                    player.removePlayerLinkListener(compView);
                    page.removePartListener((IPartListener)this);
                }
            }

            public void partActivated(IWorkbenchPart part) {
                if (part == compView) {
                    this.showView((IViewPart)playerView, (IViewPart)compView);
                } else if (part == playerView) {
                    this.showView((IViewPart)compView, (IViewPart)playerView);
                }
            }

            private void showView(IViewPart targetView, IViewPart companionView) {
                IViewPart[] iViewPartArray = page.getViewStack(companionView);
                int n = iViewPartArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewPart vp = iViewPartArray[n2];
                    if (vp == targetView) {
                        return;
                    }
                    ++n2;
                }
                IViewPart[] stack = page.getViewStack(targetView);
                if (stack == null) {
                    return;
                }
                IViewPart[] iViewPartArray2 = stack;
                int n3 = stack.length;
                n = 0;
                while (n < n3) {
                    IViewPart vp = iViewPartArray2[n];
                    if (vp != targetView && page.isPartVisible((IWorkbenchPart)vp) && vp instanceof MediaPlayerView && ((MediaPlayerView)vp).isPinned()) {
                        return;
                    }
                    ++n;
                }
                try {
                    IViewSite viewSite = targetView.getViewSite();
                    page.showView(viewSite.getId(), viewSite.getSecondaryId(), 2);
                }
                catch (PartInitException e) {
                    _logger.error("error activating ViewPart", (Throwable)e);
                }
            }

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }
        };
        page.addPartListener(partListener);
    }
}

