/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views;

import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.LayerElement;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Util;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerCompositionContentProvider
implements ITreeContentProvider {
    private static final Logger _logger = LoggerFactory.getLogger(LayerCompositionContentProvider.class);
    private TreeViewer _viewer;
    private LayerComposition _composition;
    private final WeakHashMap<Layer, WeakReference<LayerElement>> _layerElements = Util.newWeakHashMap();

    public void dispose() {
        this._viewer = null;
        this._composition = null;
        this._layerElements.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this._viewer = (TreeViewer)viewer;
        this._composition = (LayerComposition)newInput;
        this._layerElements.clear();
    }

    public boolean hasChildren(Object element) {
        return ((Element)element).hasChildren();
    }

    public Object[] getChildren(Object parentElement) {
        return ((Element)parentElement).getChildren();
    }

    public Object[] getElements(Object inputElement) {
        List layerElements = Util.newList();
        for (Layer layer : this._composition.getLayers()) {
            LayerElement element;
            WeakReference<LayerElement> ref = this._layerElements.get(layer);
            LayerElement layerElement = element = ref != null ? (LayerElement)ref.get() : null;
            if (element == null) {
                element = new LayerElement(this._viewer, layer);
                this._layerElements.put(layer, new WeakReference<LayerElement>(element));
            }
            layerElements.add(element);
        }
        Collections.reverse(layerElements);
        return layerElements.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof Element) {
            return ((Element)element).parent;
        }
        _logger.debug("getParent: " + element);
        return null;
    }
}

