/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.PropertyDescriptor;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShiftLayerTimesOperation
extends ProjectOperation {
    private final String _compId;
    private final List<Entry> _entries = Util.newList();
    private volatile Time _deltaTime;
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public ShiftLayerTimesOperation(ProjectManager projectManager, LayerComposition comp, List<Layer> layers, Time deltaTime, String relation) {
        super(projectManager, "\u30ec\u30a4\u30e4\u30fc\u6642\u9593\u306e\u5909\u66f4", relation);
        InjectorHolder.getInjector().injectMembers((Object)this);
        projectManager.checkComposition((Composition)comp);
        this._compId = comp.getId();
        this._deltaTime = deltaTime;
        for (Layer layer : layers) {
            if (projectManager.checkLayer(layer) != comp) {
                throw new IllegalArgumentException();
            }
            Entry e = new Entry(layer.getId(), new Time[]{layer.getStartTime(), layer.getInPoint(), layer.getOutPoint()});
            Method[] methodArray = layer.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (this.isAnimatableValueGetter(m)) {
                    e.oldAvalues.add(this._encoder.encodeElement(this.getAnimatableValue(layer, m)));
                }
                ++n2;
            }
            if (layer instanceof EffectableLayer) {
                for (Effect effect : ((EffectableLayer)layer).getEffects()) {
                    for (PropertyDescriptor pd : effect.getEffectDescriptor().getPropertyDescriptors()) {
                        if (!this.isAnimatableValueProperty(pd)) continue;
                        e.oldAvalues.add(this._encoder.encodeElement(pd.get(effect)));
                    }
                }
            }
            this._entries.add(e);
        }
    }

    private boolean isAnimatableValueGetter(Method m) {
        return m.getName().startsWith("get") && m.getParameterTypes().length == 0 && AnimatableValue.class.isAssignableFrom(m.getReturnType());
    }

    private AnimatableValue<?> getAnimatableValue(Layer layer, Method m) {
        try {
            return (AnimatableValue)m.invoke((Object)layer, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }

    private boolean isAnimatableValueProperty(PropertyDescriptor pd) {
        return AnimatableValue.class.isAssignableFrom(pd.getPropertyClass());
    }

    private <V> void shiftKeyframes(AnimatableValue<V> avalue) {
        List list = Util.newList();
        for (Keyframe kf : avalue.getKeyframes()) {
            list.add(new Keyframe(kf.time.add(this._deltaTime), kf.value, kf.interpolation));
        }
        avalue.clearKeyframes(avalue.getStaticValue());
        for (Keyframe kf : list) {
            avalue.putKeyframe(kf);
        }
    }

    private <A extends AnimatableValue<V>, V> void restore(String data, A dst) throws ExecutionException {
        try {
            AnimatableValue src = (AnimatableValue)this._decoder.decodeElement((CharSequence)data, dst.getClass());
            dst.reset(src.getStaticValue());
            dst.setExpression(src.getExpression());
            for (Keyframe kf : src.getKeyframes()) {
                dst.putKeyframe(kf);
            }
        }
        catch (ProjectDecodeException e) {
            throw new ExecutionException("error decoding AnimatableValue data", (Throwable)e);
        }
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        List layers = Util.newList();
        for (Entry e : this._entries) {
            AnimatableValue avalue;
            Layer layer = comp.getLayer(e.layerId);
            layer.setStartTime(e.oldTimes[0].add(this._deltaTime));
            layer.setInPoint(e.oldTimes[1].add(this._deltaTime));
            layer.setOutPoint(e.oldTimes[2].add(this._deltaTime));
            Iterator<String> it = e.oldAvalues.iterator();
            Method[] methodArray = layer.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (this.isAnimatableValueGetter(m)) {
                    avalue = this.getAnimatableValue(layer, m);
                    this.restore(it.next(), avalue);
                    this.shiftKeyframes(avalue);
                }
                ++n2;
            }
            if (layer instanceof EffectableLayer) {
                for (Effect effect : ((EffectableLayer)layer).getEffects()) {
                    for (PropertyDescriptor pd : effect.getEffectDescriptor().getPropertyDescriptors()) {
                        if (!this.isAnimatableValueProperty(pd)) continue;
                        avalue = (AnimatableValue)pd.get(effect);
                        this.restore(it.next(), avalue);
                        this.shiftKeyframes(avalue);
                    }
                }
            }
            layers.add(layer);
        }
        if (pm != null) {
            pm.fireLayerTimesChange(comp, layers);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        List layers = Util.newList();
        for (Entry e : this._entries) {
            Layer layer = comp.getLayer(e.layerId);
            layer.setStartTime(e.oldTimes[0]);
            layer.setInPoint(e.oldTimes[1]);
            layer.setOutPoint(e.oldTimes[2]);
            Iterator<String> it = e.oldAvalues.iterator();
            Method[] methodArray = layer.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (this.isAnimatableValueGetter(m)) {
                    this.restore(it.next(), this.getAnimatableValue(layer, m));
                }
                ++n2;
            }
            if (layer instanceof EffectableLayer) {
                for (Effect effect : ((EffectableLayer)layer).getEffects()) {
                    for (PropertyDescriptor pd : effect.getEffectDescriptor().getPropertyDescriptors()) {
                        if (!this.isAnimatableValueProperty(pd)) continue;
                        this.restore(it.next(), (AnimatableValue)pd.get(effect));
                    }
                }
            }
            layers.add(layer);
        }
        if (pm != null) {
            pm.fireLayerTimesChange(comp, layers);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected boolean merge(ProjectOperation operation, IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) {
        if (pm == null) {
            try {
                this.executeOrRedo(monitor, info, project, null);
            }
            catch (ExecutionException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            return true;
        }
        if (!(operation instanceof ShiftLayerTimesOperation)) {
            return false;
        }
        ShiftLayerTimesOperation newOp = (ShiftLayerTimesOperation)operation;
        if (!newOp._compId.equals(this._compId) || newOp._entries.size() != this._entries.size()) {
            return false;
        }
        int i = 0;
        int n = this._entries.size();
        while (i < n) {
            if (!newOp._entries.get((int)i).layerId.equals(this._entries.get((int)i).layerId)) {
                return false;
            }
            ++i;
        }
        this._deltaTime = this._deltaTime.add(newOp._deltaTime);
        try {
            this.executeOrRedo(monitor, info, project, pm);
        }
        catch (ExecutionException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        this._noEffect = this._deltaTime.timeValue == 0L;
        return true;
    }

    private static class Entry {
        final String layerId;
        final Time[] oldTimes;
        final List<String> oldAvalues = Util.newList();

        public Entry(String layerId, Time[] oldTimes) {
            this.layerId = layerId;
            this.oldTimes = oldTimes;
        }
    }
}

