/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.Util;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReparentItemsOperation
extends ProjectOperation {
    private final Map<String, String> _items;
    private final String _destFolderId;

    public ReparentItemsOperation(ProjectManager projectManager, Collection<Item> items, Folder destFolder) {
        super(projectManager, "\u30a2\u30a4\u30c6\u30e0\u306e\u79fb\u52d5");
        projectManager.checkItem((Item)destFolder);
        items = Util.newSet(items);
        Iterator it = items.iterator();
        block0: while (it.hasNext()) {
            Item i = (Item)it.next();
            while ((i = i.getParent()) != null) {
                if (!items.contains(i)) continue;
                it.remove();
                continue block0;
            }
        }
        this._items = Util.newMap();
        this._destFolderId = destFolder != null ? destFolder.getId() : null;
        this._noEffect = true;
        for (Item i : items) {
            Folder parent = i.getParent();
            String parentId = parent != null ? parent.getId() : null;
            this._items.put(i.getId(), parentId);
            this._noEffect &= parent == destFolder;
        }
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        Set items = Util.newSet();
        Set related = Util.newSet();
        Folder destFolder = (Folder)project.getItem(this._destFolderId);
        for (Map.Entry<String, String> entry : this._items.entrySet()) {
            Item item = project.getItem(entry.getKey());
            Folder oldParent = item.getParent();
            item.setParent(destFolder);
            items.add(item);
            related.add(oldParent);
        }
        if (pm != null) {
            if (destFolder == null) {
                pm.fireItemsReparent(items, null);
            } else {
                related.add(destFolder);
                pm.fireItemsReparent(items, related);
            }
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        Set items = Util.newSet();
        Set related = Util.newSet();
        Folder destFolder = (Folder)project.getItem(this._destFolderId);
        for (Map.Entry<String, String> entry : this._items.entrySet()) {
            Item item = project.getItem(entry.getKey());
            Folder oldParent = (Folder)project.getItem(entry.getValue());
            item.setParent(oldParent);
            items.add(item);
            related.add(oldParent);
        }
        if (pm != null) {
            if (destFolder == null) {
                pm.fireItemsReparent(items, null);
            } else {
                related.add(destFolder);
                pm.fireItemsReparent(items, related);
            }
        }
        return Status.OK_STATUS;
    }
}

