/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.output.MacOSXQTMovieOutput;
import ch.kuramo.javie.core.output.ProgressMonitor;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;

public class QTMovieOutputAction
extends Action {
    private static byte[] defaultSettings;
    private static File defaultFolder;
    private final LayerCompositionView view;
    @Inject
    private ProjectEncoder encoder;
    @Inject
    private ProjectDecoder decoder;

    public QTMovieOutputAction(LayerCompositionView view) {
        super("QuickTime \u30e0\u30fc\u30d3\u30fc...");
        InjectorHolder.getInjector().injectMembers((Object)this);
        this.view = view;
        this.setId("ch.kuramo.javie.app.commands.QTMovieOutput");
        this.setActionDefinitionId("ch.kuramo.javie.app.commands.QTMovieOutput");
    }

    public void run() {
        CompositionItem compItem;
        File file;
        File file2;
        ProjectManager pm = ProjectManager.forWorkbenchWindow(this.getWindow());
        if (pm == null) {
            return;
        }
        byte[] settings = MacOSXQTMovieOutput.doUserDialogAndGetSettings((byte[])defaultSettings);
        if (settings == null) {
            return;
        }
        defaultSettings = settings;
        if (defaultFolder == null && (file2 = pm.getFile()) != null) {
            defaultFolder = file2.getParentFile();
        }
        if ((file = this.showSaveDialog(defaultFolder, String.valueOf((compItem = this.view.getCompositionItem()).getName()) + ".mov")) != null) {
            if (file.exists() && !file.delete()) {
                return;
            }
            defaultFolder = file.getParentFile();
            this.doOutput(pm.getProject(), compItem.getId(), settings, file);
        }
    }

    private IWorkbenchWindow getWindow() {
        return this.view.getSite().getWorkbenchWindow();
    }

    private File showSaveDialog(File folder, String name) {
        String[] filterNames = new String[]{"QuickTime Movie Files", "All Files (*)"};
        String[] filterExtensions = new String[]{"*.mov", "*"};
        String platform = SWT.getPlatform();
        if (platform.equals("win32") || platform.equals("wpf")) {
            filterNames = new String[]{"QuickTime Movie Files", "All Files (*.*)"};
            filterExtensions = new String[]{"*.mov", "*.*"};
        }
        FileDialog dialog = new FileDialog(this.getWindow().getShell(), 0x10002000);
        dialog.setFilterNames(filterNames);
        dialog.setFilterExtensions(filterExtensions);
        dialog.setFilterPath(folder != null ? folder.getAbsolutePath() : null);
        dialog.setFileName(name);
        dialog.setOverwrite(true);
        String path = dialog.open();
        return path != null ? new File(path) : null;
    }

    /*
     * Unable to fully structure code
     */
    private void doOutput(Project project, String compItemId, byte[] settings, File file) {
        block11: {
            block10: {
                block12: {
                    copy = null;
                    try {
                        try {
                            copy = (Project)this.decoder.decodeElement((CharSequence)this.encoder.encodeElement((Object)project), Project.class);
                            copy.afterDecode();
                            dialog = new ProgressMonitorDialog(this.getWindow().getShell());
                            dialog.create();
                            dialog.getShell().setText("\u66f8\u304d\u51fa\u3057");
                            dialog.run(true, true, (IRunnableWithProgress)new OutputWithProgress((CompositionItem)copy.getItem(compItemId), settings, file));
                            break block10;
                        }
                        catch (ProjectDecodeException e) {
                            throw new JavieRuntimeException((Throwable)e);
                        }
                        catch (InvocationTargetException e) {
                            throw new JavieRuntimeException((Throwable)e);
                        }
                        catch (InterruptedException v0) {
                            if (copy == null) break block11;
                            ** for (i : copy.getItems())
                        }
                    }
                    catch (Throwable var7_15) {
                        if (copy == null) break block12;
                        ** for (i : copy.getItems())
                    }
lbl-1000:
                    // 1 sources

                    {
                        i.dispose();
                        continue;
lbl20:
                        // 1 sources

                        break block11;
                    }
lbl-1000:
                    // 1 sources

                    {
                        i.dispose();
                        continue;
                    }
                }
                throw var7_15;
            }
            if (copy != null) {
                for (Item i : copy.getItems()) {
                    i.dispose();
                }
            }
        }
    }

    public static boolean isAvailable() {
        try {
            Class.forName(MacOSXQTMovieOutput.class.getName());
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private class OutputWithProgress
    implements IRunnableWithProgress {
        private final CompositionItem compItem;
        private final byte[] settings;
        private final File file;

        private OutputWithProgress(CompositionItem compItem, byte[] settings, File file) {
            this.compItem = compItem;
            this.settings = settings;
            this.file = file;
        }

        public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            MacOSXQTMovieOutput qtOut = (MacOSXQTMovieOutput)InjectorHolder.getInjector().getInstance(MacOSXQTMovieOutput.class);
            qtOut.setSettings(this.settings);
            qtOut.doOutput(this.compItem.getComposition(), AudioMode.STEREO_48KHZ_INT16, this.file, new ProgressMonitor(){
                private int totalWork;
                private int currentWork;

                public void beginTask(int totalWork) {
                    monitor.beginTask(String.format("\u66f8\u304d\u51fa\u3057: %s", OutputWithProgress.this.compItem.getName()), totalWork);
                    this.totalWork = totalWork;
                }

                public void currentWork(int currentWork) {
                    if (currentWork > this.currentWork) {
                        monitor.worked(currentWork - this.currentWork);
                        monitor.subTask(String.format("%.1f%%", 100.0 * (double)currentWork / (double)this.totalWork));
                        this.currentWork = currentWork;
                    }
                }

                public void done() {
                    monitor.done();
                }

                public boolean isCanceled() {
                    return monitor.isCanceled();
                }
            });
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
        }
    }
}

