/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.app.Perspective;
import ch.kuramo.javie.app.RecentProjects;
import ch.kuramo.javie.app.SaveUtil;
import ch.kuramo.javie.app.UIUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchWindow;

public class OpenProjectAction
extends Action {
    private final IWorkbenchWindow window;

    public OpenProjectAction(IWorkbenchWindow window) {
        super("\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u3092\u958b\u304f...");
        this.window = window;
        this.setId("ch.kuramo.javie.app.commands.openProject");
        this.setActionDefinitionId("ch.kuramo.javie.app.commands.openProject");
    }

    public void run() {
        OpenProjectAction.openProject(this.window, null);
    }

    public static void openProject(final IWorkbenchWindow window, File file) {
        ProjectManager pm = ProjectManager.forWorkbenchWindow(window);
        if (pm != null) {
            switch (SaveUtil.saveIfDirty(pm)) {
                case NOT_DIRTY: 
                case SAVED: 
                case UNSAVED: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (file == null && (file = OpenProjectAction.showFileDialog(window)) == null) {
            return;
        }
        if (pm != null) {
            pm.dispose();
            pm = null;
        }
        Perspective.reset(window);
        try {
            pm = ProjectManager.openProject(file, window);
        }
        catch (Exception e) {
            UIUtil.errorDialog(window, "Error", (Throwable)e);
            pm = ProjectManager.newProject(window);
        }
        if (pm.getFile() != null) {
            Perspective.openForProject(pm);
            RecentProjects.add(pm);
        }
        UIUtil.showView(window.getActivePage(), "ch.kuramo.javie.app.views.projectView");
        window.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IViewReference[] iViewReferenceArray = window.getActivePage().getViewReferences();
                int n = iViewReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewRef = iViewReferenceArray[n2];
                    String id = viewRef.getId();
                    if (id.equals("ch.kuramo.javie.app.views.layerCompositionView") || id.equals("ch.kuramo.javie.app.views.mediaPlayerView")) {
                        viewRef.getView(true);
                    }
                    ++n2;
                }
            }
        });
    }

    private static File showFileDialog(IWorkbenchWindow window) {
        String[] filterNames = new String[]{"Javie Project Files", "All Files (*)"};
        String[] filterExtensions = new String[]{"*.jvp", "*"};
        String platform = SWT.getPlatform();
        if (platform.equals("win32") || platform.equals("wpf")) {
            filterNames = new String[]{"Javie Project Files", "All Files (*.*)"};
            filterExtensions = new String[]{"*.jvp", "*.*"};
        }
        FileDialog dialog = new FileDialog(window.getShell(), 0x10001000);
        dialog.setFilterNames(filterNames);
        dialog.setFilterExtensions(filterExtensions);
        String path = dialog.open();
        return path != null ? new File(path) : null;
    }
}

