/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.util.binary;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Binary {
    private byte[] binaryArray = null;
    private static ResourceBundle rb = null;
    private static final String ZERO = "0";

    static {
        rb = ResourceBundle.getBundle(Binary.class.getCanonicalName());
    }

    public Binary(byte[] binaryArray) {
        if (binaryArray == null) {
            throw new IllegalArgumentException(rb.getString("err_message01"));
        }
        if (binaryArray.length == 0) {
            throw new IllegalArgumentException(rb.getString("err_message02"));
        }
        this.binaryArray = Arrays.copyOf(binaryArray, binaryArray.length);
    }

    public byte[] getSource() {
        byte[] result = Arrays.copyOf(this.binaryArray, this.binaryArray.length);
        return result;
    }

    public Binary and(Binary binary) {
        if (binary == null) {
            throw new IllegalArgumentException(rb.getString("err_message05"));
        }
        return null;
    }

    public Binary or(Binary binary) {
        if (binary == null) {
            throw new IllegalArgumentException(rb.getString("err_message05"));
        }
        return null;
    }

    public Binary not() {
        return null;
    }

    public Binary xor(Binary binary) {
        if (binary == null) {
            throw new IllegalArgumentException(rb.getString("err_message05"));
        }
        return null;
    }

    public String getBinaryForm() {
        StringBuilder builder = new StringBuilder();
        byte[] byArray = this.getSource();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            String upper = Integer.toBinaryString((b & 0xF0) >> 4);
            String under = Integer.toBinaryString(b & 0xF);
            StringBuilder upperBuilder = new StringBuilder();
            if (upper.length() != 0) {
                int fill = this.getFillLength(upper, 4);
                int i = 0;
                while (i < fill) {
                    upperBuilder.append(ZERO);
                    ++i;
                }
                upperBuilder.append(upper);
                builder.append(upperBuilder.toString());
            }
            StringBuilder underBuilder = new StringBuilder();
            if (under.length() != 0) {
                int fill = this.getFillLength(under, 4);
                int i = 0;
                while (i < fill) {
                    underBuilder.append(ZERO);
                    ++i;
                }
                underBuilder.append(under);
                builder.append(underBuilder.toString());
            }
            ++n2;
        }
        return builder.toString();
    }

    public String getHexForm() {
        StringBuilder b = new StringBuilder();
        String binForm = this.getBinaryForm();
        Pattern p = Pattern.compile("([01]{4})");
        Matcher m = p.matcher(binForm);
        while (m.find()) {
            String digit = m.group(1);
            if ("0000".equals(digit)) {
                b.append(ZERO);
                continue;
            }
            if ("0001".equals(digit)) {
                b.append("1");
                continue;
            }
            if ("0010".equals(digit)) {
                b.append("2");
                continue;
            }
            if ("0011".equals(digit)) {
                b.append("3");
                continue;
            }
            if ("0100".equals(digit)) {
                b.append("4");
                continue;
            }
            if ("0101".equals(digit)) {
                b.append("5");
                continue;
            }
            if ("0110".equals(digit)) {
                b.append("6");
                continue;
            }
            if ("0111".equals(digit)) {
                b.append("7");
                continue;
            }
            if ("1000".equals(digit)) {
                b.append("8");
                continue;
            }
            if ("1001".equals(digit)) {
                b.append("9");
                continue;
            }
            if ("1010".equals(digit)) {
                b.append("a");
                continue;
            }
            if ("1011".equals(digit)) {
                b.append("b");
                continue;
            }
            if ("1100".equals(digit)) {
                b.append("c");
                continue;
            }
            if ("1101".equals(digit)) {
                b.append("d");
                continue;
            }
            if ("1110".equals(digit)) {
                b.append("e");
                continue;
            }
            if (!"1111".equals(digit)) continue;
            b.append("f");
        }
        return b.toString();
    }

    public String get32dForm() {
        StringBuilder b = new StringBuilder();
        String binForm = this.getBinaryForm();
        int fill = this.getFillLength(binForm, 5);
        StringBuilder tmp = new StringBuilder();
        int i = 0;
        while (i < fill) {
            tmp.append(ZERO);
            ++i;
        }
        tmp.append(binForm);
        binForm = tmp.toString();
        Pattern p = Pattern.compile("([01]{5})");
        Matcher m = p.matcher(binForm);
        while (m.find()) {
            String digit = m.group(1);
            if ("00000".equals(digit)) {
                b.append(ZERO);
                continue;
            }
            if ("00001".equals(digit)) {
                b.append("1");
                continue;
            }
            if ("00010".equals(digit)) {
                b.append("2");
                continue;
            }
            if ("00011".equals(digit)) {
                b.append("3");
                continue;
            }
            if ("00100".equals(digit)) {
                b.append("4");
                continue;
            }
            if ("00101".equals(digit)) {
                b.append("5");
                continue;
            }
            if ("00110".equals(digit)) {
                b.append("6");
                continue;
            }
            if ("00111".equals(digit)) {
                b.append("7");
                continue;
            }
            if ("01000".equals(digit)) {
                b.append("8");
                continue;
            }
            if ("01001".equals(digit)) {
                b.append("9");
                continue;
            }
            if ("01010".equals(digit)) {
                b.append("a");
                continue;
            }
            if ("01011".equals(digit)) {
                b.append("b");
                continue;
            }
            if ("01100".equals(digit)) {
                b.append("c");
                continue;
            }
            if ("01101".equals(digit)) {
                b.append("d");
                continue;
            }
            if ("01110".equals(digit)) {
                b.append("e");
                continue;
            }
            if ("01111".equals(digit)) {
                b.append("f");
                continue;
            }
            if ("10000".equals(digit)) {
                b.append("g");
                continue;
            }
            if ("10001".equals(digit)) {
                b.append("h");
                continue;
            }
            if ("10010".equals(digit)) {
                b.append("i");
                continue;
            }
            if ("10011".equals(digit)) {
                b.append("j");
                continue;
            }
            if ("10100".equals(digit)) {
                b.append("k");
                continue;
            }
            if ("10101".equals(digit)) {
                b.append("l");
                continue;
            }
            if ("10110".equals(digit)) {
                b.append("m");
                continue;
            }
            if ("10111".equals(digit)) {
                b.append("n");
                continue;
            }
            if ("11000".equals(digit)) {
                b.append("o");
                continue;
            }
            if ("11001".equals(digit)) {
                b.append("p");
                continue;
            }
            if ("11010".equals(digit)) {
                b.append("q");
                continue;
            }
            if ("11011".equals(digit)) {
                b.append("r");
                continue;
            }
            if ("11100".equals(digit)) {
                b.append("s");
                continue;
            }
            if ("11101".equals(digit)) {
                b.append("t");
                continue;
            }
            if ("11110".equals(digit)) {
                b.append("u");
                continue;
            }
            if (!"11111".equals(digit)) continue;
            b.append("v");
        }
        return b.toString();
    }

    public String get64dForm() {
        StringBuilder b = new StringBuilder();
        String binForm = this.getBinaryForm();
        int fill = this.getFillLength(binForm, 6);
        StringBuilder tmp = new StringBuilder();
        int i = 0;
        while (i < fill) {
            tmp.append(ZERO);
            ++i;
        }
        tmp.append(binForm);
        binForm = tmp.toString();
        Pattern p = Pattern.compile("([01]{6})");
        Matcher m = p.matcher(binForm);
        while (m.find()) {
            String digit = m.group(1);
            if ("000000".equals(digit)) {
                b.append(ZERO);
                continue;
            }
            if ("000001".equals(digit)) {
                b.append("1");
                continue;
            }
            if ("000010".equals(digit)) {
                b.append("2");
                continue;
            }
            if ("000011".equals(digit)) {
                b.append("3");
                continue;
            }
            if ("000100".equals(digit)) {
                b.append("4");
                continue;
            }
            if ("000101".equals(digit)) {
                b.append("5");
                continue;
            }
            if ("000110".equals(digit)) {
                b.append("6");
                continue;
            }
            if ("000111".equals(digit)) {
                b.append("7");
                continue;
            }
            if ("001000".equals(digit)) {
                b.append("8");
                continue;
            }
            if ("001001".equals(digit)) {
                b.append("9");
                continue;
            }
            if ("001010".equals(digit)) {
                b.append("a");
                continue;
            }
            if ("001011".equals(digit)) {
                b.append("b");
                continue;
            }
            if ("001100".equals(digit)) {
                b.append("c");
                continue;
            }
            if ("001101".equals(digit)) {
                b.append("d");
                continue;
            }
            if ("001110".equals(digit)) {
                b.append("e");
                continue;
            }
            if ("001111".equals(digit)) {
                b.append("f");
                continue;
            }
            if ("010000".equals(digit)) {
                b.append("g");
                continue;
            }
            if ("010001".equals(digit)) {
                b.append("h");
                continue;
            }
            if ("010010".equals(digit)) {
                b.append("i");
                continue;
            }
            if ("010011".equals(digit)) {
                b.append("j");
                continue;
            }
            if ("010100".equals(digit)) {
                b.append("k");
                continue;
            }
            if ("010101".equals(digit)) {
                b.append("l");
                continue;
            }
            if ("010110".equals(digit)) {
                b.append("m");
                continue;
            }
            if ("010111".equals(digit)) {
                b.append("n");
                continue;
            }
            if ("011000".equals(digit)) {
                b.append("o");
                continue;
            }
            if ("011001".equals(digit)) {
                b.append("p");
                continue;
            }
            if ("011010".equals(digit)) {
                b.append("q");
                continue;
            }
            if ("011011".equals(digit)) {
                b.append("r");
                continue;
            }
            if ("011100".equals(digit)) {
                b.append("s");
                continue;
            }
            if ("011101".equals(digit)) {
                b.append("t");
                continue;
            }
            if ("011110".equals(digit)) {
                b.append("u");
                continue;
            }
            if ("011111".equals(digit)) {
                b.append("v");
                continue;
            }
            if ("100000".equals(digit)) {
                b.append("w");
                continue;
            }
            if ("100001".equals(digit)) {
                b.append("x");
                continue;
            }
            if ("100010".equals(digit)) {
                b.append("y");
                continue;
            }
            if ("100011".equals(digit)) {
                b.append("z");
                continue;
            }
            if ("100100".equals(digit)) {
                b.append("A");
                continue;
            }
            if ("100101".equals(digit)) {
                b.append("B");
                continue;
            }
            if ("100110".equals(digit)) {
                b.append("C");
                continue;
            }
            if ("100111".equals(digit)) {
                b.append("D");
                continue;
            }
            if ("101000".equals(digit)) {
                b.append("E");
                continue;
            }
            if ("101001".equals(digit)) {
                b.append("F");
                continue;
            }
            if ("101010".equals(digit)) {
                b.append("G");
                continue;
            }
            if ("101011".equals(digit)) {
                b.append("H");
                continue;
            }
            if ("101100".equals(digit)) {
                b.append("I");
                continue;
            }
            if ("101101".equals(digit)) {
                b.append("J");
                continue;
            }
            if ("101110".equals(digit)) {
                b.append("K");
                continue;
            }
            if ("101111".equals(digit)) {
                b.append("L");
                continue;
            }
            if ("110000".equals(digit)) {
                b.append("M");
                continue;
            }
            if ("110001".equals(digit)) {
                b.append("N");
                continue;
            }
            if ("110010".equals(digit)) {
                b.append("O");
                continue;
            }
            if ("110011".equals(digit)) {
                b.append("P");
                continue;
            }
            if ("110100".equals(digit)) {
                b.append("Q");
                continue;
            }
            if ("110101".equals(digit)) {
                b.append("R");
                continue;
            }
            if ("110110".equals(digit)) {
                b.append("S");
                continue;
            }
            if ("110111".equals(digit)) {
                b.append("T");
                continue;
            }
            if ("111000".equals(digit)) {
                b.append("U");
                continue;
            }
            if ("111001".equals(digit)) {
                b.append("V");
                continue;
            }
            if ("111010".equals(digit)) {
                b.append("W");
                continue;
            }
            if ("111011".equals(digit)) {
                b.append("X");
                continue;
            }
            if ("111100".equals(digit)) {
                b.append("Y");
                continue;
            }
            if ("111101".equals(digit)) {
                b.append("Z");
                continue;
            }
            if ("111110".equals(digit)) {
                b.append("+");
                continue;
            }
            if (!"111111".equals(digit)) continue;
            b.append("-");
        }
        return b.toString();
    }

    public static Binary decode64DFrom(String source) {
        Pattern p = Pattern.compile("([0-9a-zA-Z\\+\\-])+");
        Pattern p2 = Pattern.compile("([0-9a-zA-Z\\+\\-]{1})");
        Matcher m = p.matcher(source);
        StringBuilder b = new StringBuilder();
        if (!m.matches()) {
            throw new IllegalArgumentException(rb.getString("err_message03"));
        }
        Matcher m2 = p2.matcher(source);
        while (m2.find()) {
            String digit = m2.group(1);
            if (ZERO.equals(digit)) {
                b.append("000000");
                continue;
            }
            if ("1".equals(digit)) {
                b.append("000001");
                continue;
            }
            if ("2".equals(digit)) {
                b.append("000010");
                continue;
            }
            if ("3".equals(digit)) {
                b.append("000011");
                continue;
            }
            if ("4".equals(digit)) {
                b.append("000100");
                continue;
            }
            if ("5".equals(digit)) {
                b.append("000101");
                continue;
            }
            if ("6".equals(digit)) {
                b.append("000110");
                continue;
            }
            if ("7".equals(digit)) {
                b.append("000111");
                continue;
            }
            if ("8".equals(digit)) {
                b.append("001000");
                continue;
            }
            if ("9".equals(digit)) {
                b.append("001001");
                continue;
            }
            if ("a".equals(digit)) {
                b.append("001010");
                continue;
            }
            if ("b".equals(digit)) {
                b.append("001011");
                continue;
            }
            if ("c".equals(digit)) {
                b.append("001100");
                continue;
            }
            if ("d".equals(digit)) {
                b.append("001101");
                continue;
            }
            if ("e".equals(digit)) {
                b.append("001110");
                continue;
            }
            if ("f".equals(digit)) {
                b.append("001111");
                continue;
            }
            if ("g".equals(digit)) {
                b.append("010000");
                continue;
            }
            if ("h".equals(digit)) {
                b.append("010001");
                continue;
            }
            if ("i".equals(digit)) {
                b.append("010010");
                continue;
            }
            if ("j".equals(digit)) {
                b.append("010011");
                continue;
            }
            if ("k".equals(digit)) {
                b.append("010100");
                continue;
            }
            if ("l".equals(digit)) {
                b.append("010101");
                continue;
            }
            if ("m".equals(digit)) {
                b.append("010110");
                continue;
            }
            if ("n".equals(digit)) {
                b.append("010111");
                continue;
            }
            if ("o".equals(digit)) {
                b.append("011000");
                continue;
            }
            if ("p".equals(digit)) {
                b.append("011001");
                continue;
            }
            if ("q".equals(digit)) {
                b.append("011010");
                continue;
            }
            if ("r".equals(digit)) {
                b.append("011011");
                continue;
            }
            if ("s".equals(digit)) {
                b.append("011100");
                continue;
            }
            if ("t".equals(digit)) {
                b.append("011101");
                continue;
            }
            if ("u".equals(digit)) {
                b.append("011110");
                continue;
            }
            if ("v".equals(digit)) {
                b.append("011111");
                continue;
            }
            if ("w".equals(digit)) {
                b.append("100000");
                continue;
            }
            if ("x".equals(digit)) {
                b.append("100001");
                continue;
            }
            if ("y".equals(digit)) {
                b.append("100010");
                continue;
            }
            if ("z".equals(digit)) {
                b.append("100011");
                continue;
            }
            if ("A".equals(digit)) {
                b.append("100100");
                continue;
            }
            if ("B".equals(digit)) {
                b.append("100101");
                continue;
            }
            if ("C".equals(digit)) {
                b.append("100110");
                continue;
            }
            if ("D".equals(digit)) {
                b.append("100111");
                continue;
            }
            if ("E".equals(digit)) {
                b.append("101000");
                continue;
            }
            if ("F".equals(digit)) {
                b.append("101001");
                continue;
            }
            if ("G".equals(digit)) {
                b.append("101010");
                continue;
            }
            if ("H".equals(digit)) {
                b.append("101011");
                continue;
            }
            if ("I".equals(digit)) {
                b.append("101100");
                continue;
            }
            if ("J".equals(digit)) {
                b.append("101101");
                continue;
            }
            if ("K".equals(digit)) {
                b.append("101110");
                continue;
            }
            if ("L".equals(digit)) {
                b.append("101111");
                continue;
            }
            if ("M".equals(digit)) {
                b.append("110000");
                continue;
            }
            if ("N".equals(digit)) {
                b.append("110001");
                continue;
            }
            if ("O".equals(digit)) {
                b.append("110010");
                continue;
            }
            if ("P".equals(digit)) {
                b.append("110011");
                continue;
            }
            if ("Q".equals(digit)) {
                b.append("110100");
                continue;
            }
            if ("R".equals(digit)) {
                b.append("110101");
                continue;
            }
            if ("S".equals(digit)) {
                b.append("110110");
                continue;
            }
            if ("T".equals(digit)) {
                b.append("110111");
                continue;
            }
            if ("U".equals(digit)) {
                b.append("111000");
                continue;
            }
            if ("V".equals(digit)) {
                b.append("111001");
                continue;
            }
            if ("W".equals(digit)) {
                b.append("111010");
                continue;
            }
            if ("X".equals(digit)) {
                b.append("111011");
                continue;
            }
            if ("Y".equals(digit)) {
                b.append("111100");
                continue;
            }
            if ("Z".equals(digit)) {
                b.append("111101");
                continue;
            }
            if ("+".equals(digit)) {
                b.append("111110");
                continue;
            }
            if (!"-".equals(digit)) continue;
            b.append("111111");
        }
        String binForm = b.toString();
        int sup = binForm.length() % 8;
        binForm = binForm.substring(sup, binForm.length());
        Binary result = Binary.decode2DForm(binForm);
        return result;
    }

    public static Binary decode32DFrom(String source) {
        Pattern p = Pattern.compile("([0-9a-v])+");
        Pattern p2 = Pattern.compile("([0-9a-v]{1})");
        Matcher m = p.matcher(source);
        StringBuilder b = new StringBuilder();
        if (!m.matches()) {
            throw new IllegalArgumentException(rb.getString("err_message04"));
        }
        Matcher m2 = p2.matcher(source);
        while (m2.find()) {
            String digit = m2.group(1);
            if (ZERO.equals(digit)) {
                b.append("00000");
                continue;
            }
            if ("1".equals(digit)) {
                b.append("00001");
                continue;
            }
            if ("2".equals(digit)) {
                b.append("00010");
                continue;
            }
            if ("3".equals(digit)) {
                b.append("00011");
                continue;
            }
            if ("4".equals(digit)) {
                b.append("00100");
                continue;
            }
            if ("5".equals(digit)) {
                b.append("00101");
                continue;
            }
            if ("6".equals(digit)) {
                b.append("00110");
                continue;
            }
            if ("7".equals(digit)) {
                b.append("00111");
                continue;
            }
            if ("8".equals(digit)) {
                b.append("01000");
                continue;
            }
            if ("9".equals(digit)) {
                b.append("01001");
                continue;
            }
            if ("a".equals(digit)) {
                b.append("01010");
                continue;
            }
            if ("b".equals(digit)) {
                b.append("01011");
                continue;
            }
            if ("c".equals(digit)) {
                b.append("01100");
                continue;
            }
            if ("d".equals(digit)) {
                b.append("01101");
                continue;
            }
            if ("e".equals(digit)) {
                b.append("01110");
                continue;
            }
            if ("f".equals(digit)) {
                b.append("01111");
                continue;
            }
            if ("g".equals(digit)) {
                b.append("10000");
                continue;
            }
            if ("h".equals(digit)) {
                b.append("10001");
                continue;
            }
            if ("i".equals(digit)) {
                b.append("10010");
                continue;
            }
            if ("j".equals(digit)) {
                b.append("10011");
                continue;
            }
            if ("k".equals(digit)) {
                b.append("10100");
                continue;
            }
            if ("l".equals(digit)) {
                b.append("10101");
                continue;
            }
            if ("m".equals(digit)) {
                b.append("10110");
                continue;
            }
            if ("n".equals(digit)) {
                b.append("10111");
                continue;
            }
            if ("o".equals(digit)) {
                b.append("11000");
                continue;
            }
            if ("p".equals(digit)) {
                b.append("11001");
                continue;
            }
            if ("q".equals(digit)) {
                b.append("11010");
                continue;
            }
            if ("r".equals(digit)) {
                b.append("11011");
                continue;
            }
            if ("s".equals(digit)) {
                b.append("11100");
                continue;
            }
            if ("t".equals(digit)) {
                b.append("11101");
                continue;
            }
            if ("u".equals(digit)) {
                b.append("11110");
                continue;
            }
            if (!"v".equals(digit)) continue;
            b.append("11111");
        }
        String binForm = b.toString();
        int sup = binForm.length() % 8;
        binForm = binForm.substring(sup, binForm.length());
        Binary result = Binary.decode2DForm(binForm);
        return result;
    }

    public static Binary decode16DFrom(String source) {
        Pattern p = Pattern.compile("([0-9a-f])+");
        Pattern p2 = Pattern.compile("([0-9a-f]{1})");
        Matcher m = p.matcher(source);
        StringBuilder b = new StringBuilder();
        if (!m.matches()) {
            throw new IllegalArgumentException(rb.getString("err_message04"));
        }
        Matcher m2 = p2.matcher(source);
        while (m2.find()) {
            String digit = m2.group(1);
            if (ZERO.equals(digit)) {
                b.append("0000");
                continue;
            }
            if ("1".equals(digit)) {
                b.append("0001");
                continue;
            }
            if ("2".equals(digit)) {
                b.append("0010");
                continue;
            }
            if ("3".equals(digit)) {
                b.append("0011");
                continue;
            }
            if ("4".equals(digit)) {
                b.append("0100");
                continue;
            }
            if ("5".equals(digit)) {
                b.append("0101");
                continue;
            }
            if ("6".equals(digit)) {
                b.append("0110");
                continue;
            }
            if ("7".equals(digit)) {
                b.append("0111");
                continue;
            }
            if ("8".equals(digit)) {
                b.append("1000");
                continue;
            }
            if ("9".equals(digit)) {
                b.append("1001");
                continue;
            }
            if ("a".equals(digit)) {
                b.append("1010");
                continue;
            }
            if ("b".equals(digit)) {
                b.append("1011");
                continue;
            }
            if ("c".equals(digit)) {
                b.append("1100");
                continue;
            }
            if ("d".equals(digit)) {
                b.append("1101");
                continue;
            }
            if ("e".equals(digit)) {
                b.append("1110");
                continue;
            }
            if (!"f".equals(digit)) continue;
            b.append("1111");
        }
        String binForm = b.toString();
        int sup = binForm.length() % 8;
        binForm = binForm.substring(sup, binForm.length());
        Binary result = Binary.decode2DForm(binForm);
        return result;
    }

    public static Binary decode2DForm(String source) {
        Pattern p = Pattern.compile("([01]{8})");
        Matcher m = p.matcher(source);
        LinkedList<String> digitList = new LinkedList<String>();
        while (m.find()) {
            String digit = m.group(1);
            digitList.add(digit);
        }
        byte[] result = new byte[digitList.size()];
        int count = 0;
        for (String digit : digitList) {
            byte out;
            String upper = digit.substring(0, 4);
            String under = digit.substring(4, 8);
            int upp = Binary.getIntFromBinForm(upper);
            int und = Binary.getIntFromBinForm(under);
            result[count] = out = (byte)(upp << 4 | und);
            ++count;
        }
        Binary resultObj = new Binary(result);
        return resultObj;
    }

    private static int getIntFromBinForm(String source) {
        int result = 0;
        if ("0000".equals(source)) {
            result = 0;
        } else if ("0001".equals(source)) {
            result = 1;
        } else if ("0010".equals(source)) {
            result = 2;
        } else if ("0011".equals(source)) {
            result = 3;
        } else if ("0100".equals(source)) {
            result = 4;
        } else if ("0101".equals(source)) {
            result = 5;
        } else if ("0110".equals(source)) {
            result = 6;
        } else if ("0111".equals(source)) {
            result = 7;
        } else if ("1000".equals(source)) {
            result = 8;
        } else if ("1001".equals(source)) {
            result = 9;
        } else if ("1010".equals(source)) {
            result = 10;
        } else if ("1011".equals(source)) {
            result = 11;
        } else if ("1100".equals(source)) {
            result = 12;
        } else if ("1101".equals(source)) {
            result = 13;
        } else if ("1110".equals(source)) {
            result = 14;
        } else if ("1111".equals(source)) {
            result = 15;
        }
        return result;
    }

    private int getFillLength(String source, int baseLength) {
        if (source == null || source.isEmpty()) {
            return 0;
        }
        int fill = baseLength - source.length() % baseLength;
        if (fill == baseLength) {
            fill = 0;
        }
        return fill;
    }

    public int length() {
        int len = this.getSource().length;
        return len * 8;
    }
}

