/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.util;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.dyndns.nuda.tools.util.Digest;

public class ReversibleConverter {
    public static String compress(String source) {
        try {
            String inputString = source;
            byte[] input = inputString.getBytes("UTF-8");
            int length = input.length;
            byte[] output = new byte[length];
            Deflater compresser = new Deflater(9);
            compresser.setInput(input);
            compresser.finish();
            compresser.deflate(output);
            String bin2Hex = ReversibleConverter.bin2hex(output);
            return bin2Hex;
        }
        catch (UnsupportedEncodingException ex) {
            return "";
        }
    }

    public static String decompress(String source) {
        try {
            byte[] hex2Bin = ReversibleConverter.hex2bin(source);
            Inflater decompresser = new Inflater();
            decompresser.setInput(hex2Bin, 0, hex2Bin.length);
            byte[] result = new byte[hex2Bin.length];
            int resultLength = decompresser.inflate(result);
            decompresser.end();
            String outputString = new String(result, 0, resultLength, "UTF-8");
            return outputString;
        }
        catch (UnsupportedEncodingException ex) {
            return "";
        }
        catch (DataFormatException ex) {
            return "";
        }
    }

    public static void main(String[] args) {
        ReversibleConverter.test000();
    }

    public static void test000() {
        String source = "cmm_seq \t\tVARCHAR(45)\t\tCOLLATE utf8_bin NOT NULL COMMENT '\u30e6\u30cb\u30fc\u30af\u30ad\u30fc',";
        String c = ReversibleConverter.compress(source);
        String d = ReversibleConverter.decompress(c);
        System.out.println(source);
        System.out.println(c);
        System.out.println(c.length());
        System.out.println(d);
    }

    public static void test001() {
        String source = "16\u3067\u5272\u3063\u305f\u4f59\u308a\u3092\u5404\u6841\u306e\u5024\u3068\u3057\u3066\u7e70\u308a\u8fd4\u3057\u3092\u4f7f\u3063\u3066\u81ea\u4f5c\u3057\u305f\u30d7\u30ed\u30b0\u30e9\u30e0\u3002";
        String c = ReversibleConverter.compress(source);
        String d = ReversibleConverter.decompress(c);
        Digest di = new Digest();
        System.out.println(source);
        System.out.println(c);
        System.out.println(d);
        System.out.println("===");
        System.out.println("===");
        System.out.println("source byte :" + ReversibleConverter.bin2hex(source.getBytes()));
        String h = ReversibleConverter.bin2hex(source.getBytes());
        String c2 = ReversibleConverter.radix32Compress(source);
        String c3 = ReversibleConverter.radix32Compressv2(source);
        String di2 = new String(ReversibleConverter.radix32ToHex(c2));
        System.out.println("source rdx32:" + c2);
        System.out.println("source rdx32:" + c3);
        String di3 = new String(ReversibleConverter.radix32ToHex(c3));
        System.out.println("trans       :" + di2);
        System.out.println("trans       :" + di3);
        System.out.println("===");
        System.out.println(63);
    }

    public static void test002() {
        byte[] b = new byte[]{49, 6, 8};
        b = new String("16\u3067\u5272\u3063\u305f\u4f59\u308a\u3092\u5404\u6841\u306e\u5024\u3068\u3057\u3066\u7e70\u308a\u8fd4\u3057\u3092\u4f7f\u3063\u3066\u81ea\u4f5c\u3057\u305f\u30d7\u30ed\u30b0\u30e9\u30e0\u3002").getBytes();
        String bStr = ReversibleConverter.bin2hex(b);
        String r32 = ReversibleConverter.radix32Compressv2("16\u3067\u5272\u3063\u305f\u4f59\u308a\u3092\u5404\u6841\u306e\u5024\u3068\u3057\u3066\u7e70\u308a\u8fd4\u3057\u3092\u4f7f\u3063\u3066\u81ea\u4f5c\u3057\u305f\u30d7\u30ed\u30b0\u30e9\u30e0\u3002");
        String out = ReversibleConverter.radix32ToHex(r32);
        System.out.println(bStr);
        System.out.println(r32);
        System.out.println(out);
    }

    public static String radix32Compress(String source) {
        String result = "";
        int checkByte = 32;
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < source.getBytes().length) {
            String out = Integer.toString(~(~source.getBytes()[i] | checkByte) & 0x3F, 36);
            b.append(out);
            ++i;
        }
        result = b.toString();
        return result;
    }

    public static String radix32Compressv2(String source) {
        String result = "";
        int checkByte = 32;
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < source.getBytes().length) {
            byte tmp = source.getBytes()[i];
            String hex = ReversibleConverter.bin2hex(new byte[]{tmp});
            String out = Integer.toString(tmp, 36);
            b.append(out);
            ++i;
        }
        result = b.toString();
        System.out.println("radix32Compressv2:" + result);
        return result;
    }

    public static String bin2hex(byte[] data) {
        StringBuffer sb = new StringBuffer();
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            String s = Integer.toHexString(0xFF & b);
            if (s.length() == 1) {
                sb.append("0");
            }
            sb.append(s);
            ++n2;
        }
        return sb.toString();
    }

    public static String bin2hexv2(byte[] data) {
        StringBuffer sb = new StringBuffer();
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            String s = Integer.toHexString(0xFF & b);
            if (s.length() == 1) {
                sb.append("0");
            }
            sb.append(s).append("_");
            ++n2;
        }
        return sb.toString();
    }

    public static byte[] hex2bin(String hex) {
        byte[] bytes = new byte[hex.length() / 2];
        int index = 0;
        while (index < bytes.length) {
            bytes[index] = (byte)Integer.parseInt(hex.substring(index * 2, (index + 1) * 2), 16);
            ++index;
        }
        return bytes;
    }

    public static String radix32ToHex(String hex) {
        StringBuilder b = new StringBuilder();
        int index = 0;
        while (index < hex.length()) {
            char s = hex.charAt(index);
            b.append(ReversibleConverter.radix32ToRadix16(s));
            if ((index + 1) % 1 == 0) {
                b.append("_");
            }
            ++index;
        }
        return b.toString();
    }

    public static String radix32ToRadix16(char s) {
        String result = "";
        if ("0".charAt(0) == s) {
            result = "00";
        } else if ("1".charAt(0) == s) {
            result = "01";
        } else if ("2".charAt(0) == s) {
            result = "02";
        } else if ("3".charAt(0) == s) {
            result = "03";
        } else if ("4".charAt(0) == s) {
            result = "04";
        } else if ("5".charAt(0) == s) {
            result = "05";
        } else if ("6".charAt(0) == s) {
            result = "06";
        } else if ("7".charAt(0) == s) {
            result = "07";
        } else if ("8".charAt(0) == s) {
            result = "08";
        } else if ("9".charAt(0) == s) {
            result = "09";
        } else if ("a".charAt(0) == s) {
            result = "0a";
        } else if ("b".charAt(0) == s) {
            result = "0b";
        } else if ("c".charAt(0) == s) {
            result = "0c";
        } else if ("d".charAt(0) == s) {
            result = "0d";
        } else if ("e".charAt(0) == s) {
            result = "0e";
        } else if ("f".charAt(0) == s) {
            result = "0f";
        } else if ("g".charAt(0) == s) {
            result = "10";
        } else if ("h".charAt(0) == s) {
            result = "11";
        } else if ("i".charAt(0) == s) {
            result = "12";
        } else if ("j".charAt(0) == s) {
            result = "13";
        } else if ("k".charAt(0) == s) {
            result = "14";
        } else if ("l".charAt(0) == s) {
            result = "15";
        } else if ("m".charAt(0) == s) {
            result = "16";
        } else if ("n".charAt(0) == s) {
            result = "17";
        } else if ("o".charAt(0) == s) {
            result = "18";
        } else if ("p".charAt(0) == s) {
            result = "19";
        } else if ("q".charAt(0) == s) {
            result = "1a";
        } else if ("r".charAt(0) == s) {
            result = "1b";
        } else if ("s".charAt(0) == s) {
            result = "1c";
        } else if ("t".charAt(0) == s) {
            result = "1d";
        } else if ("u".charAt(0) == s) {
            result = "1e";
        } else if ("v".charAt(0) == s) {
            result = "1f";
        }
        return result;
    }

    public static String radix32ToRadix16(byte s) {
        String result = "";
        byte ss = s;
        if (ss == 0) {
            result = "0";
        } else if (1 == ss) {
            result = "1";
        } else if (2 == ss) {
            result = "2";
        } else if (3 == ss) {
            result = "3";
        } else if (4 == ss) {
            result = "4";
        } else if (5 == ss) {
            result = "5";
        } else if (6 == ss) {
            result = "6";
        } else if (7 == ss) {
            result = "7";
        } else if (8 == ss) {
            result = "8";
        } else if (9 == ss) {
            result = "9";
        } else if (10 == ss) {
            result = "a";
        } else if (11 == ss) {
            result = "b";
        } else if (12 == ss) {
            result = "c";
        } else if (13 == ss) {
            result = "d";
        } else if (14 == ss) {
            result = "e";
        } else if (15 == ss) {
            result = "f";
        } else if (16 == ss) {
            result = "g";
        } else if (17 == ss) {
            result = "h";
        } else if (18 == ss) {
            result = "i";
        } else if (19 == ss) {
            result = "j";
        } else if (20 == ss) {
            result = "k";
        } else if (21 == ss) {
            result = "l";
        } else if (22 == ss) {
            result = "m";
        } else if (23 == ss) {
            result = "n";
        } else if (24 == ss) {
            result = "o";
        } else if (25 == ss) {
            result = "p";
        } else if (26 == ss) {
            result = "q";
        } else if (27 == ss) {
            result = "r";
        } else if (28 == ss) {
            result = "s";
        } else if (29 == ss) {
            result = "t";
        } else if (30 == ss) {
            result = "u";
        } else if (31 == ss) {
            result = "v";
        }
        return result;
    }
}

