/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.di;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.dyndns.nuda.di.Injector;
import org.dyndns.nuda.di.InjectorManager;
import org.dyndns.nuda.logger.CommonLogger;
import org.dyndns.nuda.logger.LoggerAdaptor;
import org.dyndns.nuda.logger.LoggerAdaptorInjection;
import org.dyndns.nuda.plugin.PluginDescription;

@PluginDescription(name="\u30ed\u30ac\u30fc\u30a2\u30c0\u30d7\u30bf\u30fc\u30a4\u30f3\u30b8\u30a7\u30af\u30bf")
public class LoggerAdaptorInjector
implements Injector {
    private static LoggerAdaptor logger = CommonLogger.getLoggerAdaptor().getLogger("LoggerAdaptorInjector");

    @Override
    public void init() {
        logger.debug("{}", "\u30ed\u30ac\u30fc\u30a2\u30c0\u30d7\u30bf\u30a4\u30f3\u30b8\u30a7\u30af\u30bf\u3092\u521d\u671f\u5316\u3057\u307e\u3059");
        InjectorManager.addInjector(this);
    }

    @Override
    public void inject(Object target) {
        Field[] fields;
        if (target == null) {
            return;
        }
        Class<?> cls = target.getClass();
        Field[] fieldArray = fields = cls.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field targetField = fieldArray[n2];
            boolean isValid = targetField.isAnnotationPresent(LoggerAdaptorInjection.class);
            Class<?> fieldType = targetField.getType();
            if (fieldType.equals(LoggerAdaptor.class) && isValid) {
                boolean isAccessible = targetField.isAccessible();
                if (!isAccessible) {
                    targetField.setAccessible(true);
                }
                LoggerAdaptor adaptor = null;
                LoggerAdaptorInjection inj = targetField.getAnnotation(LoggerAdaptorInjection.class);
                adaptor = inj.name().isEmpty() ? CommonLogger.getLoggerAdaptor().getLogger(cls) : CommonLogger.getLoggerAdaptor().getLogger(inj.name());
                if (Modifier.isStatic(targetField.getModifiers())) {
                    try {
                        targetField.set(null, adaptor);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        targetField.set(target, adaptor);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                targetField.setAccessible(isAccessible);
            }
            ++n2;
        }
    }
}

