package org.dyndns.nuda.tools.regex.reflection.cache;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

import junit.framework.Assert;
import junit.framework.TestCase;

import org.dyndns.nuda.tools.regex.util.exception.RegexPatternException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CacheManagerTest extends TestCase {

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
		System.out.println("start" + " " + getName());
	}

	@Override
	@After
	public void tearDown() throws Exception {
		System.out.println("end  " + " " + getName());
	}

	@Test
	public void testGetFieldCache() {
		FieldCache fc = new FieldCache() {

			@Override
			public void init() {
				// TODO Auto-generated method stub

			}

			@Override
			public Map<Integer, List<Field>> getTargetFieldList(
					Class<?> targetClass) {
				// TODO Auto-generated method stub
				return null;
			}
		};

		CacheManager.setFieldCache(fc);

		Assert.assertEquals(fc, CacheManager.getFieldCache());
	}

	@Test
	public void testGetMethodCache() {
		MethodCache mc = new MethodCache() {

			@Override
			public void init() {
				// TODO Auto-generated method stub

			}

			@Override
			public Map<Integer, List<Method>> createPreProcessor(
					Class<?> targetClass) {
				// TODO Auto-generated method stub
				return null;
			}

			@Override
			public Map<Integer, List<Method>> createPostProcessor(
					Class<?> targetClass) {
				// TODO Auto-generated method stub
				return null;
			}
		};

		CacheManager.setMethodCache(mc);

		Assert.assertEquals(mc, CacheManager.getMethodCache());
	}

	@Test
	public void testGetRegexCache() {
		RegexCache rc = new RegexCache() {

			@Override
			public void init() {
				// TODO Auto-generated method stub

			}

			@Override
			public <T> int getRegexFlg(Class<T> cls)
					throws RegexPatternException {
				// TODO Auto-generated method stub
				return 0;
			}

			@Override
			public <T> Pattern createPattern(Class<T> cls)
					throws RegexPatternException {
				// TODO Auto-generated method stub
				return null;
			}
		};

		CacheManager.setRegexCache(rc);

		Assert.assertEquals(rc, CacheManager.getRegexCache());
	}

	@Test
	public void testGetFieldCacheDefault() {
		CacheManager.setFieldCache(null);
		Assert.assertEquals(TargetFieldCache.getInstance(),
				CacheManager.getFieldCache());
	}

	@Test
	public void testGetMethodCacheDefault() {
		CacheManager.setMethodCache(null);
		Assert.assertEquals(TargetMethodCache.getInstance(),
				CacheManager.getMethodCache());
	}

	@Test
	public void testGetRegexCacheDefault() {
		CacheManager.setRegexCache(null);
		Assert.assertEquals(DefaultRegexCache.getInstance(),
				CacheManager.getRegexCache());
	}
}
