package org.dyndns.nuda.tools.regex.processors;

import java.lang.reflect.Field;

import junit.framework.Assert;
import junit.framework.TestCase;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ListStringInputSequenceProcessorTest extends TestCase {

	private InputSequenceProcessor p = null;
	
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
		System.out.println("start" + " " + getName());
		p = new ListStringInputSequenceProcessor();
	}

	@Override
	@After
	public void tearDown() throws Exception {
		System.out.println("end  " + " " + getName());
	}

	@Test
	public void testAccept() {
		TestRegexBean01 bean = new TestRegexBean01();
		Class<?> testRegexBean01Cls = TestRegexBean01.class;
		try {
			Field f = testRegexBean01Cls.getDeclaredField("target003");
			
			boolean result = p.accept(f, "");
			Assert.assertTrue(result);
		} catch (SecurityException e) {
			e.printStackTrace();
			Assert.fail(e.getMessage());
		} catch (NoSuchFieldException e) {
			Assert.fail(e.getMessage());
		}
	}

	@Test
	public void testProcess() {
		TestRegexBean01 bean = new TestRegexBean01();
		Class<?> testRegexBean01Cls = TestRegexBean01.class;
		try {
			String inputSequence = "abc\ndef\n";
			String expected01 = "abc";
			String expected02 = "def";
			String actual01 = "";
			String actual02 = "";
			
			Field f = testRegexBean01Cls.getDeclaredField("target003");
			
			p.process(f, bean, expected01);
			p.process(f, bean, expected02);
			actual01 = bean.target003.get(0);
			actual02 = bean.target003.get(1);
			
			Assert.assertEquals(expected01, actual01);
			Assert.assertEquals(expected02, actual02);
			
		} catch (SecurityException e) {
			e.printStackTrace();
			Assert.fail(e.getMessage());
		} catch (NoSuchFieldException e) {
			Assert.fail(e.getMessage());
		}
	}

}
