package org.dyndns.nuda.tools.regex;

import org.dyndns.nuda.tools.regex.annotation.Regex;
import org.dyndns.nuda.tools.regex.annotation.RegexItem;

@Regex(pattern = "(?:^|,)(?:\"((?:[^\"]|\"\")*)\"|([^,\"]*))", isMultiLine = true)
public class CSVColumn {
	
	@RegexItem(groupIndex = 2)
	public String	csv	= "";
}
// (?:^|,)(?:"((?:[^"]|"")*)"|([^,"]*))　の説明
// (?:^|,)							: 行頭もしくはカンマの後ろ
// (?:"(                            : ダブルクォートでかこまれている
//        (?:[^"]|"")*              : 先頭がカンマでも二重カンマでもない文字列の連続
//     )"
//         |
//     ([^,"]*)                     : カンマでもダブルクォートでもない文字列の連続
// )