package org.dyndns.nuda.tools.regex.processors;

import java.lang.reflect.Field;
import java.util.List;

import org.dyndns.nuda.tools.util.ReflectUtil;

public class ListStringInputSequenceProcessor implements InputSequenceProcessor {
	
	@Override
	public boolean accept(final Field targetField, final String inputSequence) {
		Class<?> targetClass = targetField.getType();
		//System.out.println("ListStringInputSequenceProcessor:accept:" + targetClass.getCanonicalName());
		if (List.class.equals(targetClass)) {
			
			Class<?> componentType =
					ReflectUtil.getParameterGenericType(targetField);
			if (String.class.equals(componentType)) {
				//System.out.println("ListStringInputSequenceProcessor:accepted:" + componentType.getCanonicalName());
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void process(final Field targetField, final Object instance,
			final String inputSequence) {
		//System.out.println("ListStringInputSequenceProcessor:process");
		try {
			@SuppressWarnings("rawtypes")
			List obj = (List) targetField.get(instance);
			obj.add(inputSequence);
			//System.out.println(inputSequence);
			//Method add = List.class.getDeclaredMethod("add", new Class<?>[]{Object.class});
			
			//add.invoke(obj, inputSequence);
			//System.out.println(inputSequence);
			targetField.set(instance, obj);
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
}
