package org.dyndns.nuda.tools.regex.processors;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class AutoInputSequenceProcessor implements InputSequenceProcessor {

	private static List<InputSequenceProcessor> processors = new ArrayList<InputSequenceProcessor>();

	static {
		// ここにシーケンスプロセッサ実装登録コードを記述
		processors.add(new StringInputSequenceProcessor());
		processors.add(new RegexInputSequenceProcessor());
		processors.add(new ListRegexInputSequenceProcessor());
		processors.add(new ListStringInputSequenceProcessor());
		processors.add(new ArrayRegexInputSequenceProcessor());
	}

	private AutoInputSequenceProcessor() {
		// ここにシーケンスプロセッサ実装登録コードを記述
		// processors.add(new StringInputSequenceProcessor());
		// processors.add(new RegexInputSequenceProcessor());
		// processors.add(new ListRegexInputSequenceProcessor());
		// processors.add(new ListStringInputSequenceProcessor());
		// processors.add(new ArrayRegexInputSequenceProcessor());
		// processors.add(new NOPInputSequenceProcessor());
	}

	private static InputSequenceProcessor ME = null;

	public static InputSequenceProcessor getInstance() {
		if (ME == null) {
			ME = new AutoInputSequenceProcessor();
		}
		return ME;
	}

	@Override
	public boolean accept(Field targetField, String inputSequence) {
		return true;
	}

	public static void addProcessor(InputSequenceProcessor processor) {
		if (processor != null) {
			// プロセッサリストの末尾にプロセッサインスタンスを追加
			processors.add(processor);
		}
	}

	@Override
	public void process(Field targetField, Object instance, String inputSequence) {
		if (instance == null) {
			return;
		}
		if (targetField == null) {
			return;
		}
		for (InputSequenceProcessor p : processors) {
			if (p.accept(targetField, inputSequence)) {
				p.process(targetField, instance, inputSequence);
				return;
			}
		}

		// すべてのプロセッサのacceptに失敗した場合は
		// NOPプロセッサを適用する
		new NOPInputSequenceProcessor().process(targetField, instance,
				inputSequence);
		return;
	}

}
