package org.dyndns.nuda.tools.regex.processors;

import java.awt.List;
import java.lang.reflect.Field;

import org.dyndns.nuda.tools.regex.RegexProcessor;
import org.dyndns.nuda.tools.regex.annotation.Regex;

public class ArrayRegexInputSequenceProcessor implements InputSequenceProcessor {

	@Override
	public boolean accept(Field targetField, String inputSequence) {
		Class<?> targetClass = targetField.getType();
		if(targetClass.isArray()) {
			Class<?> componentType = targetClass.getComponentType();
			if(componentType.isAnnotationPresent(Regex.class)) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	@Override
	public void process(Field targetField, Object instance, String inputSequence) {
		//System.out.println("ArrayRegexInputSequenceProcessor:process");
		Class<?> targetClass = targetField.getType();
		Class<?> componentType = targetClass.getComponentType();
		RegexProcessor rp = new RegexProcessor();
		
		java.util.List<?> result = rp.process(inputSequence, componentType);
		
		Object[] result0 = result.toArray();
		try {
			targetField.set(instance, result0);
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
	}

}
