/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.regex.util;

import java.lang.reflect.Field;

public class CommonToolsVersionCheck {
    public static boolean isValidVersion(int requiredVersion) {
        int toolVersion = 0;
        try {
            Class<?> cls = Class.forName("org.dyndns.nuda.management.Version");
            Field field = cls.getDeclaredField("version");
            Object obj = field.get(null);
            toolVersion = Integer.valueOf(obj.toString());
        }
        catch (Exception e) {
            toolVersion = 1201;
        }
        return requiredVersion <= toolVersion;
    }

    public static int getToolsVersion() {
        int toolVersion = 0;
        try {
            Class<?> cls = Class.forName("org.dyndns.nuda.management.Version");
            Field field = cls.getDeclaredField("version");
            Object obj = field.get(null);
            toolVersion = Integer.valueOf(obj.toString());
        }
        catch (Exception e) {
            toolVersion = 1201;
        }
        return toolVersion;
    }

    public static String getToolsVersionString() {
        return CommonToolsVersionCheck.getToolsVersionString(CommonToolsVersionCheck.getToolsVersion());
    }

    public static String getToolsVersionString(int version) {
        int toolVersion = version;
        int majorVersion = (toolVersion - toolVersion % 1000) / 1000;
        int minorVersion = ((toolVersion -= majorVersion * 1000) - toolVersion % 100) / 100;
        int branchVersion = ((toolVersion -= minorVersion * 100) - toolVersion % 10) / 10;
        int productStatus = ((toolVersion -= branchVersion * 10) - toolVersion % 1) / 1;
        StringBuilder b = new StringBuilder();
        b.append((Object)(majorVersion - 1)).append(".");
        b.append((Object)minorVersion).append(".");
        b.append((Object)branchVersion);
        if (productStatus == 1) {
            b.append("b");
        } else if (productStatus == 2) {
            b.append("a");
        } else if (productStatus == 3) {
            b.append("latest");
        } else if (productStatus == 4) {
            b.append("stable");
        }
        return b.toString();
    }
}

