/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.regex.reflection.cache;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dyndns.nuda.tools.regex.annotation.ProcessFilter;
import org.dyndns.nuda.tools.regex.reflection.cache.MethodCache;
import org.dyndns.nuda.tools.regex.util.FILTER_TIMING;

public class TargetMethodCache
implements MethodCache {
    private static TargetMethodCache ME = null;
    private static Map<Class<?>, Map<Integer, List<Method>>> preCache = new HashMap();
    private static Map<Class<?>, Map<Integer, List<Method>>> postCache = new HashMap();

    private TargetMethodCache() {
    }

    public static TargetMethodCache getInstance() {
        if (ME == null) {
            ME = new TargetMethodCache();
        }
        return ME;
    }

    @Override
    public Map<Integer, List<Method>> createPreProcessor(Class<?> targetClass) {
        Method[] methods;
        HashMap<Integer, List<Method>> result = null;
        if (targetClass == null) {
            return result;
        }
        if (preCache.containsKey(targetClass)) {
            result = preCache.get(targetClass);
            return result;
        }
        result = new HashMap();
        Method[] methodArray = methods = targetClass.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (this.isValidFilter(m)) {
                ProcessFilter filter = m.getAnnotation(ProcessFilter.class);
                int groupindex = filter.groupindex();
                FILTER_TIMING timing = filter.timing();
                if (timing.equals((Object)FILTER_TIMING.BEFORE_COMMITED)) {
                    if (result.containsKey(groupindex)) {
                        ((List)result.get(groupindex)).add(m);
                    } else {
                        ArrayList<Method> l = new ArrayList<Method>();
                        l.add(m);
                        result.put(groupindex, l);
                    }
                }
            }
            ++n2;
        }
        preCache.put(targetClass, result);
        return result;
    }

    @Override
    public Map<Integer, List<Method>> createPostProcessor(Class<?> targetClass) {
        Method[] methods;
        HashMap<Integer, List<Method>> result = null;
        if (targetClass == null) {
            return result;
        }
        if (postCache.containsKey(targetClass)) {
            result = postCache.get(targetClass);
            return result;
        }
        result = new HashMap();
        Method[] methodArray = methods = targetClass.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (this.isValidFilter(m)) {
                ProcessFilter filter = m.getAnnotation(ProcessFilter.class);
                int groupindex = filter.groupindex();
                FILTER_TIMING timing = filter.timing();
                if (timing.equals((Object)FILTER_TIMING.AFTER_COMMITED)) {
                    if (result.containsKey(groupindex)) {
                        ((List)result.get(groupindex)).add(m);
                    } else {
                        ArrayList<Method> l = new ArrayList<Method>();
                        l.add(m);
                        result.put(groupindex, l);
                    }
                }
            }
            ++n2;
        }
        postCache.put(targetClass, result);
        return result;
    }

    private boolean isValidFilter(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.isAnnotationPresent(ProcessFilter.class)) {
            return false;
        }
        Class<?> returnType = method.getReturnType();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (!"java.lang.String".equals(returnType.getCanonicalName())) {
            return false;
        }
        if (parameterTypes.length != 1) {
            return false;
        }
        Class<?> parameterType = parameterTypes[0];
        return !"java.lang.String".equals(parameterType.getCanonicalName());
    }

    public void init() {
    }
}

