/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.regex;

import java.io.IOException;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.dyndns.nuda.tools.regex.CSVRow;
import org.dyndns.nuda.tools.regex.ConStrRegexBean;
import org.dyndns.nuda.tools.regex.ConStrRegexBean02;
import org.dyndns.nuda.tools.regex.ConStrRegexBean03;
import org.dyndns.nuda.tools.regex.ConStrRegexBean04;
import org.dyndns.nuda.tools.regex.HostRegexBean;
import org.dyndns.nuda.tools.regex.RegexProcessor;
import org.dyndns.nuda.tools.util.StringUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class RegexProcessorTest
extends TestCase {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        System.out.println("start " + this.getName());
    }

    @After
    public void tearDown() throws Exception {
        System.out.println("end   " + this.getName());
    }

    @Test
    public void testProcess() {
        RegexProcessor p = new RegexProcessor();
        String testSource = "jdbc:mysql://192.168.0.1:3306/testdb";
        List resultList = p.process(testSource, ConStrRegexBean.class);
        if (resultList.size() == 0) {
            Assert.fail();
        }
        ConStrRegexBean bean = (ConStrRegexBean)resultList.get(0);
        Assert.assertEquals((String)bean.toString(), (String)"jdbc", (String)bean.coreName);
        Assert.assertEquals((String)bean.toString(), (String)"mysql", (String)bean.subProtocol);
        Assert.assertEquals((String)bean.toString(), (String)"192.168.0.1", (String)bean.host);
        Assert.assertEquals((String)bean.toString(), (String)"3306", (String)bean.port);
        Assert.assertEquals((String)bean.toString(), (String)"testdb", (String)bean.schemeName);
    }

    @Test
    public void testProcess02() {
        RegexProcessor p = new RegexProcessor();
        String testSource = "jdbc:mysql://192.168.0.1:3306/testdb";
        List resultList = p.process(testSource, ConStrRegexBean02.class);
        if (resultList.size() == 0) {
            Assert.fail();
        }
        ConStrRegexBean02 bean = (ConStrRegexBean02)resultList.get(0);
        Assert.assertEquals((String)bean.toString(), (String)"jdbc", (String)bean.coreName);
        Assert.assertEquals((String)bean.toString(), (String)"mysql", (String)bean.subProtocol);
        Assert.assertEquals((String)bean.toString(), (String)"3306", (String)bean.port);
        Assert.assertEquals((String)bean.toString(), (String)"testdb", (String)bean.schemeName);
        List<HostRegexBean> host = bean.host;
        if (host.size() == 0) {
            Assert.fail();
        }
        HostRegexBean hostRegexBean = host.get(0);
        Assert.assertEquals((String)host.toString(), (String)"192", (String)hostRegexBean.segment01);
        Assert.assertEquals((String)host.toString(), (String)"168", (String)hostRegexBean.segment02);
        Assert.assertEquals((String)host.toString(), (String)"0", (String)hostRegexBean.segment03);
        Assert.assertEquals((String)host.toString(), (String)"1", (String)hostRegexBean.segment04);
    }

    @Test
    public void testProcess03() {
        RegexProcessor p = new RegexProcessor();
        String testSource = "jdbc:mysql://192.168.0.1:3306/testdb";
        List resultList = p.process(testSource, ConStrRegexBean03.class);
        if (resultList.size() == 0) {
            Assert.fail();
        }
        ConStrRegexBean03 bean = (ConStrRegexBean03)resultList.get(0);
        Assert.assertEquals((String)bean.toString(), (String)"jdbc", (String)bean.coreName);
        Assert.assertEquals((String)bean.toString(), (String)"mysql", (String)bean.subProtocol);
        Assert.assertEquals((String)bean.toString(), (String)"3306", (String)bean.port);
        Assert.assertEquals((String)bean.toString(), (String)"testdb", (String)bean.schemeName);
        HostRegexBean host = bean.host;
        if (host == null) {
            Assert.fail();
        }
        Assert.assertEquals((String)host.toString(), (String)"192", (String)host.segment01);
        Assert.assertEquals((String)host.toString(), (String)"168", (String)host.segment02);
        Assert.assertEquals((String)host.toString(), (String)"0", (String)host.segment03);
        Assert.assertEquals((String)host.toString(), (String)"1", (String)host.segment04);
    }

    @Test
    public void testProcessBySingle01() {
        RegexProcessor p = new RegexProcessor();
        String testSource = "jdbc:mysql://192.168.0.1:3306/testdb";
        ConStrRegexBean03 result = (ConStrRegexBean03)p.processBySingle(testSource, ConStrRegexBean03.class);
        if (result == null) {
            Assert.fail();
        }
        Assert.assertEquals((String)result.toString(), (String)"jdbc", (String)result.coreName);
        Assert.assertEquals((String)result.toString(), (String)"mysql", (String)result.subProtocol);
        Assert.assertEquals((String)result.toString(), (String)"3306", (String)result.port);
        Assert.assertEquals((String)result.toString(), (String)"testdb", (String)result.schemeName);
        HostRegexBean host = result.host;
        if (host == null) {
            Assert.fail();
        }
        Assert.assertEquals((String)host.toString(), (String)"192", (String)host.segment01);
        Assert.assertEquals((String)host.toString(), (String)"168", (String)host.segment02);
        Assert.assertEquals((String)host.toString(), (String)"0", (String)host.segment03);
        Assert.assertEquals((String)host.toString(), (String)"1", (String)host.segment04);
    }

    @Test
    public void testProcess04() {
        RegexProcessor p = new RegexProcessor();
        List resultList = p.process(null, ConStrRegexBean.class);
        Assert.assertEquals((int)0, (int)resultList.size());
    }

    @Test
    public void testProcess05() {
        RegexProcessor p = new RegexProcessor();
        List resultList = p.process("aaa", null);
        Assert.assertEquals((int)0, (int)resultList.size());
    }

    @Test
    public void testProcess06() {
        RegexProcessor p = new RegexProcessor();
        List resultList = p.process("aaa", String.class);
        Assert.assertEquals((int)0, (int)resultList.size());
    }

    @Test
    public void testProcessBySingle02() {
        RegexProcessor p = new RegexProcessor();
        ConStrRegexBean result = (ConStrRegexBean)p.processBySingle(null, ConStrRegexBean.class);
        Assert.assertNull((String)"", (Object)result.coreName);
        Assert.assertNull((String)"", (Object)result.subProtocol);
        Assert.assertNull((String)"", (Object)result.host);
        Assert.assertNull((String)"", (Object)result.port);
        Assert.assertNull((String)"", (Object)result.schemeName);
    }

    @Test
    public void testProcessBySingle03() {
        RegexProcessor p = new RegexProcessor();
        ConStrRegexBean result = (ConStrRegexBean)p.processBySingle("aaa", null);
        Assert.assertNull((String)"", (Object)result);
    }

    @Test
    public void testProcessBySingle04() {
        RegexProcessor p = new RegexProcessor();
        String result = (String)p.processBySingle("aaa", String.class);
        Assert.assertEquals((String)"", (String)result);
    }

    public void testMulti01() {
        RegexProcessor p = new RegexProcessor();
        String testSource = "jdbc:mysql://192.168.0.1:3306/testdb";
        ConStrRegexBean04 result = (ConStrRegexBean04)p.processBySingle(testSource, ConStrRegexBean04.class);
        if (result == null) {
            Assert.fail();
        }
        Assert.assertEquals((String)result.toString(), (String)"jdbc", (String)result.coreName);
        Assert.assertEquals((String)result.toString(), (String)"mysql", (String)result.subProtocol);
        Assert.assertEquals((String)result.toString(), (String)"3306", (String)result.port);
        Assert.assertEquals((String)result.toString(), (String)"testdb", (String)result.schemeName);
        Assert.assertEquals((String)result.toString(), (String)"192.168.0.1", (String)result.hostStr);
        HostRegexBean host = result.host;
        if (host == null) {
            Assert.fail();
        }
        Assert.assertEquals((String)host.toString(), (String)"192", (String)host.segment01);
        Assert.assertEquals((String)host.toString(), (String)"168", (String)host.segment02);
        Assert.assertEquals((String)host.toString(), (String)"0", (String)host.segment03);
        Assert.assertEquals((String)host.toString(), (String)"1", (String)host.segment04);
        HostRegexBean host2 = result.host2;
        if (host2 == null) {
            Assert.fail();
        }
        Assert.assertEquals((String)host2.toString(), (String)"192", (String)host2.segment01);
        Assert.assertEquals((String)host2.toString(), (String)"168", (String)host2.segment02);
        Assert.assertEquals((String)host2.toString(), (String)"0", (String)host2.segment03);
        Assert.assertEquals((String)host2.toString(), (String)"1", (String)host2.segment04);
    }

    public void testArrayString() {
        String path = "org/dyndns/nuda/tools/regex/test.csv";
        try {
            String source = StringUtil.loadString((String)path);
            RegexProcessor rp = new RegexProcessor();
            List result = rp.process(source, CSVRow.class);
            Assert.assertEquals((int)1000, (int)result.size());
            Assert.assertEquals((String)"aaa", (String)((CSVRow)result.get((int)0)).csvRow.get((int)0).csv);
            Assert.assertEquals((String)"bbb", (String)((CSVRow)result.get((int)0)).csvRow.get((int)1).csv);
            Assert.assertEquals((String)"ccc", (String)((CSVRow)result.get((int)0)).csvRow.get((int)2).csv);
            Assert.assertEquals((String)"aaa,bbb,ccc", (String)((CSVRow)result.get((int)0)).inputSequence);
            Assert.assertEquals((String)"ddd", (String)((CSVRow)result.get((int)1)).csvRow.get((int)0).csv);
            Assert.assertEquals((String)"eee", (String)((CSVRow)result.get((int)1)).csvRow.get((int)1).csv);
            Assert.assertEquals((String)"fff", (String)((CSVRow)result.get((int)1)).csvRow.get((int)2).csv);
            Assert.assertEquals((String)"ddd,eee,fff", (String)((CSVRow)result.get((int)1)).inputSequence);
            int i = 2;
            while (i <= 998) {
                Assert.assertEquals((String)"ggg", (String)((CSVRow)result.get((int)i)).csvRow.get((int)0).csv);
                Assert.assertEquals((String)"hhh", (String)((CSVRow)result.get((int)i)).csvRow.get((int)1).csv);
                Assert.assertEquals((String)"iii", (String)((CSVRow)result.get((int)i)).csvRow.get((int)2).csv);
                Assert.assertEquals((String)"ggg,hhh,iii", (String)((CSVRow)result.get((int)i)).inputSequence);
                ++i;
            }
            Assert.assertEquals((String)"xxx", (String)((CSVRow)result.get((int)999)).csvRow.get((int)0).csv);
            Assert.assertEquals((String)"yyy", (String)((CSVRow)result.get((int)999)).csvRow.get((int)1).csv);
            Assert.assertEquals((String)"zzz", (String)((CSVRow)result.get((int)999)).csvRow.get((int)2).csv);
            Assert.assertEquals((String)"xxx,yyy,zzz", (String)((CSVRow)result.get((int)999)).inputSequence);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

