/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.regex;

import java.util.List;
import junit.framework.Assert;
import org.dyndns.nuda.tools.regex.ConStrRegexBean;
import org.dyndns.nuda.tools.regex.ConStrRegexBean02;
import org.dyndns.nuda.tools.regex.ConStrRegexBean03;
import org.dyndns.nuda.tools.regex.HostRegexBean;
import org.dyndns.nuda.tools.regex.RegexProcessor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RegexProcessorTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testProcess() {
        RegexProcessor p = new RegexProcessor();
        String testSource = "jdbc:mysql://192.168.0.1:3306/testdb";
        List resultList = p.process(testSource, ConStrRegexBean.class);
        if (resultList.size() == 0) {
            Assert.fail();
        }
        ConStrRegexBean bean = (ConStrRegexBean)resultList.get(0);
        Assert.assertEquals((String)bean.toString(), (String)"jdbc", (String)bean.coreName);
        Assert.assertEquals((String)bean.toString(), (String)"mysql", (String)bean.subProtocol);
        Assert.assertEquals((String)bean.toString(), (String)"192.168.0.1", (String)bean.host);
        Assert.assertEquals((String)bean.toString(), (String)"3306", (String)bean.port);
        Assert.assertEquals((String)bean.toString(), (String)"testdb", (String)bean.schemeName);
    }

    @Test
    public void testProcess02() {
        RegexProcessor p = new RegexProcessor();
        String testSource = "jdbc:mysql://192.168.0.1:3306/testdb";
        List resultList = p.process(testSource, ConStrRegexBean02.class);
        if (resultList.size() == 0) {
            Assert.fail();
        }
        ConStrRegexBean02 bean = (ConStrRegexBean02)resultList.get(0);
        Assert.assertEquals((String)bean.toString(), (String)"jdbc", (String)bean.coreName);
        Assert.assertEquals((String)bean.toString(), (String)"mysql", (String)bean.subProtocol);
        Assert.assertEquals((String)bean.toString(), (String)"3306", (String)bean.port);
        Assert.assertEquals((String)bean.toString(), (String)"testdb", (String)bean.schemeName);
        List<HostRegexBean> host = bean.host;
        if (host.size() == 0) {
            Assert.fail();
        }
        HostRegexBean hostRegexBean = host.get(0);
        Assert.assertEquals((String)host.toString(), (String)"192", (String)hostRegexBean.segment01);
        Assert.assertEquals((String)host.toString(), (String)"168", (String)hostRegexBean.segment02);
        Assert.assertEquals((String)host.toString(), (String)"0", (String)hostRegexBean.segment03);
        Assert.assertEquals((String)host.toString(), (String)"1", (String)hostRegexBean.segment04);
    }

    @Test
    public void testProcess03() {
        RegexProcessor p = new RegexProcessor();
        String testSource = "jdbc:mysql://192.168.0.1:3306/testdb";
        List resultList = p.process(testSource, ConStrRegexBean03.class);
        if (resultList.size() == 0) {
            Assert.fail();
        }
        ConStrRegexBean03 bean = (ConStrRegexBean03)resultList.get(0);
        Assert.assertEquals((String)bean.toString(), (String)"jdbc", (String)bean.coreName);
        Assert.assertEquals((String)bean.toString(), (String)"mysql", (String)bean.subProtocol);
        Assert.assertEquals((String)bean.toString(), (String)"3306", (String)bean.port);
        Assert.assertEquals((String)bean.toString(), (String)"testdb", (String)bean.schemeName);
        HostRegexBean host = bean.host;
        if (host == null) {
            Assert.fail();
        }
        Assert.assertEquals((String)host.toString(), (String)"192", (String)host.segment01);
        Assert.assertEquals((String)host.toString(), (String)"168", (String)host.segment02);
        Assert.assertEquals((String)host.toString(), (String)"0", (String)host.segment03);
        Assert.assertEquals((String)host.toString(), (String)"1", (String)host.segment04);
    }

    @Test
    public void testProcessBySingle01() {
        RegexProcessor p = new RegexProcessor();
        String testSource = "jdbc:mysql://192.168.0.1:3306/testdb";
        ConStrRegexBean03 result = (ConStrRegexBean03)p.processBySingle(testSource, ConStrRegexBean03.class);
        if (result == null) {
            Assert.fail();
        }
        Assert.assertEquals((String)result.toString(), (String)"jdbc", (String)result.coreName);
        Assert.assertEquals((String)result.toString(), (String)"mysql", (String)result.subProtocol);
        Assert.assertEquals((String)result.toString(), (String)"3306", (String)result.port);
        Assert.assertEquals((String)result.toString(), (String)"testdb", (String)result.schemeName);
        HostRegexBean host = result.host;
        if (host == null) {
            Assert.fail();
        }
        Assert.assertEquals((String)host.toString(), (String)"192", (String)host.segment01);
        Assert.assertEquals((String)host.toString(), (String)"168", (String)host.segment02);
        Assert.assertEquals((String)host.toString(), (String)"0", (String)host.segment03);
        Assert.assertEquals((String)host.toString(), (String)"1", (String)host.segment04);
    }
}

