/*
 * Copyright (C) 2002 Robert Ernst <robert.ernst@linux-solutions.at>
 *
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file LICENSE.GPL included in the
 * packaging of this file.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See COPYING for GPL licensing information.
 *
 */

#include <qwidget.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qimage.h>
#include <qpainter.h>
#include "SpriteCollection.h"
#include "images/data.c"

#define BOOT_LOGO_X 25
#define BOOT_LOGO_Y 100
#define BOOT_LOGOSTRING_X 100
#define BOOT_LOGOSTRING_Y 140
#define BOOT_LOGOSTRING "PRESENTS"

#define TITLE_X 165
#define TITLE_Y  45 
#define LOGO_X  177  
#define LOGO_Y    3
#define TITLEBACK_X 105
#define TITLEBACK_Y 220

SpriteCollection::SpriteCollection(QWidget *parent)
{
    m_parent = parent;
    m_tile[0].loadFromData(img_0_data_, sizeof (img_0_data_));
    m_tile[1].loadFromData(img_1_data_, sizeof (img_1_data_));
    m_tile[2].loadFromData(img_2_data_, sizeof (img_2_data_));
    m_tile[3].loadFromData(img_3_data_, sizeof (img_3_data_));
    m_tile[4].loadFromData(img_4_data_, sizeof (img_4_data_));
    m_tile[5].loadFromData(img_5_data_, sizeof (img_5_data_));
    m_tile[6].loadFromData(img_6_data_, sizeof (img_6_data_));
    m_tile[7].loadFromData(img_7_data_, sizeof (img_7_data_));
    m_tile[8].loadFromData(img_8_data_, sizeof (img_8_data_));
    m_tile[9].loadFromData(img_9_data_, sizeof (img_9_data_));
    m_tile[10].loadFromData(img_10_data_, sizeof (img_10_data_));
    m_tile[11].loadFromData(img_11_data_, sizeof (img_11_data_));
    m_tile[12].loadFromData(img_12_data_, sizeof (img_12_data_));
    m_tile[13].loadFromData(img_13_data_, sizeof (img_13_data_));
    m_tile[14].loadFromData(img_14_data_, sizeof (img_14_data_));
    m_tile[15].loadFromData(img_15_data_, sizeof (img_15_data_));
    m_tile[16].loadFromData(img_16_data_, sizeof (img_16_data_));
    m_tile[17].loadFromData(img_17_data_, sizeof (img_17_data_));
    m_tile[18].loadFromData(img_18_data_, sizeof (img_18_data_));
    m_tile[19].loadFromData(img_19_data_, sizeof (img_19_data_));
    m_tile[20].loadFromData(img_20_data_, sizeof (img_20_data_));
    m_tile[21].loadFromData(img_21_data_, sizeof (img_21_data_));
    m_tile[22].loadFromData(img_22_data_, sizeof (img_22_data_));
    m_tile[23].loadFromData(img_23_data_, sizeof (img_23_data_));
    m_tile[24].loadFromData(img_24_data_, sizeof (img_24_data_));
    m_tile[25].loadFromData(img_25_data_, sizeof (img_25_data_));
    m_tile[26].loadFromData(img_26_data_, sizeof (img_26_data_));
    m_tile[27].loadFromData(img_27_data_, sizeof (img_27_data_));
    m_tile[28].loadFromData(img_28_data_, sizeof (img_28_data_));
    m_tile[29].loadFromData(img_29_data_, sizeof (img_29_data_));
    m_tile[30].loadFromData(img_30_data_, sizeof (img_30_data_));
    m_tile[31].loadFromData(img_31_data_, sizeof (img_31_data_));
    m_tile[32].loadFromData(img_32_data_, sizeof (img_32_data_));
    m_tile[33].loadFromData(img_33_data_, sizeof (img_33_data_));
    m_tile[34].loadFromData(img_34_data_, sizeof (img_34_data_));
    m_tile[35].loadFromData(img_35_data_, sizeof (img_35_data_));
    m_tile[36].loadFromData(img_36_data_, sizeof (img_36_data_));
    m_tile[37].loadFromData(img_37_data_, sizeof (img_37_data_));
    m_tile[38].loadFromData(img_38_data_, sizeof (img_38_data_));
    m_tile[39].loadFromData(img_39_data_, sizeof (img_39_data_));
    m_tile[40].loadFromData(img_40_data_, sizeof (img_40_data_));
    m_tile[41].loadFromData(img_41_data_, sizeof (img_41_data_));
    m_tile[42].loadFromData(img_42_data_, sizeof (img_42_data_));
    m_tile[43].loadFromData(img_43_data_, sizeof (img_43_data_));
    m_tile[44].loadFromData(img_44_data_, sizeof (img_44_data_));
    m_background = new QPixmap;
    m_background->loadFromData(background_data_, sizeof (background_data_));
     
    m_bootImg.loadFromData(bootlogo_data_, sizeof (bootlogo_data_));
    m_titleImg[0].loadFromData(title_data_, sizeof (title_data_));
    m_titleImg[1].loadFromData(logo_data_, sizeof (logo_data_));
    m_titleImg[2].loadFromData(titleback_data_, sizeof (titleback_data_));
    m_button[0].loadFromData(simple_data_, sizeof (simple_data_));
    m_button[2].loadFromData(config_data_, sizeof (config_data_));
			       
    
}

void SpriteCollection::drawTile(QPainter &painter, int x, int y, int which)
{
    if (which >= 0 && which <= 44) {
	painter.drawPixmap(x, y, m_tile[which]);
    }
}

QPixmap *SpriteCollection::backgroundPixmap(void)
{
    return m_background;
}

QPixmap *SpriteCollection::tilePixmap(int which)
{
    if (which >= 0 && which <= 44) {
	return &m_tile[which];
    } else {
	return m_background;
    }
}

int SpriteCollection::tileWidth(void)
{
    return 20;
}

int SpriteCollection::tileHeight(void)
{
    return 28;
}

void SpriteCollection::drawBoot(QPainter &paint, int width, int height)
{
  QColor white( 255, 255, 255 );
  QColor black(0,0,0);

  paint.fillRect( 0, 0, width, height, white );
  paint.drawPixmap( BOOT_LOGO_X, BOOT_LOGO_Y, m_bootImg );

  paint.setPen( black );
  paint.drawText( BOOT_LOGOSTRING_X, BOOT_LOGOSTRING_Y, BOOT_LOGOSTRING );  
}
void SpriteCollection::drawBoot(QPainter *paint, int width, int height)
{
  QColor white( 255, 255, 255 );
  QColor black(0,0,0);

  paint->fillRect( 0, 0, width, height, white );
  paint->drawPixmap( BOOT_LOGO_X, BOOT_LOGO_Y, m_bootImg );

  paint->setPen( black );
  paint->drawText( BOOT_LOGOSTRING_X, BOOT_LOGOSTRING_Y, BOOT_LOGOSTRING );  
}

void SpriteCollection::drawTitle(QPainter &paint, int width, int height)
{
  QColor white( 255, 234, 245 );

  paint.fillRect( 0, 0, width, height, white );
  paint.drawPixmap( TITLE_X, TITLE_Y, m_titleImg[0] );
  paint.drawPixmap( LOGO_X, LOGO_Y, m_titleImg[1] );
  paint.drawPixmap( TITLEBACK_X, TITLEBACK_Y, m_titleImg[2] );

}
QPixmap *SpriteCollection::buttonPixmap(int which)
{
  return &m_button[which];
}
