/*
  Copyright (C) 2005  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef SCOREMNG_H
#define SCOREMNG_H

#include <qfile.h>

#include "Score.h"

#define REGIST_MAX 5


class CScoreMng
{

 public:
  CScoreMng(QString scoreFile);
  bool IsRankIn(int score);
  bool RegistHiScore(struct tm *time, int score);
  bool SaveHiScore();
  bool GetHiScore(int rank, struct tm *ptime, int *score);
  int GetHiScore(int rank);
  bool DownLoadHiScore();
  void SetOrder( bool order );

 private:

  bool OpenDataFile(QFile *pFile);
  void Save(QFile *pFile);
  int  Load(QFile *pFile);
  void InitHiScore();

  QString m_scoreFile;
  CScore* m_pScore[REGIST_MAX];
  int m_version;
  bool m_order;  //true  : biggest score is located top.
                 //false : lowest score is located top.

};



#endif
