/*
  Copyright (C) 2005  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include <qcombobox.h>
#include <qlabel.h>

#include "ScoreListDlg.h"
#include "StringTable.h"

CScoreListDlg::CScoreListDlg(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 )
:CScoreListDlgBase( parent, name, fl )
{
  setCaption( STRING_UTF8(ID_STRING_2010) );

  Label->setText( STRING_UTF8(ID_STRING_10) );
  CategoryCmb->insertItem( "8x6" );
  CategoryCmb->insertItem( "8x8" );
  CategoryCmb->insertItem( "10x6" );
  CategoryCmb->insertItem( "10x8" );
  connect( CategoryCmb, SIGNAL( activated( int ) ),
             this, SLOT ( changeList( int ) ) );

  m_pScoreList->clear();
  m_pScoreList->setColumnText( 0, STRING_UTF8(ID_STRING_2011) );
  m_pScoreList->addColumn( STRING_UTF8(ID_STRING_2012) );
  m_pScoreList->addColumn( STRING_UTF8(ID_STRING_2013) );
  m_pScoreList->setColumnWidth( 0, 35 );
  m_pScoreList->setColumnWidth( 1, 70 );
  m_pScoreList->setColumnWidth( 2, 82 );

  for( int i = 0; i < 5; i++ ){
    m_scoreItem[ i ] = new QListViewItem( m_pScoreList, " ", " ", " ");
    m_pScoreList->insertItem( m_scoreItem[ i ] );
  }


}
void CScoreListDlg::SetScoreMng(CScoreMng **pScoreMng)
{
  m_pScoreMng = pScoreMng;
  setUpScoreList(0);
}
void CScoreListDlg::setUpScoreList( int category )
{
  int score;
  QString str;
  int i;
  struct tm tStamp;

  for(i=0;i<5;i++){
    int h,m,s;
    QString sTime,sTimeStamp;

    (*(m_pScoreMng+ category ))->GetHiScore(i+1,&tStamp,&score);

    CScore::getTime( score, &h, &m, &s );
    m_scoreItem[i]->setText( 0, QString::number( i+1 ));
    sTime =  QString::number(h)+"h "+ QString::number(m)+"m "
      + QString::number(s)+"s";
    m_scoreItem[i]->setText( 1, sTime );

    sTimeStamp = QString::number(tStamp.tm_year+1900)+QString("/")
      +QString::number(tStamp.tm_mon+1)+QString("/")
      +QString::number(tStamp.tm_mday)+QString("/")
      +QString::number(tStamp.tm_hour)+QString(":")
      +QString::number(tStamp.tm_min);
    m_scoreItem[i]->setText( 2, sTimeStamp );
  }

}
void CScoreListDlg::changeList( int index )
{
  setUpScoreList( index );
}
