/*
 * Copyright (C) 2004 Taiga Yonekura <taiga@col.hi-ho.ne.jp>
 *
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file LICENSE.GPL included in the
 * packaging of this file.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See COPYING for GPL licensing information.
 *
 */

#include <qpe/config.h>

#include "ConfigInfo.h"

CConfigInfo::CConfigInfo()
{
  readConfig();
}
void CConfigInfo::GetSize( int *width, int *height )
{

  switch (m_size) {

  case 0: 
    *width = 8;
    *height = 6;
    break;

  case 1:
    *width = 8;
    *height = 8;
    break;

  case 2: 
    *width = 10;
    *height = 6;
    break;

  case 3: 
    *width = 10;
    *height = 8;
    break;
  }
}
int CConfigInfo::GetSize()
{
  return m_size;
}
int CConfigInfo::GetSpeed()
{
  return m_speed;
}
int CConfigInfo::GetIq()
{
  return m_iq;
}
int CConfigInfo::GetGravity()
{
  return m_gravity;
}
void CConfigInfo::SetSize( int size )
{
  m_size = size;
}
void  CConfigInfo::SetSpeed( int speed )
{

    if (speed <= 125) {
	m_speed = 125;
    } else if (speed <= 250) {
	m_speed = 250;
    } else if (speed <= 500) {
	m_speed = 500;
    } else if (speed <= 750) {
	m_speed = 750;
    } else {
	m_speed = 1000;
    }

}
void  CConfigInfo::SetIq( int iq )
{
  m_iq = iq;  
}
void  CConfigInfo::SetGravity( int gravity )
{
  m_gravity = gravity;
}
void CConfigInfo::readConfig(void)
{
    Config cfg("ShisenSho");

    cfg.setGroup("Settings");

    int speed = cfg.readNumEntry("Speed", 500);
    SetSpeed(speed);

    int size = cfg.readNumEntry("Size", 3);
    if (size <= 0) {
	m_size = 0;
    } else if (size >= 3) {
	m_size = 3;
    } else {
	m_size = size;
    }

    int iq = cfg.readNumEntry("IQ", 5);
    if (iq <= 1) {
	m_iq = 1;
    } else if (iq <= 5) {
	m_iq = 5;
    } else {
	m_iq = 9;
    }

    int gravity = cfg.readNumEntry("Gravity", 0);
    if (gravity <= 0) {
	m_gravity = 0;
    } else {
	m_gravity = 1;
    }
}
void CConfigInfo::writeConfig(void)
{
    Config cfg("ShisenSho");

    cfg.setGroup("Settings");
    cfg.writeEntry("Speed", m_speed);
    cfg.writeEntry("Size", m_size);
    cfg.writeEntry("IQ", m_iq);
    cfg.writeEntry("Gravity", m_gravity);
}
