/*
 * Copyright (C) 2004 Taiga Yonekura <taiga@col.hi-ho.ne.jp>
 *
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file LICENSE.GPL included in the
 * packaging of this file.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See COPYING for GPL licensing information.
 *
 */
#include <qcombobox.h>
#include <qlabel.h>

#include "CConfigDlg.h"
#include "StringTable.h"

CConfigDlg::CConfigDlg(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 ):ConfigDlgBase( parent, name, fl )
{
  m_pConfigInfo = NULL;
  SetupConfig();
}
void CConfigDlg::SetupConfig()
{

  SpeedLbl->setText(STRING_UTF8(ID_STRING_01));
  SpeedCombo->insertItem(STRING_UTF8(ID_STRING_02));
  SpeedCombo->insertItem(STRING_UTF8(ID_STRING_03));
  SpeedCombo->insertItem(STRING_UTF8(ID_STRING_04));
  SpeedCombo->insertItem(STRING_UTF8(ID_STRING_05));
  SpeedCombo->insertItem(STRING_UTF8(ID_STRING_06));

  SizeLbl->setText(STRING_UTF8(ID_STRING_10));
  SizeCombo->insertItem(tr("8x6"));
  SizeCombo->insertItem(tr("8x8"));
  SizeCombo->insertItem(tr("10x6"));
  SizeCombo->insertItem(tr("10x8"));

  LevelLbl->setText(STRING_UTF8(ID_STRING_20));
  LevelCombo->insertItem(STRING_UTF8(ID_STRING_21));
  LevelCombo->insertItem(STRING_UTF8(ID_STRING_22));
  LevelCombo->insertItem(STRING_UTF8(ID_STRING_23));

  GraveLbl->setText(STRING_UTF8(ID_STRING_30));
  GraveCombo->insertItem(STRING_UTF8(ID_STRING_31));
  GraveCombo->insertItem(STRING_UTF8(ID_STRING_32));

}
void CConfigDlg::setConfigInfo( CConfigInfo *pInfo )
{
  m_pConfigInfo = pInfo;
  SetConfigItem();
}
void CConfigDlg::SetConfigItem()
{
  if(m_pConfigInfo){
    SpeedCombo->setCurrentItem(GetSpeedIndex(m_pConfigInfo->GetSpeed()));
    SizeCombo->setCurrentItem(m_pConfigInfo->GetSize());
    LevelCombo->setCurrentItem(m_pConfigInfo->GetIq());
    GraveCombo->setCurrentItem(m_pConfigInfo->GetGravity());
  }
}
void CConfigDlg::GetConfigItem()
{
  int speed,size,level,grave;

  // Speed
  speed = SpeedCombo->currentItem();
  // Size
  size = SizeCombo->currentItem();
  // Level
  level = LevelCombo->currentItem();
  // Grave
  grave = GraveCombo->currentItem();
  
  if(m_pConfigInfo){
    m_pConfigInfo->SetSpeed(GetSpeedFormIndex(speed));
    m_pConfigInfo->SetSize(size);
    m_pConfigInfo->SetIq(level);
    m_pConfigInfo->SetGravity(grave);
  }

}
int CConfigDlg::GetSpeedIndex(int speed)
{
    if (speed <= 125) {
	return 0;
    } else if (speed <= 250) {
	return 1;
    } else if (speed <= 500) {
	return 2;
    } else if (speed <= 750) {
	return 3;
    } else {
	return 4;
    }

}
int CConfigDlg::GetSpeedFormIndex(int idx)
{

  switch(idx){
  case 0:
    return 125;
  case 1:
    return 250;
  case 2:
    return 500;
  case 3:
    return 750;
  case 4:
    return 1000;
  }

}
