#!/bin/sh

if [ "$1" = "cross" ]; then
    export CROSSCOMPILE=/opt/Embedix/tools
    export QPEDIR=/opt/Qtopia/sharp
    export QTDIR=/opt/Qtopia/sharp
    export PATH=$QTDIR/bin:$QPEDIR/bin:$CROSSCOMPILE/bin:$PATH
    export TMAKEPATH=/opt/Qtopia/tmake/lib/qws/linux-sharp-g++/
    export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH
elif [ "$1" = "native" ]; then
    export CROSSCOMPILE=
    export QPEDIR=/opt/Qtopia
    export QTDIR=/opt/Qtopia
    export PATH=$QTDIR/bin:$QPEDIR/bin:$PATH:/opt/Embedix/tools/bin
    export TMAKEPATH=/opt/Qtopia/tmake/lib/qws/linux-x86-g++/
    export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH
else
    echo "usage: $0 cross | native"
    exit 1
fi

TMPDIR=rireki_1.1.0

#make -C tools
#make -C images

lv -Ou8cp StringTable.rsc > StringTable.h

tmake -o Makefile rireki.pro
make

mkdir ${TMPDIR}
cd ${TMPDIR}
mkdir -p opt/QtPalmtop/apps/Applications
mkdir -p opt/QtPalmtop/bin
mkdir -p opt/QtPalmtop/pics
mkdir -p opt/QtPalmtop/help/html
mkdir -p CONTROL

lv -Ou8cp ../desktop/rireki.desktop > opt/QtPalmtop/apps/Applications/rireki.desktop
cp ../rireki opt/QtPalmtop/bin
cp ../desktop/rireki.png opt/QtPalmtop/pics
lv -Ou8cp ../desktop/rireki.html > opt/QtPalmtop/help/html/rireki.html
cp ../desktop/rireki.control CONTROL/control
cp ../desktop/rireki.prerm CONTROL/prerm
cd ..
ipkg-build ${TMPDIR}
rm -rf ${TMPDIR}

