
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qstring.h>
#include <qcombobox.h>
#include <qmessagebox.h>
#include <qlabel.h>

#include "SchoolInputDlg.h"
#include "StringTable.h"
 
CSchoolInputDlg::CSchoolInputDlg(QWidget* parent, const char* name, WFlags fl)
  :CSchoolInputDlgBase( parent, name, fl )
{
  connect( OkBtn, SIGNAL(clicked()), this, SLOT(exitDlg()) );

  setCaption( STRING_UTF8(ID_STRING_1000));

  birthLbl->setText( STRING_UTF8(ID_STRING_1001) );
  BYearTypeCmb->insertItem( STRING_UTF8(ID_STRING_1002) );
  BYearTypeCmb->insertItem( STRING_UTF8(ID_STRING_1003) );
  yearLbl->setText( STRING_UTF8(ID_STRING_1004) );
  monthLbl->setText( STRING_UTF8(ID_STRING_1005) );

  SchoolCmb->insertItem( STRING_UTF8(ID_STRING_1006) );
  SchoolCmb->insertItem( STRING_UTF8(ID_STRING_1007) );
  SchoolCmb->insertItem( STRING_UTF8(ID_STRING_1008) );
  SchoolCmb->insertItem( STRING_UTF8(ID_STRING_1009) );
  SchoolCmb->insertItem( STRING_UTF8(ID_STRING_1010) );
 
  finaltLbl->setText( STRING_UTF8(ID_STRING_1011) );
  tryLbl->setText( STRING_UTF8(ID_STRING_1012) );
  stayLbl->setText( STRING_UTF8(ID_STRING_1013) );
}

int CSchoolInputDlg::getCareerItem()
{

  bool ok;
  int year,domyear,type,month;
  int finalSchool,stayYear,failYear;

  /* get Birth Year */
  QString str = BYearLineEdit->text();
  year= str.toInt( &ok, 10 );

  if(!ok){
    /* not Number */
    QMessageBox::information( this, STRING_UTF8(ID_STRING_1014),
			      STRING_UTF8(ID_STRING_1015));
    return -1;    
  }

  /* get Birth Year Type */
  type = BYearTypeCmb->currentItem();
  domyear = m_pschoolData->convertToYear(type,year);

  if((year <= 0) 
     || (type == SYOUWA && m_pschoolData->chkSyowa( domyear ) == false )){
    /* Out of range */
    QMessageBox::information( this, STRING_UTF8(ID_STRING_1014),
			      STRING_UTF8(ID_STRING_1015));
    return -1;
  }

  /* get Birth Month */
  month = MonthCmb->currentItem() + 1;

  /* get final School */
  finalSchool = SchoolCmb->currentItem();

  /* get term of enter College */
  failYear = TryYearCmb->currentItem();

  /* get over year in College */
  stayYear = StayYearCmb->currentItem();

  /* save to SchoolData Instance */
  m_pschoolData->SetBarthDay(domyear,month);
  m_pschoolData->setFinalSchool(finalSchool);
  m_pschoolData->setFailYear(failYear);
  m_pschoolData->setStayYear(stayYear);

  return 0;
 
}
void CSchoolInputDlg::setCareerItem()
{
  int year;
  QString str;

  /* set Birth Year Type */
  if(m_pschoolData->chkSyowa(m_pschoolData->getBarthYear())){
    BYearTypeCmb->setCurrentItem(0);
  } else {
    BYearTypeCmb->setCurrentItem(1);
  }

  /* set Birth Year */
  year = m_pschoolData->convertToJapnYear( m_pschoolData->getBarthYear());
  str.setNum(year,10);
  BYearLineEdit->insert(str);

  /* set Birth Month */
   MonthCmb->setCurrentItem( m_pschoolData->getBarthMonth() - 1 );

  /* set final School */
  SchoolCmb->setCurrentItem( m_pschoolData->getFinalSchool() );

  /* set term of enter College */
  TryYearCmb->setCurrentItem( m_pschoolData->getFailYear() );

  /* set over year in College */
  StayYearCmb->setCurrentItem( m_pschoolData->getStayYear() );

}
void CSchoolInputDlg::setSchoolData(CSchoolData *pdata)
{
  m_pschoolData = pdata;
  setCareerItem();
}
void CSchoolInputDlg::exitDlg()
{
  if(!getCareerItem()){
    close();
  }

}

