
#include "MainWidget.h"
#include "SchoolInputDlg.h"
#include "SchoolCareerDlg.h"
#include "JyearListDlg.h"

#include <qdir.h>
#include <qpushbutton.h>

#include <stdio.h>
#include "StringTable.h"

#define DATA_VER 1
#define SETTING_DATA_FNAME "rireki.dat"


CMainWidget::CMainWidget(QWidget* parent, const char* name, WFlags fl)
  :CMainWidgetBase( parent, name, fl )
{
  connect( SetSchoolCareerBtn, SIGNAL(clicked()), this, SLOT(showSchool()) );
  connect( ShowSchoolCareerBtn, SIGNAL(clicked()), this, SLOT(showSchoolSet()) );
  connect( JYearListBtn, SIGNAL(clicked()), this, SLOT(showJyearList()) );
  connect( ExitBtn, SIGNAL(clicked()), this, SLOT(goodBye()) );

  SetSchoolCareerBtn->setText( STRING_UTF8(ID_STRING_01) );
  ShowSchoolCareerBtn->setText( STRING_UTF8(ID_STRING_02) );
  JYearListBtn->setText( STRING_UTF8(ID_STRING_05) );
  ExitBtn->setText( STRING_UTF8(ID_STRING_03) );

  setCaption( STRING_UTF8(ID_STRING_04));

  /* create SchoolData */
  m_pschoolData = new CSchoolData();
  LoadData();
}

void CMainWidget::goodBye()
{
  SaveData();
  close();
}
void CMainWidget::showSchool()
{
  CSchoolInputDlg win(this, "Options", true);

  win.setSchoolData(m_pschoolData);
  if(win.exec() == 1){
  }

}
void CMainWidget::showSchoolSet()
{
  CSchoolCareerDlg win(this, "Options", true);
  win.setSchoolData(m_pschoolData);

  if( isQVGA() ){
    win.setFixedSize ( 400, 400 );
  }

  if(win.exec() == 1){
  }

}
void CMainWidget::showJyearList()
{
  CJyearListDlg win(this, "Options", true);

  if( isQVGA() ){
    win.setFixedSize ( 400, 400 );
  }

  if(win.exec() == 1){
  }

}
//
// Load Setting Data
//
void CMainWidget::LoadData()
{
 

  QFile file(SETTING_DATA_FNAME);

  if(OpenDataFile(&file)){
    m_pschoolData->Load(&file);
    file.close();
  }
  
}
void CMainWidget::SaveData()
{

  int version = DATA_VER;
  QFile file(SETTING_DATA_FNAME);

  if(QFile::exists(SETTING_DATA_FNAME)){
    // file exist
    QFile::remove(SETTING_DATA_FNAME);
  }

  file.open( IO_Raw | IO_ReadWrite );

  // write data version
  if(!file.writeBlock ( (char *)&version , sizeof(int)) ){
    file.close();
  }

  m_pschoolData->Save(&file);
  file.close();
}
boolean CMainWidget::OpenDataFile(QFile *pFile)
{

  int version;

  if(!QFile::exists(SETTING_DATA_FNAME)){
      return false;
  }
  
  pFile->open(IO_ReadOnly);
  if(pFile->readBlock ( (char *)&version , sizeof(int)) == -1){
    pFile->close();
    return false;
  }

  if(version != DATA_VER){
    pFile->close();
    return false;
  }

  return true;

}
boolean CMainWidget::isQVGA()
{

  if( width () > 400 ){
    return true;
  }
  
  return false;
  
}


