/*
  Copyright (C) 2004  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include <qdatetime.h>
#include <qspinbox.h>

#include "StringTable.h"
#include "JyearListDlg.h"
#include "JyearData.h"

CJyearListDlg::CJyearListDlg(QWidget* parent, const char* name, WFlags fl)
  :CJyearListDlgBase( parent, name, fl )
{
  QDate Date = QDate::currentDate();
  
  setCaption( STRING_UTF8(ID_STRING_3004) );
  connect( m_YearSpinBox, SIGNAL(valueChanged(int)), 
	   this, SLOT(changeYear(int)) );

  m_currentYear = Date.year();

  JyearListView->clear ();
  JyearListView->setColumnText( 0,STRING_UTF8(ID_STRING_3000) ); 
  JyearListView->addColumn( STRING_UTF8(ID_STRING_3001) );
  JyearListView->addColumn( STRING_UTF8(ID_STRING_3002) );
  JyearListView->addColumn( STRING_UTF8(ID_STRING_3003) );

  for( int i = 0; i < VIEW_YEAR_COUNT; i++ ){
    m_YearItem[ i ] = new QListViewItem( JyearListView, " ", " ", " ", " ");
    JyearListView->insertItem( m_YearItem[ i ] );
  }

  CJyearData JData;
  
  m_YearSpinBox->setMaxValue( m_currentYear - VIEW_YEAR_COUNT + 1 );
  m_YearSpinBox->setMinValue( JData.GetOldestYear() );

  setYearListItem( m_currentYear - VIEW_YEAR_COUNT + 1 );
  m_YearSpinBox->setValue ( m_currentYear - VIEW_YEAR_COUNT + 1 );
}
CJyearListDlg::~CJyearListDlg()
{
  for( int i = 0; i < VIEW_YEAR_COUNT; i++ ){
    delete m_YearItem[ i ];
  }
}
void CJyearListDlg::setYearListItem( int StartYear )
{
  int year = StartYear;
  CJyearData JYearData;
  CJyearData::T_JAPANESE_YEAR JYear;
  

  for( int i = 0; i < VIEW_YEAR_COUNT; i++ ){

    JYearData.GetJapaneseYear( year, &JYear );
    
    m_YearItem[ i ]->setText( 0, QString::number( year ) );
    m_YearItem[ i ]->setText( 1, JYearData.GetJyearTypeString( JYear.type ) 
			      + QString::number( JYear.jyear ) );
    m_YearItem[ i ]->setText( 2, JYearData.GetEtoString( JYear.eto ) );
    
    int age =  m_currentYear - year;
    if( age >= 0 ){
      m_YearItem[ i ]->setText( 3, QString::number( age ) );
    } else {
      m_YearItem[ i ]->setText( 3, "-" );
    }

    year++;

  }  
}
void CJyearListDlg::changeYear( int year )
{

  setYearListItem( year );
  JyearListView->setSorting( 0 );
  
}
