/*
  Copyright (C) 2004  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef JYEARDATA_H
#define JYEARDATA_H

#include <qstring.h>

class CJyearData
{

 public:
  
  enum ETO_TYPE{
    MOUSE,
    COW,
    TIGER,
    RABBIT,
    DRAGON,
    SNAKE,
    HORSE,
    SHEEP,
    MONKEY,
    BIRD,
    DOG,
    SWINE,
    ANIMAL_TYPE
  };

  enum JYEAR_TYPE{
    HEISEI,
    SYOUWA,
    TAISYOU,
    MEIJI,
    YEAR_TYPE
  };
  
  typedef struct{
    int jyear;
    JYEAR_TYPE type;
    ETO_TYPE eto;
  }T_JAPANESE_YEAR;

 private:
  typedef struct{
    JYEAR_TYPE type;
    int startYear;
  }T_JAPANESE_TYPE;
  
 private:
  T_JAPANESE_TYPE m_startYear[YEAR_TYPE];
  ETO_TYPE m_animalYear[ANIMAL_TYPE];

  void setupAnimalYear();
  ETO_TYPE getAnimalYear( int year );

 public:
  CJyearData();
  void GetJapaneseYear( int year, T_JAPANESE_YEAR* jyear );
  QString GetEtoString( ETO_TYPE eto );
  QString GetJyearTypeString( JYEAR_TYPE type );
  int GetOldestYear();
};

#endif

