/*
  Copyright (C) 2004  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include "JyearData.h"
#include "StringTable.h"

#define MEIJI_START   1868 // ->44
#define TAISYOU_START 1912 // ->14
#define SYOUWA_START  1926 // ->63
#define HEISEI_START  1989 //

CJyearData::CJyearData()
{
  // setup start year table
  m_startYear[ MEIJI ].startYear = MEIJI_START;
  m_startYear[ MEIJI ].type = MEIJI; 
  m_startYear[ TAISYOU ].startYear = TAISYOU_START;
  m_startYear[ TAISYOU ].type = TAISYOU;
  m_startYear[ SYOUWA ].startYear = SYOUWA_START;
  m_startYear[ SYOUWA ].type = SYOUWA;
  m_startYear[ HEISEI ].startYear = HEISEI_START;
  m_startYear[ HEISEI ].type = HEISEI;

  setupAnimalYear();
}

void CJyearData::GetJapaneseYear( int year, T_JAPANESE_YEAR* jyear)
{

  int i;
  ETO_TYPE etype = MOUSE;
  JYEAR_TYPE jtype = MEIJI;
  int yearResult = 0;
  bool findResult;
  
  findResult = false;
  for( i = 0; i < YEAR_TYPE; i++){

    if( m_startYear[ i ].startYear <= year ){
      yearResult = year - m_startYear[ i ].startYear + 1;
      etype = getAnimalYear( year );
      jtype = m_startYear[ i ].type;
      findResult = true;
      break;
    }

  }

  if( findResult ){
    jyear->jyear = yearResult;
    jyear->type = jtype;
    jyear->eto = etype;
  }
  
}

QString CJyearData::GetEtoString( ETO_TYPE eto )
{
  QString str;

  switch( eto ){

  case MOUSE:
    str = STRING_UTF8( ID_STRING_4000 );
    break;
  case COW:
    str = STRING_UTF8( ID_STRING_4001 );
    break;
  case TIGER:
    str = STRING_UTF8( ID_STRING_4002 );
    break;
  case RABBIT:
    str = STRING_UTF8( ID_STRING_4003 );
    break;
  case DRAGON:
    str = STRING_UTF8( ID_STRING_4004 );
    break;
  case SNAKE:
    str = STRING_UTF8( ID_STRING_4005 );
    break;
  case HORSE:
    str = STRING_UTF8( ID_STRING_4006 );
    break;
  case SHEEP:
    str = STRING_UTF8( ID_STRING_4007 );
    break;
  case MONKEY:
    str = STRING_UTF8( ID_STRING_4008 );
    break;
  case BIRD:
    str = STRING_UTF8( ID_STRING_4009 );
    break;
  case DOG:
    str = STRING_UTF8( ID_STRING_4010 );
    break;
  case SWINE:
    str = STRING_UTF8( ID_STRING_4011 );
    break;

  }

  return str;
}
QString CJyearData::GetJyearTypeString( JYEAR_TYPE type )
{
  QString str;

  switch( type ){
  case HEISEI:
    str = STRING_UTF8( ID_STRING_4015 );
    break;
  case SYOUWA:
    str = STRING_UTF8( ID_STRING_4014 );
    break;
  case TAISYOU:
    str = STRING_UTF8( ID_STRING_4013 );
    break;
  case MEIJI:
    str = STRING_UTF8( ID_STRING_4012 );
    break;
  }

  return str;
}
void CJyearData::setupAnimalYear()
{

  m_animalYear[ 0 ] = MONKEY;
  m_animalYear[ 1 ] = BIRD;
  m_animalYear[ 2 ] = DOG;
  m_animalYear[ 3 ] = SWINE;
  m_animalYear[ 4 ] = MOUSE;
  m_animalYear[ 5 ] = COW;
  m_animalYear[ 6 ] = TIGER;
  m_animalYear[ 7 ] = RABBIT;
  m_animalYear[ 8 ] = DRAGON;
  m_animalYear[ 9 ] = SNAKE;
  m_animalYear[ 10 ] = HORSE;
  m_animalYear[ 11 ] = SHEEP;
  
}
CJyearData::ETO_TYPE CJyearData::getAnimalYear( int year )
{
  int index;

  index = year % 12;

  return m_animalYear[ index ];
}
int CJyearData::GetOldestYear()
{
  return m_startYear[ MEIJI ].startYear;
}
