/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include <qpe/qpeapplication.h>
#include <qtimer.h>
#include <qmessagebox.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qkeycode.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "gameWidget.h"
#include "images/data.c"

#define TITLE      0
#define UNDER_PLAY 1
#define GAME_OVER  2

#define FISH_LIST_X 180
#define FISH_LIST_Y 30

#define MAX_DAMAGE 900
CGameWidget::CGameWidget(QWidget *parent, const char *name, WFlags f) :
    QWidget(parent, name, f)
{
    int i;

    m_gamemode = TITLE;
    m_allfish  = FISH_NUM;
    m_freefish = m_allfish;

    /* initialize random number generator */
    srand(::time(0));

    m_timer = new QTimer(this);
    m_pixmap = 0;
    m_bug[0].loadFromData(kingyo8_data_, sizeof (kingyo8_data_));

    /* load image datas */
    m_fishBMP[0].loadFromData(kingyo1_data_, sizeof (kingyo1_data_));
    m_fishBMP[1].loadFromData(kingyo2_data_, sizeof (kingyo2_data_));
    m_fishBMP[2].loadFromData(kingyo3_data_, sizeof (kingyo3_data_));
    m_fishBMP[3].loadFromData(kingyo4_data_, sizeof (kingyo4_data_));
    m_fishBMP[4].loadFromData(kingyo5_data_, sizeof (kingyo5_data_));
    m_fishBMP[5].loadFromData(kingyo6_data_, sizeof (kingyo6_data_));
    m_fishBMP[6].loadFromData(kingyo7_data_, sizeof (kingyo7_data_));
    m_fishBMP[7].loadFromData(kingyo8_data_, sizeof (kingyo8_data_));

    m_titleBMP.loadFromData(title_data_, sizeof (title_data_));

    m_fishListBMP[0].loadFromData(kinlist1_data_, sizeof (kinlist1_data_));
    m_fishListBMP[1].loadFromData(kinlist2_data_, sizeof (kinlist2_data_));

    m_netBMP[0].loadFromData(pointer1_data_, sizeof (pointer1_data_));
    m_netBMP[1].loadFromData(pointer2_data_, sizeof (pointer2_data_));
    m_netBMP[2].loadFromData(pointer3_data_, sizeof (pointer3_data_));
    m_netObj = new Cnet(m_netBMP);

    m_logoBMP.loadFromData(logo2_data_, sizeof (logo2_data_));

    m_text.loadFromData(text_data_, sizeof (text_data_));

    for(i = 0;i < m_allfish;++i){ 	 
      m_pfish[i] = new CFish(SCREENW,SCREENH,48,48,m_fishBMP);
    }

    m_pfireworks[0] = new CFireWorks(SCREENW,SCREENH);
    m_pfireworks[1] = new CFireWorks(SCREENW,SCREENH);
    m_pfireworks[2] = new CFireWorks(SCREENW,SCREENH);

    connect(m_timer, SIGNAL(timeout()), this, SLOT(timerTick()));

    m_timer->start(100);
    //    m_count = 0;
}
CGameWidget::~CGameWidget()
{
    delete m_timer;
    delete m_pixmap;
}


void CGameWidget::timerTick(void)
{
   repaint(false);
}

void CGameWidget::paintEvent(QPaintEvent *event)
{
  paint();
}
void CGameWidget::resizeEvent(QResizeEvent *event)
{
    QWidget::resizeEvent(event);
    if (!m_pixmap || event->size() != event->oldSize()) {
	if (m_pixmap) {
	    delete m_pixmap;
	}
	m_pixmap = new QPixmap(event->size().width(), event->size().height());
    }
}
void CGameWidget::mousePressEvent(QMouseEvent *event)
{

  if(m_gamemode == TITLE){
    /* */
    m_gamemode = UNDER_PLAY;
    m_netObj->init(event->x() - 24,event->y() - 24);
    m_stopwatch.start();

  } else if(m_gamemode == UNDER_PLAY){
    /* no oparation*/

  } else {
    /**/
    setNewGame();
    m_gamemode = TITLE;
  }

}
void CGameWidget::mouseMoveEvent(QMouseEvent *event)
{
	m_netObj->setPos(event->x() - 24 ,event->y() - 24 );
}

void CGameWidget::mouseReleaseEvent(QMouseEvent *event)
{

	if(m_gamemode != UNDER_PLAY) return;

	if(m_netObj->isInWater()){
	  /* net under water */
	  m_netObj->setinwater(false);
	  pickUpWater();
	} else {
	  m_netObj->setinwater(true);
	  intoWater();
	}

}

void CGameWidget::setBackGround(QPainter *paint)
{
  int max_x = width();
  int max_y = height();
  QColor water(160, 192, 255);
  QColor white(255, 255, 255);

  if(m_freefish){
    paint->fillRect(0, 0, max_x, max_y, water);
  } else {
    paint->fillRect(0, 0, max_x, max_y, white);
  }

}
void CGameWidget::setTitle(QPainter *paint)
{
  QColor black(0,0,0);
  paint->drawPixmap(150, 60, m_logoBMP);
  paint->drawPixmap(180, 80, m_titleBMP);
  // paint->drawPixmap(150, 40, m_logoBMP);

  paint->setPen( black );
  paint->drawText( 120, 350, 
		   "(C)1997-2003 TAIGA YONEKURA ALL RIGHTS RESERVED" );

}
void CGameWidget::setNewGame()
{
	int i;

	for(i = 0;i < m_allfish;++i){
		m_pfish[i]->setVisible(true);
	}

	m_freefish = m_allfish;

}
void CGameWidget::clearGame()
{
  m_stopwatch.stop();
  m_gamemode = GAME_OVER;

  m_pfireworks[0]->reset();
  m_pfireworks[1]->reset();
  m_pfireworks[2]->reset();

}
void CGameWidget::paint(void)
{

    QPainter painter_pixmap(m_pixmap);
    QPainter painter_widget(this);
    int i;

    for(i=0;i<FISH_NUM;i++){
      m_pfish[i]->movefast();
    }

    setBackGround(&painter_pixmap);

    switch(m_gamemode){
    
    case TITLE:
      //display title
      for(i=0;i<FISH_NUM;i++){
	m_pfish[i]->draw(&painter_pixmap);
      }
      setTitle(&painter_pixmap);
      break;

    case UNDER_PLAY:

      if(m_netObj->isInWater()){
	//net in water
	m_netObj->draw(&painter_pixmap);
	for(i=0;i<FISH_NUM;i++){
	  m_pfish[i]->draw(&painter_pixmap);
	  if(m_netObj->minusdamage()){
	    //net is broken
	    m_gamemode = GAME_OVER;
	    m_netObj->setinwater(false);
	  }
	}

      } else {

	for(i=0;i<FISH_NUM;i++){
	  m_pfish[i]->draw(&painter_pixmap);
	}
	m_netObj->draw(&painter_pixmap);
      }

      break;

    default:
		
      if(!m_freefish){
	QColor black(0, 0, 0);
	painter_pixmap.fillRect(0, 0, width(), height(), black);	
	m_pfireworks[0]->dispFire(&painter_pixmap);
	m_pfireworks[1]->dispFire(&painter_pixmap);
	m_pfireworks[2]->dispFire(&painter_pixmap);
	drawClearTime(&painter_pixmap);
      } else {

	for(i=0;i<FISH_NUM;i++){
	  m_pfish[i]->draw(&painter_pixmap);
	}
	m_netObj->draw(&painter_pixmap);
	setGameOverMsg(&painter_pixmap);
      }

      break;

    }

    //display damage bar
    m_netObj->drawDamageBar(&painter_pixmap,210,10);

    drawFishList(&painter_pixmap);

    painter_pixmap.flush();
    painter_widget.drawPixmap(0, 0, *m_pixmap);



}
int CGameWidget::getDistance(Cnet *netObj,CFish *fish)
{
  return (int)sqrt(
		   pow((double)(netObj->getPosX()+35-fish->getPosX()-24),2)
		   +pow((double)(netObj->getPosY()+35-fish->getPosY()-24),2));

}
void CGameWidget::intoWater(void)
{

  int i;

  for(i = 0;i < m_allfish;++i){

    if(m_pfish[i]->getVisible()) {
      if(getDistance(m_netObj,m_pfish[i]) < 59) {
	m_netObj->setdamage(0);
	m_gamemode = GAME_OVER;
	break;
      }
    }

  }

}
void CGameWidget::pickUpWater(void)
{
  int i,d;

  for(i = 0;i < m_allfish;++i){

    if(m_pfish[i]->getVisible()){
      d = getDistance(m_netObj,m_pfish[i]);
      
      if(d  >= 35 && d < 59){
	//	m_netObj->setdamage(0);
	m_netObj->minusdamage(MAX_DAMAGE);
	if(m_netObj->getdamage() < 1){
	  m_gamemode = GAME_OVER;
	  break;
	}
      }

      if(d < 35) {
	m_freefish--;
	m_pfish[i]->setVisible(false);
	if(m_freefish < 1) clearGame();
      }
    }
  }

}
void CGameWidget::drawPixmapText(QPainter &painter, int x, int y, int wrap, const char *str)
{
    int xstart = x;

    while (*str != '\0') {
	if ((*str >= '!') && (*str <= 'Z')) {
	    painter.drawPixmap(x, y, m_text, (*str - '!') * 6, 0, 6, 9);
	    x = x + 7;
	} else if (*str == ' ') {
	    x = x + 7;
	    if (wrap > xstart) {
		int nchars = 0;
		const char *ptr;
		for (ptr = str + 1; *ptr >= '!' && *ptr <= 'Z'; ptr++) {
		    nchars++;
		}
		if (x + (nchars * 7) > wrap) {
		    x = xstart;
		    y = y + 10;
		}
	    }
	} else {
	    x = xstart;
	    y = y + 10;
	}
	str++;
    }
}
void CGameWidget::setGameOverMsg(QPainter *paint)
{
  QColor black(0,0,0);
  QString str = "You caught ";
  QString numStr;

  numStr.setNum(FISH_NUM - m_freefish, 10);
  str += numStr +" fishes, Let's try again !!";
  paint->setPen( black );
  paint->drawText( 150, 350, str);

}

void CGameWidget::drawClearTime(QPainter *paint)
{
  QColor white(255,255,255);
  QString str = "Clear Time is ";
  QString numStr;
  int h,m,s;

  m_stopwatch.getClearTime(&h, &m, &s);
  numStr.setNum(h,10);
  str += numStr + " h : ";
  numStr.setNum(m,10);
  str += numStr + " m : ";
  numStr.setNum(s,10);
  str += numStr + " s";

  paint->setPen( white );
  paint->drawText( 200, 350, str);
  paint->drawText( 250, 380, "CONGRATURATION !!");

}
void CGameWidget::drawFishList(QPainter *paint)
{
  int catchedfish = m_allfish - m_freefish;
  int i;
  int x;

  for(i = 0, x = FISH_LIST_X; i < m_allfish; i++ ,x+=18){
    
    if(catchedfish){
      /* draw fihs */
      catchedfish--;
      paint->drawPixmap(x, FISH_LIST_Y, m_fishListBMP[0]);
    } else {
      /* draw empty fish */
      paint->drawPixmap(x, FISH_LIST_Y, m_fishListBMP[1]);
    }
  }
  
  
}
