/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef CFISH_H
#define CFISH_H

#include "sprite.h"



class CFish : public CSprite  
{
public:
	CFish(int,int,int,int,PIXMAP *);
	void moveslow();
	void movefast();
	void set_real_y(void);
	void draw(PAINTER* painter);
	void CFishInit(int,int,int,int,PIXMAP *);
	virtual ~CFish();

private:
	void set_real_x(void );
	void set_real_x_slow(void );
	void set_real_y_slow();
	void randset();
	void setWay(int);
	int makerad();
	bool cheak_y(int y);
	bool cheak_x(int x);
	int x_size,y_size;    // character size
	int SCREENH,SCREENW;  // screen size
	double rad_table[24]; // rad table
	double rad;	      // selected rad table
	double speed;	      // speed
	int    way;	      // way
	int x0,y0;	      // inital positon
	double real_x,real_y; // internal position
	PIXMAP *fishBMP;      // fish BITMAP



};

#endif 
