/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include <stdlib.h>
#include <math.h>

#include "fireworks.h"

#define NONE  0
#define GOUP  1
#define FIRE  2
#define CHANGETIME  5
#define LIFE  35


CFireWorks::CFireWorks()
{

}

CFireWorks::~CFireWorks()
{

}

CFireWorks::CFireWorks(int wth, int hth)
{
	width  = wth;
	heigth = hth;
		
	posTable1[0][0] = CHANGETIME;
	posTable1[0][1] = 10;
		
	posTable2[0][0] = CHANGETIME;
	posTable2[0][1] = 15;
		
	posTable3[0][0] = CHANGETIME;
	posTable3[0][1] = 20;
		
	posTable4[0][0] = CHANGETIME;
	posTable4[0][1] = 30;
		
	color1.setRgb(255,255,255);
	color2.setRgb(255,255,255);
	color3.setRgb(255,255,255);
	color4.setRgb(255,255,255);
		
	status = NONE;
		
	makePosTable(20,posTable1[0][1],&posTable1[0][0]);
	makePosTable(40,posTable2[0][1],&posTable2[0][0]);
	makePosTable(60,posTable3[0][1],&posTable3[0][0]);
	makePosTable(80,posTable4[0][1],&posTable4[0][0]);
}

void CFireWorks::makePosTable(int r, int divide, int *array)
{
	double inc; //incremental size
	double rad;
	double PI = 3.14;
	int i;
		
	inc = (2 * PI) / (double)divide;
		
	for(i=1,rad=0;(i< divide + 1) && (rad < 2 * PI);i++,rad = rad + inc){
		array[i*2+0] = (int)((double)r * cos(rad));
		array[i*2+1] = (int)((double)r * sin(rad));
	}
}

void CFireWorks::goUp()
{
	status   = GOUP;
	start_x  = rand() % (width - 100) + 100;//(100 ` width-100);
	start_y  = heigth;
	center_y = rand() % 101 + 100;  //(100-200);
		
	posx = start_x;
	posy = start_y;
	center_x = start_x;
	life = LIFE;
}

void CFireWorks::dispFire(QPainter *paint)
{
  QColor white(255,255,255);

	switch(status){

		case NONE:
			if((rand() % 36) == 10) goUp();
			break;
		
		case GOUP:
			paint->fillRect(posx,posy,4,4, white );
			posy -= 10;
			
			if(posy < center_y){
				status = FIRE;
			}
			break;
			
		case FIRE:
			color1 = dispFireFlower(posTable1[0][1],paint,
						color1,&posTable1[0][0]);
			color2 = dispFireFlower(posTable2[0][1],paint,
						color2,&posTable2[0][0]);
			color3 = dispFireFlower(posTable3[0][1],paint,
						color3,&posTable3[0][0]);
			color4 = dispFireFlower(posTable4[0][1],paint,
						color4,&posTable4[0][0]);

			if(life != 0){
				life--;
			} else {
				status = NONE;
			}
			break;
	}
}

QColor CFireWorks::dispFireFlower(int num, QPainter *paint, QColor col, int *array)
{
  QColor color = col;

	int i;
	int red,blue,green;
		
	array[0*2+0]--;
		
	if(array[0*2+0] == 0){
		array[0*2+0] = CHANGETIME;
			
		if((rand() % 3) == 1){
			red   = rand() % 206 + 50;
			blue  = rand() % 206 + 50;
			green = rand() % 206 + 50;
			color.setRgb(red,green,blue);
		}
	}
		
	for(i=1;i<num+1;i++){
		paint->fillRect(array[i*2+0] + center_x,array[i*2+1] + center_y,3,3,color );
	}
		
	return color;
}

void CFireWorks::reset()
{
	status = NONE;
}
