/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.wiki.mailet;

import cx.ath.kgslab.wiki.service.stub.PageContent;
import cx.ath.kgslab.wiki.service.stub.WikiService;
import cx.ath.kgslab.wiki.service.stub.WikiServiceServiceLocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;
import javax.xml.rpc.ServiceException;
import org.apache.mailet.GenericMailet;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public class WikiMailet
extends GenericMailet {
    private static final String SERVICE_PATH = "services/wiki";
    private static final String APPEND = "[APPEND]";
    private static final String MODIFY = "[MODIFY]";
    private static final String GET = "[GET]";
    private URL jajawikiUri = null;
    private URL serviceUri = null;
    private WikiServiceServiceLocator locater = null;
    private Properties props = null;
    private InternetAddress serviceAddress = null;

    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        Object content = null;
        try {
            content = message.getContent();
        }
        catch (IOException e1) {
            this.log(e1.getMessage());
            throw new MessagingException(e1.getMessage(), (Exception)e1);
        }
        String subject = message.getSubject();
        MailAddress sender = mail.getSender();
        try {
            if (subject.startsWith(APPEND)) {
                this.append(subject, sender, content);
            } else if (subject.startsWith(GET)) {
                this.get(subject, sender, content);
            } else {
                MimeMessage mimeMessage = this.createMessage(sender, "error:" + subject, "\u51e6\u7406\u3067\u304d\u306a\u3044\u30e1\u30fc\u30eb\u3067\u3059\u3002");
                this.getMailetContext().sendMail(mimeMessage);
            }
        }
        catch (ParseException e) {
            this.log(e.getMessage());
            throw new MessagingException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ServiceException e) {
            this.log(e.getMessage());
            throw new MessagingException(e.getMessage(), (Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            this.log(e.getMessage());
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
        catch (RemoteException e) {
            String errorMessage = e.getMessage();
            this.log(errorMessage);
            if ("cx.ath.kgslab.wiki.service.PageLockedException".equals(errorMessage)) {
                errorMessage = "\u30da\u30fc\u30b8\u304c\u30ed\u30c3\u30af\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
            } else if ("cx.ath.kgslab.wiki.service.PageModifiedException".equals(errorMessage)) {
                errorMessage = "\u30da\u30fc\u30b8\u304c\u7de8\u96c6\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u30da\u30fc\u30b8\u3092\u53d6\u5f97\u3057\u306a\u304a\u3057\u3066\u3001\u7de8\u96c6\u3057\u306a\u304a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            }
            MimeMessage mimeMessage = this.createMessage(sender, "error:" + subject, errorMessage);
            this.getMailetContext().sendMail(mimeMessage);
        }
        catch (IOException e) {
            this.log(e.getMessage());
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
        mail.setState("ghost");
    }

    private void get(String subject, MailAddress from, Object obj) throws ParseException, MessagingException, MalformedURLException, ServiceException, RemoteException {
        String title = subject.substring(GET.length()).trim();
        WikiService service = this.getService();
        PageContent page = service.getPage(title);
        String content = page.getContent();
        MimeMessage mimeMessage = this.createMessage(from, String.valueOf(title) + " " + page.getLastModified(), content);
        this.getMailetContext().sendMail(mimeMessage);
    }

    private void append(String subject, MailAddress from, Object content) throws IOException, MessagingException, MalformedURLException, ServiceException {
        String title = subject.substring(APPEND.length()).trim();
        int idx = title.indexOf(32);
        if (idx > 0) {
            title = title.substring(0, idx).trim();
        }
        String text = this.parseMultipart(content, title);
        WikiService service = this.getService();
        service.appendPage(title, text);
        PageContent page = service.getPage(title);
        MimeMessage mimeMessage = this.createMessage(from, "modified:" + title + " " + page.getLastModified(), "\u30da\u30fc\u30b8\u5185\u5bb9\u306e\u8ffd\u52a0\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002\n\u4ee5\u4e0b\u306e\u5185\u5bb9\u306b\u7de8\u96c6\u3055\u308c\u307e\u3057\u305f\u3002\n----\n" + page.getContent());
        this.getMailetContext().sendMail(mimeMessage);
    }

    private String parseMultipart(Object content, String title) throws IOException, MessagingException {
        String result = null;
        if (content instanceof Multipart) {
            Multipart part = (Multipart)content;
            int cnt = part.getCount();
            int i = 0;
            while (i < cnt) {
                BodyPart body = part.getBodyPart(i);
                Object bodyContent = body.getContent();
                if (bodyContent instanceof String) {
                    result = bodyContent.toString();
                } else {
                    InputStream is = body.getInputStream();
                    this.upload(body.getFileName(), is, title);
                }
                ++i;
            }
        } else {
            result = content.toString();
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public void upload(String fileName, InputStream is, String page) throws UnsupportedEncodingException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 140->143)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private WikiService getService() throws ServiceException {
        if (this.serviceUri != null) {
            return this.locater.getwiki(this.serviceUri);
        }
        return this.locater.getwiki();
    }

    public void init() throws MessagingException {
        String uri = this.trim(this.getInitParameter("wikiUri"));
        this.locater = new WikiServiceServiceLocator();
        try {
            if (uri != null && uri.length() > 0) {
                this.jajawikiUri = new URL(uri);
                this.serviceUri = new URL(this.jajawikiUri, SERVICE_PATH);
                this.log(this.jajawikiUri.toExternalForm());
                this.log(this.serviceUri.toExternalForm());
            } else {
                uri = this.locater.getwikiAddress();
                uri = uri.substring(0, uri.length() - SERVICE_PATH.length());
                this.jajawikiUri = new URL(uri);
                this.log(this.jajawikiUri.toExternalForm());
            }
        }
        catch (MalformedURLException e) {
            this.log("Error on init wikiUri.");
            this.log(e.getMessage());
        }
        String smtpHost = this.trim(this.getInitParameter("smtpHost"));
        this.props = System.getProperties();
        if (smtpHost != null && smtpHost.length() > 0) {
            this.props.put("mail.smtp.host", smtpHost);
        } else {
            this.props.put("mail.smtp.host", "localhost");
        }
        String addr = this.trim(this.getInitParameter("address"));
        if (addr != null && addr.length() > 0) {
            this.serviceAddress = new InternetAddress(addr);
        }
    }

    private String trim(String src) {
        if (src != null) {
            src = src.trim();
        }
        return src;
    }

    private MimeMessage createMessage(MailAddress to, String subject, String content) throws MessagingException {
        Session session = Session.getDefaultInstance((Properties)this.props, null);
        MimeMessage mimeMessage = new MimeMessage(session);
        if (this.serviceAddress == null) {
            this.serviceAddress = this.getMailetContext().getPostmaster().toInternetAddress();
        }
        mimeMessage.setFrom((Address)this.serviceAddress);
        mimeMessage.setRecipients(Message.RecipientType.TO, new Address[]{to.toInternetAddress()});
        mimeMessage.setSubject(subject, "iso-2022-jp");
        mimeMessage.setText(content, "iso-2022-jp");
        mimeMessage.setHeader("Content-Type", "text/plain");
        mimeMessage.setSentDate(new Date());
        return mimeMessage;
    }

    public String getMailetInfo() {
        return "Wiki Mailet.";
    }
}

