/*======================================================================
----------------------------------------------------------------------*/
/**
 * @file		iutest_param_test_tests.c
 * @brief		iutest parameter test test
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2013, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
/*----------------------------------------------------------------------
======================================================================*/

/* include ===========================================================*/
#include "../include/iutest_c.h"

IUTEST_C_WORKSPACE();

#if IUTEST_C_HAS_PARAM_TEST

IUTEST_INSTANTIATE_TEST_CASE_P(int, A, TestP, iuValues, 0, 1, 2, 3 );
IUTEST_INSTANTIATE_TEST_CASE_P(int, B, TestP, iuRange, 0, 11);
IUTEST_INSTANTIATE_TEST_CASE_P(int, C, TestP, iuStepRange, 0, 11, 2);

#if defined(__GNUC__)
IUTEST_INSTANTIATE_TEST_CASE_P(int, D, TestP, iuRange, 0, 11, 2);
#endif

IUTEST_P(int, TestP, Test)
{
	const int x = param;
	const int kMax = 11;
	IUTEST_ASSERT_LT(x, kMax);
	iuConsole_Output("%d\n", x);
}

IUTEST_P(int, TestP, Test2)
{
	const int x = param;
	const int kMax = 11;
	IUTEST_ASSERT_LT(x, kMax);
	iuConsole_Output("%d\n", x);
}

#if IUTEST_C_HAS_COMBINE

typedef IUTEST_P_TYPE((int, char, unsigned int)) TestCombineParamType;
IUTEST_INSTANTIATE_TEST_CASE_P((int, char, unsigned int), A
							   , TestCombine, iuCombine
							   , (iuRange, ( 0, 2)), (iuStepRange, (100, 110, 2)), (iuValues, (0, 4, 2)) );

IUTEST_INSTANTIATE_TEST_CASE_P((int, char, unsigned int), B
							   , TestCombine, iuCombine
							   , (iuRange, (-2, 0)), (iuStepRange, (200, 210, 2)), (iuValues, (2, 5, 9)) );

IUTEST_P(TestCombineParamType, TestCombine, Test)
{
	const int x0 = param.value0;
	const char x1 = param.value1;
	const unsigned int x2 = param.value2;
	iuConsole_Output("%d %d %d\n", x0, x1, x2);
}

IUTEST_P(TestCombineParamType, TestCombine, Test2)
{
	const int x0 = param.value0;
	const char x1 = param.value1;
	const unsigned int x2 = param.value2;
	iuConsole_Output("%d %d %d\n", x0, x1, x2);
}

#endif

#endif

#ifdef UNICODE
int wmain(int argc, wchar_t* argv[])
#else
int main(int argc, char* argv[])
#endif
{
	IUTEST_INIT(&argc, argv);
	{
		int ret = IUTEST_RUN_ALL_TESTS();
		if( ret != 0 ) return 1;
	}
#if IUTEST_C_HAS_PARAM_TEST
	{
		int nTestCaseCount = (4+11+6);
#if IUTEST_C_HAS_COMBINE
		nTestCaseCount += 2*5*3 * 2;
#endif
#if defined(__GNUC__)
		nTestCaseCount += 6;
#endif
		IUTEST_ASSERT( iuUnitTest_GetTotalTestCaseCount(iuUnitTest_GetInstance()) == nTestCaseCount );
		IUTEST_ASSERT( iuUnitTest_GetTotalTestCount(iuUnitTest_GetInstance()) == nTestCaseCount*2 );
	}
#endif
	
	printf("*** Successful ***\n");
	return 0;
}
