/*======================================================================
----------------------------------------------------------------------*/
/**
 * @file		iutest_assertion_c.h
 * @brief		iris unit test assertion ` t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012-2013, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
/*----------------------------------------------------------------------
======================================================================*/
#ifndef INCG_IRIS_iutest_assertion_C_H_E6AF3476_DA81_46f7_A961_ACCEF7363932_
#define INCG_IRIS_iutest_assertion_C_H_E6AF3476_DA81_46f7_A961_ACCEF7363932_

/* include ===========================================================*/
#include "iutest_info_c.h"
#include "iutest_printer_c.h"

IUTEST_EXTERN_C_BEGIN()

/* struct ============================================================*/
/**
 * @brief	eXǧ
*/
typedef struct iuAssertionResult_t
{
	iuBOOL		result;		/*!<  */
	const char*	message;	/*!< bZ[W */
	char*		buf;		/*!< obt@ */
} iuAssertionResult;

/* define ============================================================*/
/** @private */
#define iuAssertionResult_ctor()	{ FALSE, NULL, NULL }

/* function ==========================================================*/
#if IUTEST_C_HAS_LIB
/**
 * @brief	 AssertionResult ̎擾
*/
IUTEST_ATTRIBUTE_UNUSED_ iuAssertionResult iuAssertionSuccess(void);
/**
 * @brief	s AssertionResult ̎擾
*/
IUTEST_ATTRIBUTE_UNUSED_ iuAssertionResult iuAssertionFailure(void);

/**
 * @brief	bZ[W񍐊֐
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuAssertionHelper_Report(const char* file, int line, const char* message, eTestResultType type);

/**
 * @brief	bZ[W̍쐬
*/
IUTEST_ATTRIBUTE_UNUSED_ iuAssertionResult iuAssertionFailureMessage(const char* message);

/**
 * @brief	bZ[W̍쐬
*/
IUTEST_ATTRIBUTE_UNUSED_ iuAssertionResult iuAssertionFailureMessage2(const char* message
													, const void* val1, size_t size1, const char* msg1
													, const void* val2, size_t size2, const char* msg2);

/**
 * @brief	bZ[W̍쐬
*/
IUTEST_ATTRIBUTE_UNUSED_ iuAssertionResult iuAssertionStringFailureMessage(const char* message, const char* val1, const char* msg1
																				  , const char* val2, const char* msg2);

#if IUTEST_C_HAS_LIBC

/**
 * @brief	bZ[W̍쐬
*/
IUTEST_ATTRIBUTE_UNUSED_ iuAssertionResult iuAssertionFailureFormatMessageV(const char* fmt, va_list va);

/**
 * @brief	bZ[W̍쐬
*/
IUTEST_ATTRIBUTE_UNUSED_ iuAssertionResult iuAssertionFailureFormatMessage(const char* fmt, ...);

#endif

#endif

/**
 * @brief	BOOL reXg̎sbZ[W̍쐬
*/
#define iuTestAssertion_GetBooleanAssertionFailureMessage(expression, actual, expected)	\
	"error: Value of: " expression "\n   Actual: " #actual "\n Expected: " #expected

/**
 * @biref	reXg
 * @{
*/

/**
 * @private
 * @{
*/
/* actual  rvalue gpłȂȂ */
#define iuTestAssertion_EqFailureMessageShowActual(expected_str, actual_str, expected, actual)	\
	iuAssertionFailureMessage2("error: Value of : " actual_str "\n  Actual: "			\
	, &actual, sizeof(actual), "\nExpected: " expected_str , NULL, 0u, NULL)

/* ǂ rvalue gpłȂȂ */
#define iuTestAssertion_EqFailureMessageShowWhichIs(expected_str, actual_str, expected, actual)	\
	iuAssertionFailureMessage2("error: Value of : " actual_str "\n  Actual: "			\
	, &actual, sizeof(actual), "\nExpected: " expected_str "\nWhich is: ", &expected, sizeof(expected), NULL)

/* ǂ rvalue gpł邪A\Ȃ */
#define iuTestAssertion_EqFailureMessageShowOnlyExpr(expected_str, actual_str, expected, actual)	\
	iuAssertionFailureMessage("error: Expected: " expected_str " == " actual_str)


#ifndef iuTestAssertion_EqFailureMessage
#  define iuTestAssertion_EqFailureMessage		iuTestAssertion_EqFailureMessageShowActual
#endif

#define iuTestAssertion_StrEqFailureMessage(expected_str, actual_str, expected, actual)		\
	iuAssertionStringFailureMessage("error: Value of : " actual_str "\n  Actual: \""		\
	, actual, "\"\nExpected: " expected_str "\nWhich is: \"", expected, "\"")

#define iuTestAssertion_StrCaseEqFailureMessage(expected_str, actual_str, expected, actual)	\
	iuAssertionStringFailureMessage("error: Value of : " actual_str "\n  Actual: \""		\
	, actual, "\"\nExpected: " expected_str "\nWhich is: \"", expected, "\" (ignoring case)")

#define iuTestAssertion_StrNeFailureMessage(val1_str, val2_str, val1, val2)					\
	iuAssertionStringFailureMessage("error: Expected : " val1_str " != " val2_str "\n  Actual: \""	\
	, val1, "\" vs \"" , val2, "\"")

#define iuTestAssertion_StrCaseNeFailureMessage(val1_str, val2_str, val1, val2)			\
	iuAssertionStringFailureMessage("error: Expected : " val1_str " != " val2_str " (ignoring case)\n  Actual: \""	\
	, val1, "\" vs \"" , val2, "\"")


/* val1  lvalue only*/
#define iuTestAssertion_VsFailureMessageShowActual1(expression_str, val1, val2)			\
	iuAssertionFailureMessage2("error: Expected of : " expression_str "\n  Actual: "	\
	, &val1, sizeof(val1), " vs ", #val2, 0, NULL)

/* val2  lvalue only*/
#define iuTestAssertion_VsFailureMessageShowActual2(expression_str, val1, val2)			\
	iuAssertionFailureMessage2("error: Expected of : " expression_str "\n  Actual: "	\
	, NULL, 0, #val1 " vs ", &val2, sizeof(val2), NULL)

/* ǂ rvalue gpłȂȂ */
#define iuTestAssertion_VsFailureMessageShowActual12(expression_str, val1, val2)			\
	iuAssertionFailureMessage2("error: Expected of : " expression_str "\n  Actual: "	\
	, &val1, sizeof(val1), " vs ", &val2, sizeof(val2), NULL)

/* ǂ rvalue gpł邪A\Ȃ */
#define iuTestAssertion_VsFailureMessageShowOnlyExpr(expression_str, val1, val2)		\
	iuAssertionFailureMessage("error: Expected: " expression_str ) )

#ifndef iuTestAssertion_VsFailureMessage
#  define iuTestAssertion_VsFailureMessage		iuTestAssertion_VsFailureMessageShowActual12
#endif

/**
 * @}
*/

/** NULL reXg */
#define iuTestAssertion_CompHelperNull(expression, actual)	\
	(((actual) == NULL) ? iuAssertionSuccess() :			\
	iuAssertionFailureMessage("error: Expected: NULL == " expression) )

/** NOT NULL eXg */
#define iuTestAssertion_CompHelperNotNull(expression, actual)	\
	(((actual) != NULL) ? iuAssertionSuccess() :			\
	iuAssertionFailureMessage("error: Expected: NULL != " expression) )

/** == eXg */
#define iuTestAssertion_CompHelperEQ(expected_str, actual_str, expected, actual)	\
	((expected == actual) ? iuAssertionSuccess() :									\
	 iuTestAssertion_EqFailureMessage(expected_str, actual_str, expected, actual))

/** == eXg */
#define iuTestAssertion_CompHelperLValueEQ(expected_str, actual_str, expected, actual)	\
	((expected == actual) ? iuAssertionSuccess() :									\
	iuTestAssertion_EqFailureMessageShowWhichIs(expected_str, actual_str, expected, actual))

/** == eXg */
#define iuTestAssertion_CompHelperRValueEQ(expected_str, actual_str, expected, actual)	\
	((expected == actual) ? iuAssertionSuccess() :									\
	 iuTestAssertion_EqFailureMessageShowOnlyExpr(expected_str, actual_str, expected, actual))

/** AhXreXg */
#define iuTestAssertion_CompHelperSame(expected_str, actual_str, expected, actual)	\
	((&expected == &actual) ? iuAssertionSuccess() :									\
	iuTestAssertion_EqFailureMessage(expected_str, actual_str, expected, actual))

/** != eXg */
#define iuTestAssertion_CompHelperNE(expected_str, actual_str, expected, actual)	\
	((expected != actual) ? iuAssertionSuccess() :									\
	iuTestAssertion_VsFailureMessage(expected_str " != " actual_str, expected, actual) )

/** < eXg */
#define iuTestAssertion_CompHelperLT(expr1, expr2, val1, val2)				\
	((val1 < val2) ? iuAssertionSuccess() :									\
	iuTestAssertion_VsFailureMessage(expr1 " < " expr2, val1, val2) )

/** <= eXg */
#define iuTestAssertion_CompHelperLE(expr1, expr2, val1, val2)				\
	((val1 <= val2) ? iuAssertionSuccess() :								\
	iuTestAssertion_VsFailureMessage(expr1 " <= " expr2, val1, val2) )

/** > eXg */
#define iuTestAssertion_CompHelperGT(expr1, expr2, val1, val2)				\
	((val1 > val2) ? iuAssertionSuccess() :									\
	iuTestAssertion_VsFailureMessage(expr1 " > " expr2, val1, val2) )

/** >= eXg */
#define iuTestAssertion_CompHelperGE(expr1, expr2, val1, val2)				\
	((val1 >= val2) ? iuAssertionSuccess() :								\
	iuTestAssertion_VsFailureMessage(expr1 " >= " expr2, val1, val2) )

#if IUTEST_C_HAS_FLOATINGPOINT
#include <math.h>

/** float reXg */
#define iuTestAssertion_CompHelperFloatEQ(expr1, expr2, val1, val2)			\
	(iuAlmostFloatEquals(val1, val2) ? iuAssertionSuccess() :				\
	iuTestAssertion_EqFailureMessage(expr1, expr2, val1, val2))
/** dobule reXg */
#define iuTestAssertion_CompHelperDoubleEQ(expr1, expr2, val1, val2)		\
	(iuAlmostDoubleEquals(val1, val2) ? iuAssertionSuccess() :				\
	iuTestAssertion_EqFailureMessage(expr1, expr2, val1, val2))

/** ߎleXg */
#define iuTestAssertion_CompHelperNear(expr1, expr2, abs_str, val1, val2, abs_val)	\
	(fabs(val1 - val2) < abs_val ? iuAssertionSuccess() :							\
	iuAssertionFailureMessage2("error: Expected of : abs(" expr1 " - " expr2 ") < " abs_str "\n  Actual: abs("	\
	, &val1, sizeof(val1), " - ", &val2, sizeof(val2), ")"))

#endif

/** reXg */
#define iuTestAssertion_CompHelperSTREQ(expr1, expr2, val1, val2)			\
	(iuString_IsStringEqual(val1, val2) ? iuAssertionSuccess() :			\
	iuTestAssertion_StrEqFailureMessage(expr1, expr2, val1, val2) )

/** sveXg */
#define iuTestAssertion_CompHelperSTRNE(expr1, expr2, val1, val2)			\
	((!iuString_IsStringEqual(val1, val2)) ? iuAssertionSuccess() :			\
	iuTestAssertion_StrNeFailureMessage(expr1, expr2, val1, val2) )

/** 召ʂȂreXg */
#define iuTestAssertion_CompHelperSTRCASEEQ(expr1, expr2, val1, val2)		\
	(iuString_IsStringCaseEqual(val1, val2) ? iuAssertionSuccess() :		\
	iuTestAssertion_StrCaseEqFailureMessage(expr1, expr2, val1, val2) )

/** 召ʂȂsveXg */
#define iuTestAssertion_CompHelperSTRCASENE(expr1, expr2, val1, val2)		\
	((!iuString_IsStringCaseEqual(val1, val2)) ? iuAssertionSuccess() :		\
	iuTestAssertion_StrCaseNeFailureMessage(expr1, expr2, val1, val2) )

#if defined(IUTEST_OS_WINDOWS)

#if IUTEST_C_HAS_LIB

IUTEST_ATTRIBUTE_UNUSED_ iuAssertionResult iuAssertionFailureHResultMessage(const char* fmt, HRESULT hr);

#endif

/** HRESULT eXg */
#define iuTestAssertion_IsHRESULTSuccess(expr, hr)							\
	( SUCCEEDED(hr) ? iuAssertionSuccess() :								\
	iuAssertionFailureHResultMessage( "error: Expected: SUCCEEDED(" expr	\
		")\n  Actual: "	 #hr ": %s", hr ) )

/** HRESULT seXg */
#define iuTestAssertion_IsHRESULTFailure(expr, hr)							\
	( FAILED(hr) ? iuAssertionSuccess() :									\
	iuAssertionFailureMessage( "error: Expected: FAILED(" expr	\
		")\n  Actual: "	 #hr ) )

/**
 * @}
*/

#endif

#if !IUTEST_C_HAS_LIB
#  include "impl/iutest_assertion_c.inl"
#endif

IUTEST_EXTERN_C_END()

#endif
