<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 
 * @author  
 * @version 
 */
define('ROOT_DIR',               dirname(dirname(__FILE__)));
define('APPLICATION_DIR',        ROOT_DIR . '/' . 'application');
define('APPLICATION_RUNNING_MODE', 'production');

/** basic const settings **/
define('CONTROLLERS_DIR_NAME', 'controllers');
define('MODELS_DIR_NAME',      'models');
define('VIEWS_DIR_NAME',       'views');
define('CONFIGS_DIR_NAME',     'configs');
define('LANGUAGES_DIR_NAME',   'languages');
define('FORMS_DIR_NAME',       'forms');
define('FILTERS_DIR_NAME',     'filters');
define('VALIDATORS_DIR_NAME',  'validators');
define('HELPERS_DIR_NAME',     'helpers');
define('SCRIPTS_DIR_NAME',     'scripts');
define('LAYOUTS_DIR_NAME',     'layout');
define('DAOS_DIR_NAME',        'daos');

/** default(inqman) module settings **/
define('MOD_INQMAN_ROOT_DIR',        APPLICATION_DIR .            '/' . 'inqman');
define('MOD_INQMAN_CONTROLLERS_DIR', MOD_INQMAN_ROOT_DIR .        '/' . CONTROLLERS_DIR_NAME);
define('MOD_INQMAN_MODELS_DIR',      MOD_INQMAN_ROOT_DIR .        '/' . MODELS_DIR_NAME);
define('MOD_INQMAN_VIEWS_DIR',       MOD_INQMAN_ROOT_DIR .        '/' . VIEWS_DIR_NAME);
define('MOD_INQMAN_FORMS_DIR',       MOD_INQMAN_CONTROLLERS_DIR . '/' . FORMS_DIR_NAME);
define('MOD_INQMAN_VALIDATORS_DIR',  MOD_INQMAN_CONTROLLERS_DIR . '/' . VALIDATORS_DIR_NAME);
define('MOD_INQMAN_CONFIGS_DIR',     MOD_INQMAN_ROOT_DIR.         '/' . CONFIGS_DIR_NAME);
define('MOD_INQMAN_LANGUAGES_DIR',   MOD_INQMAN_ROOT_DIR.         '/' . LANGUAGES_DIR_NAME);

/** ENVIRONMENT VARIABLES **/
define('ENV_SERVER_LOCALE', 'ja_JP.UTF-8');
define('ENV_INTERNAL_ENCODING', 'UTF-8');

set_include_path('.' . PATH_SEPARATOR . '../library' . PATH_SEPARATOR . get_include_path());

require_once 'Zend/Registry.php';
require_once 'Zend/Config/Ini.php';
require_once 'Zend/Layout.php';
require_once 'Zend/Translate.php';
require_once 'Zend/Controller/Front.php';
require_once 'Zend/Controller/Plugin/ErrorHandler.php';
require_once 'Zend/Controller/Router/Route/Static.php';
require_once 'Zend/Controller/Router/Route/Regex.php';
require_once 'Zend/Controller/Action.php';
require_once 'Zend/Form.php';
require_once 'Zend/Filter/Input.php';
require_once 'Zend/Filter/StripTags.php';
require_once 'Zend/Acl.php';
require_once 'Zend/Acl/Role.php';
require_once 'Zend/Acl/Resource.php';
require_once 'Zend/Auth.php';
require_once 'Zend/Auth/Adapter/DbTable.php';
require_once 'Zend/Mail.php';
require_once 'Zend/Mail/Transport/Smtp.php';
require_once 'Zend/Mail/Protocol/Exception.php';

require_once 'Bullhead/Controller/Action.php';

require_once MOD_INQMAN_CONTROLLERS_DIR . '/AbstractController.php';

require_once MOD_INQMAN_MODELS_DIR . '/AbstractDao.php';
require_once MOD_INQMAN_MODELS_DIR . '/AclModel.php';
require_once MOD_INQMAN_MODELS_DIR . '/EventModel.php';
require_once MOD_INQMAN_MODELS_DIR . '/InquiryModel.php';
require_once MOD_INQMAN_MODELS_DIR . '/MailtemplateModel.php';
require_once MOD_INQMAN_MODELS_DIR . '/ReplyModel.php';
require_once MOD_INQMAN_MODELS_DIR . '/ServiceModel.php';
require_once MOD_INQMAN_MODELS_DIR . '/UserModel.php';
require_once MOD_INQMAN_MODELS_DIR . '/MaildumpModel.php';
require_once MOD_INQMAN_MODELS_DIR . '/PopServer.php';
require_once MOD_INQMAN_MODELS_DIR . '/MailSender.php';

require_once MOD_INQMAN_FORMS_DIR . '/AbstractForm.php';
require_once MOD_INQMAN_FORMS_DIR . '/AccountForm.php';
require_once MOD_INQMAN_FORMS_DIR . '/ServiceForm.php';
require_once MOD_INQMAN_FORMS_DIR . '/UserForm.php'; 
require_once MOD_INQMAN_FORMS_DIR . '/InquiryForm.php';
require_once MOD_INQMAN_FORMS_DIR . '/ApproveForm.php';
require_once MOD_INQMAN_FORMS_DIR . '/ReplyForm.php';
require_once MOD_INQMAN_FORMS_DIR . '/CommentForm.php'; 
require_once MOD_INQMAN_FORMS_DIR . '/MailtemplateForm.php';

require_once MOD_INQMAN_VALIDATORS_DIR . '/EmailAddress.php';
require_once MOD_INQMAN_VALIDATORS_DIR . '/TemplateEmailAddress.php';
require_once MOD_INQMAN_VALIDATORS_DIR . '/Password.php';

require_once APPLICATION_DIR . '/' . 'Bootstrap.php';

$bootstrap = new Bootstrap();
$bootstrap->run();
