<?php
/**
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

require_once 'Bullhead/Db/Table/Abstract.php';
require_once 'Bullhead/Log.php';

abstract class Inqman_AbstractDao extends Bullhead_Db_Table_Abstract
{
    
    /**
     * コンストラクタ
     * 
     */
    public function __construct($config = array())
    {
        parent::__construct($config);
        /**
         * ログ出力先の設定
         */
        $config = new Zend_Config_Ini(MOD_INQMAN_CONFIGS_DIR . '/config.ini.php', APPLICATION_RUNNING_MODE);
        $log_config   = $config->log_files->sql_log;
        $save_dir     = $log_config->save_dir;
        $output_level = intval($log_config->output_level);
        
        $logger = new Bullhead_Log();
        $logger->addWriter(new Zend_Log_Writer_Stream(ROOT_DIR . $save_dir . 'sql.log'));
        $logger->addFilter(new Zend_Log_Filter_Priority($output_level));
        $this->_logger = $logger;
    }
}

