<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * ユーザ登録フォームクラス
 * 
 *
 */
class Inqman_UserForm extends AbstractForm 
{
    const ID          = 'id';
    const USER_ID     = 'user_id';
    const NAME        = 'name';
    const MAILADDR    = 'mailaddress';
    const PASSWD      = 'password';
    const PASSWD_C    = 'password_confirm';
    const GRP_ID      = 'group_id';
    
    /**
     * バリデータを設定する
     * 
     * @access protected
     * @return array Zend_Validate バリデータチェイン
     */
    protected function _prepareValidators()
    {
        $validators = array();
        $validate_config = $this->_config->validate->user;
        
        $validId = new Zend_Validate();
        $validators[self::ID] = $validId;
        
        $validUserId = new Zend_Validate();
        $validUserId->addValidator(new Zend_Validate_NotEmpty(), true)
                ->addValidator(new Zend_Validate_StringLength(0, $validate_config->user_id->get('max_length', 30)))
                ->addValidator(new Zend_Validate_Regex('/^[a-zA-Z]+[0-9a-zA-Z_]+$/'))
        ;
        $validators[self::USER_ID] = $validUserId;
        
        $validUserName = new Zend_Validate();
        $validUserName->addValidator(new Zend_Validate_NotEmpty(), true)
                ->addValidator(new Zend_Validate_StringLength(0, $validate_config->name->get('max_length', 100)))
        ;
        $validators[self::NAME] = $validUserName;
        
        $validMailaddress = new Zend_Validate();
        $validMailaddress->addValidator(new Zend_Validate_NotEmpty(), true)
                ->addValidator(new Zend_Validate_StringLength(0, $validate_config->mailaddress->get('max_length', 80)))
                ->addValidator(new Inqman_Validate_EmailAddress())
        ;
        $validators[self::MAILADDR] = $validMailaddress;
        
        $validPassword = new Zend_Validate();
        $validPassword->addValidator(new Zend_Validate_NotEmpty(), true)
                ->addValidator(new Inqman_Validate_Password($validate_config->password->get('min_length'), $validate_config->password->get('max_length')))
        ;
        $validators[self::PASSWD] = $validPassword;
        
        $validPasswordConfirm = new Zend_Validate();
        $validators[self::PASSWD_C] = $validPasswordConfirm;

        return $validators;
    }
    
    /**
     * フィルタを設定する
     * 
     * @access protected
     * @return array フィルタチェイン
     */
    protected function _prepareFilters()
    {
        $filterUserId = new Zend_Filter();
        $filterUserId->addFilter(new Zend_Filter_StringToLower())
            ->addFilter(new Zend_Filter_StringTrim())
            ->addFilter(new Bullhead_Filter_ZenToHan())
        ;
        
        $filterUserName = new Zend_Filter();
        $filterUserName->addFilter(new Zend_Filter_StringTrim());
        
        $filterMailaddress = new Zend_Filter();
        $filterMailaddress->addFilter(new Zend_Filter_StringTrim())
            ->addFilter(new Bullhead_Filter_ZenToHan())
        ;
        
        $filterPassword = new Zend_Filter();
        $filterPassword->addFilter(new Zend_Filter_StringTrim());
        
        $filterPasswordConfirm = new Zend_Filter();
        $filterPasswordConfirm->addFilter(new Zend_Filter_StringTrim());
        
        
        $filters = array(self::USER_ID  => $filterUserId,
                         self::NAME     => $filterUserName,
                         self::MAILADDR => $filterMailaddress,
                         self::PASSWD   => $filterPassword,
                         self::PASSWD_C => $filterPasswordConfirm,
        );        
        return $filters;
    }
    
    public function prepareModifyForm()
    {
        $validate_config = $this->_config->validate->user;
        //パスワードの必須制限を外す（バリデータを再設定）
        $validPassword = new Zend_Validate();
        $validPassword->addValidator(new Inqman_Validate_Password($validate_config->password->get('min_length'), $validate_config->password->get('max_length')));        
        $this->_validators[self::PASSWD] = $validPassword;
    }
	
	/**
	 * @see AbstractForm::isValid()
	 *
	 * @param unknown_type $data
	 * @return unknown
	 */
	public function isValid($data = null)
	{
	    if (isset($data[self::PASSWD]) && isset($data[self::PASSWD_C])) {
    	    //パスワードのバリデータに確認入力との比較検証をセット
    	    //（ここで設定しないと比較対象値が取れない）
    	    $this->_validators[self::PASSWD]->addValidator(
    	               new Bullhead_Validate_StringEquals($data[self::PASSWD_C]));
	    }
	    return parent::isValid($data);
	}

}

?>
