<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * メールテンプレート登録用のフォームクラス
 *
 */
class Inqman_MailtemplateForm extends AbstractForm
{
    const ID         = 'mailtemplate_id';
    const NAME       = 'name';
    const MAIL_FROM  = 'mail_from';
    const SUBJECT    = 'subject';
    const CONTENT    = 'content';
    const SERVICE_ID = 'service_id';

    /**
     * @see AbstractForm::_prepareFilters()
     *
     */
    protected function _prepareFilters()
    {
    }
    
    /**
     * @see AbstractForm::_prepareValidators()
     *
     */
    protected function _prepareValidators()
    {
        $validators = array();
        $validate_config = $this->_config->validate->mailtemplate;
        
        $fieldValidator = new Zend_Validate();
        $validators[self::ID] = $fieldValidator;
        
        //メールテンプレート名のバリデーション設定
        $fieldValidator = new Zend_Validate();        
        $fieldValidator
                    ->addValidator(new Zend_Validate_NotEmpty(), true)
                    ->addValidator(new Zend_Validate_StringLength(0, $validate_config->name->get('max_length', 200)))
        ;
        $validators[self::NAME] = $fieldValidator;
        
        //メール件名のバリデーション設定
        $fieldValidator = new Zend_Validate();        
        $fieldValidator
                    ->addValidator(new Zend_Validate_StringLength(0, $validate_config->subject->get('max_length', 200)))
        ;
        $validators[self::SUBJECT] = $fieldValidator;
        
        //メール本文のバリデーション設定
        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_StringLength(0, $validate_config->content->get('max_length', 2000)))
        ;
        $validators[self::CONTENT] = $fieldValidator;
        
        //メール送信者アドレスのバリデーション設定
        $fieldValidator = new Zend_Validate();
        $fieldValidator
                   ->addValidator(new Zend_Validate_StringLength(0,$validate_config->mail_from->get('max_length', 100)))
                   ->addValidator(new Inqman_Validate_TemplateEmailAddress())
        ;
        $validators[self::MAIL_FROM] = $fieldValidator;
        
        //サービスIDのバリデーション設定
        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_NotEmpty(), true)
                    ->addValidator(new Zend_Validate_Int())
        ;
        $validators[self::SERVICE_ID] = $fieldValidator;
        
        
        return $validators;
    }
    
}
