<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * ユーザ管理画面のコントローラークラス
 *
 * @author 
 * @copyright COPYRIGHT &copy 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 * @version 
 * @package 
 * @see AbstractController
 */
class Inqman_UserController extends AbstractController
{
    /**
     * インデックス画面
     * @access public
     */
    public function indexAction()
    {
        $this->_forward('view_list');
    }
	
	/**
	 * ユーザ情報の一覧を表示する
	 * 
	 * @access public
	 */
	public function viewlistAction()
	{
	    //アクセス権限のチェック
	    $this->_checkAcl(ACL_RESOURCE_KEY_USER, ACL_PRIVILEGE_KEY_READ, ACL_GLOBAL_SERVICE_ID);
	    
        //ページタイトルの設定
        $this->_setupPageTitle('view_list', 'user');
	}
	
	/**
	 * ユーザ情報をJSON形式で返す
	 * 
	 * @access public
	 */
	public function jsonAction()
	{
	    try{
	       $this->_checkAcl(ACL_RESOURCE_KEY_USER, ACL_PRIVILEGE_KEY_READ, ACL_GLOBAL_SERVICE_ID);
	    } catch (Exception $e) {
	        return null;
	    }
	    
        // リクエストのフィルタリング。
        $f = new Zend_Filter_StripTags();
        $qtype     = $f->filter($this->_request->getParam('qtype'));
        $query     = $f->filter($this->_request->getParam('query'));
        $page      = $f->filter($this->_request->getParam('page',1));
        $rp        = $f->filter($this->_request->getParam('rp',10));
        $sortname  = $f->filter($this->_request->getParam('sortname', 'id'));
        $sortorder = $f->filter($this->_request->getParam('sortorder', 'desc'));
        
        $criteria = $this->getRequest()->getParam('crtr');
	    
	    $this->_helper->viewRenderer->setNoRender();
	    $model = new Inqman_UserModel();
	    
	    $count  = $model->getTotalSize($criteria);
	    $order = "{$sortname} {$sortorder}";
	           
        $rows = $model->find($order, $page, $rp, $criteria);
	    
        $json = array(
                'page' => (int) $page,
                'total' => (int) $count,
        );
	    
	    foreach ($rows as $row) {
	        $tmp = array();
	        $tmp[] = $this->view->escape($row['id']);
	        $tmp[] = $this->view->escape($row['user_id']);
	        $tmp[] = $this->view->escape($row['name']);
	        $tmp[] = $this->view->escape($row['mailaddress']);
	        //$tmp[] = $row['enable'] == 0 ? $this->_translate->translate('common.label.enable.0')
	        //                             : $this->_translate->translate('common.label.enable.1');
	        $tmp[] = empty($row['create_datetime']) ? "----" : $this->view->escape($row['create_datetime']);
	        $tmp[] = empty($row['update_datetime']) ? "----" : $this->view->escape($row['update_datetime']);
	        $tmp[] = "<a href=\"./user/setup_auth/user_id/{$row['id']}/\">{$this->view->translate('user.operation.setup_auth')}</a>"
	               . "&nbsp;/&nbsp;<a href=\"./user/modify_input/id/{$row['id']}/\">{$this->view->translate('common.operation.modify')}</a>"
	               . "&nbsp;/&nbsp;<a href=\"./user/delete_confirm/user_id/{$row['id']}/\">{$this->view->translate('common.operation.delete')}</a>";
	        $json['rows'][]     = array('cell' => $tmp);
	    }
	    
	    $this->_helper->json->sendJson($json);
	}
	
    /**
     * ユーザ登録の登録情報入力画面を表示する
     * 
     * @access public
     */
    public function createinputAction()
    {
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_USER, ACL_PRIVILEGE_KEY_CREATE, ACL_GLOBAL_SERVICE_ID);
        
        //ページタイトルの設定
        $this->_setupPageTitle('create_input', 'user');
        
        //確認画面から戻ってきた場合に、入力フィールドに値を入れる
        if (!empty($_POST)) {
            $form_input = $_POST;
        } else {
            $form_input = array(
                'user_id'     => "",
                'name'	      => "",
                'mailaddress' => "",
            );
        }
        
        $this->view->assign(VIEW_KEY_FORM_INPUT, $form_input);
    }
    
    /**
     * ユーザ登録の入力情報確認画面を表示する
     * 
     * @access public
     */
    public function createconfirmAction()
    {        
        //ページタイトルの設定
        $this->_setupPageTitle('create_confirm', 'user');
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_USER, ACL_PRIVILEGE_KEY_CREATE, ACL_GLOBAL_SERVICE_ID);
        
        $form  = new Inqman_UserForm();
        $model = new Inqman_UserModel();
        $error_messages = array();
        
        //フォーム入力値の検証
        if(!$form->isValid($_POST)) {
            $error_messages = $form->getMessages();
        }
        
        //ユニークフィールドの重複チェック
        $error_messages = array_merge($error_messages, (array) $this->_checkDuplicate($form));
//        //ユーザIDの重複チェック
//        $user_id = $form->getValue('user_id');
//        if (!empty($user_id) && !$model->checkDuplicateUserId($user_id)) {
//            $error_messages = array('user_id' => array($this->view->translate('useridIsDuplicated')));
//        }
//        
//        //メールアドレスの重複チェック
//        $mailaddress = $form->getValue('mailaddress');
//        if (!empty($mailaddress) && !$model->checkDuplicateMailaddress($mailaddress, true)) {
//            $error_messages = array('mailaddress' => array($this->view->translate('mailaddressIsDuplicated')));
//        }
        
        //エラーがあった場合はメッセージをセットして、入力画面を再表示
        if (empty($error_messages)) {
            $this->view->assign(VIEW_KEY_FORM_INPUT, $form->getValues());
        } else {
            $this->view->assign(VIEW_KEY_ERROR_MESSAGES, $error_messages);
            $this->view->assign(VIEW_KEY_FORM_INPUT, $form->getUnfilteredValues());
            $this->_helper->viewRenderer->setRender('create_input');  
        }
    }
    
	/**
	 * ユーザ情報の登録処理を行う
	 * 
	 * @access public
	 */
	public function createcommitAction()
	{
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_USER, ACL_PRIVILEGE_KEY_CREATE, ACL_GLOBAL_SERVICE_ID);
        
        //ページタイトルの設定
        $this->_setupPageTitle('create_commit', 'user');
	    
        $form  = new Inqman_UserForm();
        $model = new Inqman_UserModel();
        $error_messages = null;
	    
	    //フォーム入力値の検証
        if(!$form->isValid($_POST)) {
            $error_messages = $form->getMessages();
        }
        
        //ユーザIDの重複チェック
        $user_id = $form->getValue('user_id');
        if (!empty($user_id) && !$model->checkDuplicateUserId($user_id)) {
            $error_messages = array('user_id' => array($this->view->translate('useridIsDuplicated')));
        }

        //エラーがあった場合はメッセージをセットして、入力画面を再表示
        if ($error_messages === null)
        {
            $values = array(
                            'user_id'       => $form->getValue(Inqman_UserForm::USER_ID),
                            'name'          => $form->getValue(Inqman_UserForm::NAME),
                            'mailaddress'   => $form->getValue(Inqman_UserForm::MAILADDR),
                            'password'      => sha1($form->getValue(Inqman_UserForm::PASSWD)),
                            'enable'        => 1,
                            'deleted'       => 0,
            );
            $model->createUser($values);
            
        } else {
            $this->view->assign(VIEW_KEY_ERROR_MESSAGES, $error_messages);
            $this->view->assign(VIEW_KEY_FORM_INPUT, $form->getUnfilteredValues());
            $this->_helper->viewRenderer->setRender('create_input');  
        }
	}

	/**
	 * ユーザ情報の設定変更入力画面
	 * 
	 * @access public
	 */
	public function modifyinputAction()
	{
        //ページタイトルの設定
        $this->_setupPageTitle('modify_input', 'user');
        	    
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_USER, ACL_PRIVILEGE_KEY_UPDATE, ACL_GLOBAL_SERVICE_ID);
        
	    //リクエストパラメータから変更対象のユーザIDを取得
	    $user_id = $this->getRequest()->getParam('id');
	    
	    //ユーザ情報を取得
        $user_model = new Inqman_UserModel();
        $user = $user_model->getOneUser($user_id);
        
        //確認画面から戻ってきた場合に、入力フィールドに値を入れる
        if (!empty($_POST)) {
            $form_input = $_POST;
        } else {
            $form_input = array(
                'id'          => $user['id'],
                'user_id'     => $user['user_id'],
                'name'        => $user['name'],
                'mailaddress' => $user['mailaddress'],
            );
        }
        $this->view->assign(VIEW_KEY_FORM_INPUT, $form_input);
	}
	
	/**
	 * ユーザ情報の設定変更入力確認画面
	 * 
	 * @access public
	 */
	public function modifyconfirmAction()
	{        
        //ページタイトルの設定
        $this->_setupPageTitle('modify_confirm', 'user');
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_USER, ACL_PRIVILEGE_KEY_UPDATE, ACL_GLOBAL_SERVICE_ID);
        
        $form  = new Inqman_UserForm();
        $model = new Inqman_UserModel();
        $error_messages = array();
        
        //フォーム入力値の検証
        $form->prepareModifyForm();
        if(!$form->isValid($_POST)) {
            $error_messages = $form->getMessages();
        }
        
        //ユニークフィールドの重複チェック
        $error_messages = array_merge($error_messages, (array) $this->_checkDuplicate($form, true)); 
//        //ユーザIDの重複チェック
//        $user_id = $form->getValue('user_id');
//        if (!empty($user_id) && !$model->checkDuplicateUserId($user_id, true)) {
//            $error_messages = array('user_id' => array($this->view->translate('useridIsDuplicated')));
//        }
//        
//        //メールアドレスの重複チェック
//        $mailaddress = $form->getValue('mailaddress');
//        if (!empty($mailaddress) && !$model->checkDuplicateMailaddress($mailaddress, true)) {
//            $error_messages = array('mailaddress' => array($this->view->translate('mailaddressIsDuplicated')));
//        }
        
        //エラーがあった場合はメッセージをセットして、入力画面を再表示
        if (empty($error_messages)) {
            $this->view->assign(VIEW_KEY_FORM_INPUT, $form->getValues());
        } else {
            $this->view->assign(VIEW_KEY_ERROR_MESSAGES, $error_messages);
            $this->view->assign(VIEW_KEY_FORM_INPUT, $form->getUnfilteredValues());
            $this->_helper->viewRenderer->setRender('modify_input');  
        }
	}
	
	/**
	 * ユーザ情報の設定変更実行
	 * 
	 * @access public
	 */
	public function modifycommitAction()
	{        
        //ページタイトルの設定
        $this->_setupPageTitle('modify_commit', 'user');
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_USER, ACL_PRIVILEGE_KEY_UPDATE, ACL_GLOBAL_SERVICE_ID);
        
        $form  = new Inqman_UserForm();
        $model = new Inqman_UserModel();
        $error_messages = null;
        
        //フォーム入力値の検証
        if(!$form->isValid($_POST)) {
            $error_messages = $form->getMessages();
        }
        
        //ユーザIDの重複チェック
        $user_id = $form->getValue('user_id');
        if (!empty($user_id) && !$model->checkDuplicateUserId($user_id, true)) {
            $error_messages = array('user_id' => array($this->view->translate('useridIsDuplicated')));
        }

        //エラーがあった場合はメッセージをセットして、入力画面を再表示
        if ($error_messages === null)
        {
            $values = array(
                    'user_id'       => $form->getValue(Inqman_UserForm::USER_ID),
                    'name'          => $form->getValue(Inqman_UserForm::NAME),
                    'mailaddress'   => $form->getValue(Inqman_UserForm::MAILADDR),
            );
            
            $password = $form->getValue(Inqman_UserForm::PASSWD);
            if (!empty($password)) {
                $values['password'] = sha1($password);
            }
            
            $id = $form->getValue(Inqman_UserForm::ID);
            $user_model = new Inqman_UserModel();

            $user_model->updateUser($id, $values);
            
        } else {
            $this->view->assign(VIEW_KEY_ERROR_MESSAGES, $error_messages);
            $this->view->assign(VIEW_KEY_FORM_INPUT, $form->getUnfilteredValues());
            $this->_helper->viewRenderer->setRender('modify_input');  
        }
	}
	
	/**
	 * 権限（役割）設定入力画面
	 * 
	 * @access public
	 * 
	 */
	public function setupauthAction()
	{        
        //ページタイトルの設定
        $this->_setupPageTitle('setup_auth', 'user');
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_USER, ACL_PRIVILEGE_KEY_UPDATE, ACL_GLOBAL_SERVICE_ID);
	    
	    $user_id = $this->getRequest()->getParam('user_id');
	    
	    $user_model = new Inqman_UserModel();
	    $user_data = $user_model->getOneUser($user_id);
	    
	    $acl_model = new Inqman_AclModel();
	    $user_roles = (array) $acl_model->getUserRoles($user_id);
	    
	    $user_role_keys = array();
	    foreach ($user_roles as $user_role) {
	        $user_role_keys[] = $user_role['authority_id'];
	    }
	    
	    $role_options = $acl_model->getRoleOptions();
	    
	    $this->view->assign('user_data', $user_data);
	    $this->view->assign('user_roles', $user_role_keys);
	    $this->view->assign('role_options', $role_options);
	}
	
	/**
	 * 権限（役割）設定実行
	 */
	public function setupauthcommitAction()
	{
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_USER, ACL_PRIVILEGE_KEY_UPDATE, ACL_GLOBAL_SERVICE_ID);
	    
	    $user_id = $this->getRequest()->getParam('user_id');
	    $roles   = $this->getRequest()->getParam('role');
	    
	    $acl_model = new Inqman_AclModel();
	    $acl_model->saveUserRoles($user_id, $roles);
	    
	    $this->_redirect("/user/setup_auth/user_id/{$user_id}/");
	}

	/**
	 * ユーザ情報の削除確認画面を表示する
	 * 
	 * @access public
	 */
	public function deleteconfirmAction()
	{
        //ページタイトルの設定
        $this->_setupPageTitle('delete_confirm', 'user');
        	    
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_USER, ACL_PRIVILEGE_KEY_DELETE, ACL_GLOBAL_SERVICE_ID);
        
	    //リクエストパラメータから変更対象のユーザIDを取得
	    $user_id = $this->getRequest()->getParam('user_id');
	    
	    //ユーザ情報を取得
        $user_model = new Inqman_UserModel();
        $user = $user_model->getOneUser($user_id);
        $this->view->assign('user', $user);
	}
	
	/**
	 * ユーザ情報の削除を実行する
	 * 
	 * @access public
	 */
	public function deletecommitAction()
	{
        //ページタイトルの設定
        $this->_setupPageTitle('delete_complete', 'user');
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_USER, ACL_PRIVILEGE_KEY_DELETE, ACL_GLOBAL_SERVICE_ID);
        
	    //リクエストパラメータから変更対象のユーザIDを取得
	    $user_id = $this->getRequest()->getParam('user_id');
	    
	    //ユーザ情報を削除
        $user_model = new Inqman_UserModel();
        $user_model->deleteUser($user_id);
	}
	
   /**
     * ユニークフィールドの重複チェックを行う
     * 
     * @access protected
     * @param Inqman_UserForm $form
     * @return array 
     * 
     */
    protected function _checkDuplicate($form, $is_modify=false)
    {
        $model = new Inqman_UserModel();
        $error_messages = array();
        
        //ユーザIDの重複チェック
        $user_id = $form->getValue('user_id');
        if (!empty($user_id) && !$model->checkDuplicateUserId($user_id, $is_modify)) {
            $error_messages[Inqman_UserForm::USER_ID] = array($this->view->translate('useridIsDuplicated'));
        }
        
        //メールアドレスの重複チェック
        $mailaddress = $form->getValue('mailaddress');
        if (!empty($mailaddress) && !$model->checkDuplicateMailaddress($mailaddress, $is_modify)) {
            $error_messages[Inqman_UserForm::MAILADDR] = array($this->view->translate('mailaddressIsDuplicated'));
        }
        return $error_messages;
    }
}