<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * メールテンプレート管理のコントローラクラス
 *
 */
class Inqman_MailtemplateController extends AbstractController
{
    /**
	 * メールテンプレート一覧画面
	 *
	 * @access public
	 */
	public function viewlistAction()
	{
        //ロジックインスタンスを生成
        $mailtemplate_model = new Inqman_MailtemplateModel();
        $acl_model     = new Inqman_AclModel();
        $service_model = new Inqman_ServiceModel();
	    
        //ページタイトルの設定
        $this->_setupPageTitle('view_list', 'mailtemplate');
	    
        //リクエストパラメータからサービスIDを取得
        $service_id = $this->getRequest()->getParam('service_id');
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_MAILTEMPLATE, ACL_PRIVILEGE_KEY_READ, $service_id);
	    
	    //サービス情報を取得
	    $service = $service_model->getOneService($service_id);
	    $this->view->assign('service', $service);
	    
	    //サービス固有のメールテンプレートを取得
        $enable_templates = $mailtemplate_model->getServiceEnableMailtemplates($service_id);
        $this->view->assign('enable_templates', $enable_templates);
        
        //全サービス共通のメールテンプレートを取得
        $common_tamplates = $mailtemplate_model->getCommonMailtemplate();
        $this->view->assign('common_tamplates', $common_tamplates);
        
        $authorities = array_keys($this->_getUserInfo()->roles);
        
        $can_modify_common = false;
        if ($acl_model->checkAcl(ACL_RESOURCE_KEY_MAILTEMPLATE, ACL_PRIVILEGE_KEY_UPDATE, 1, $authorities)) {
            $can_modify_common = true;
        }
        $can_delete_common = false;
        if ($acl_model->checkAcl(ACL_RESOURCE_KEY_MAILTEMPLATE, ACL_PRIVILEGE_KEY_DELETE, 1, $authorities)) {
            $can_delete_common = true;
        }
        $this->view->assign('can_modify_common', $can_modify_common);
        $this->view->assign('can_delete_common', $can_delete_common);
	}
	
	/**
	 * メールテンプレート詳細画面
	 *
	 */
	public function viewdetailAction()
	{
	    //ロジックインスタンスを生成
	    $mailtemplate_model = new Inqman_MailtemplateModel();
        $acl_model     = new Inqman_AclModel();
        
        //ページタイトルの設定
        $this->_setupPageTitle('view_detail', 'mailtemplate');
        
        //リクエストパラメータからメールテンプレートIDを取得
        $mailtemplate_id = $this->getRequest()->getParam('mailtemplate_id'); 
        $mailtemplate = $mailtemplate_model->getOneMailtemplate($mailtemplate_id);
        
        //メールテンプレート情報からサービスIDを取得
        $service_id = $mailtemplate['service_id'];
        
        if ($service_id != 1) {
            //アクセス権限のチェック
            $this->_checkAcl(ACL_RESOURCE_KEY_MAILTEMPLATE, ACL_PRIVILEGE_KEY_READ, $service_id);
        } else {
            $service_id = $this->getRequest()->getParam('service_id');
        }
        
        $authorities = array_keys($this->_getUserInfo()->roles);
        
        $can_modify_common = false;
        if ($acl_model->checkAcl(ACL_RESOURCE_KEY_MAILTEMPLATE, ACL_PRIVILEGE_KEY_UPDATE, 1, $authorities)) {
            $can_modify_common = true;
        }
        $can_delete_common = false;
        if ($acl_model->checkAcl(ACL_RESOURCE_KEY_MAILTEMPLATE, ACL_PRIVILEGE_KEY_DELETE, 1, $authorities)) {
            $can_delete_common = true;
        }
        $this->view->assign('can_modify_common', $can_modify_common);
        $this->view->assign('can_delete_common', $can_delete_common);
        
        
        $this->view->assign('service_id', $service_id);
        $this->view->assign('mailtemplate', $mailtemplate);
	}

    /**
     * メールテンプレート作成入力画面 
     *
     * @access public
     */
    public function createinputAction()
    {
        //ページタイトルの設定
        $this->_setupPageTitle('create_input', 'mailtemplate');
        
        //リクエストパラメータからサービスIDを取得
        $service_id = $this->getRequest()->getParam('service_id');
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_MAILTEMPLATE, ACL_PRIVILEGE_KEY_CREATE, $service_id);
        
        //サービスIDから共通テンプレートorサービス固有テンプレートを判別
        $template_type = ($service_id == 1) ? 'common' : 'personal';
        $this->view->assign('template_type', $template_type);
        
        //サービス情報を取得
        $service_model = new Inqman_ServiceModel();
        $service = $service_model->getOneService($service_id);
        $this->view->assign('service', $service);
        
        if (!empty($_POST)) {
            //確認画面から戻ってきた場合に、入力フィールドに値を入れる
            $form_input = $_POST;
        } else {
            //フォームの初期入力値を設定
            $form = new Inqman_MailtemplateForm();
            $form->setValue(Inqman_MailtemplateForm::ID, 0);
            $form->setValue(Inqman_MailtemplateForm::NAME, "");
            $form->setValue(Inqman_MailtemplateForm::MAIL_FROM, "");
            $form->setValue(Inqman_MailtemplateForm::SUBJECT, "");
            $form->setValue(Inqman_MailtemplateForm::CONTENT, "");
            $form->setValue(Inqman_MailtemplateForm::SERVICE_ID, $service_id);
            $form_input = $form->getValues();
        }
        $this->view->assign(VIEW_KEY_FORM_INPUT, $form_input);
        
        $mailtemplate_model = new Inqman_MailtemplateModel();
        $sysvar_options = $mailtemplate_model->getSysvarOptions();
        $this->view->assign('sysvar_options', $sysvar_options);
        
        $this->_assignCreateActionValue();
        $this->_helper->viewRenderer->setRender('input');
    }
	
	/**
	 * メールテンプレート作成入力確認画面
	 *
	 * @access public
	 */
	public function createconfirmAction()
	{
        //ページタイトルの設定
        $this->_setupPageTitle('create_confirm', 'mailtemplate');
	    
        //リクエストパラメータからサービスIDを取得
        $service_id = $this->getRequest()->getParam('service_id');
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_MAILTEMPLATE, ACL_PRIVILEGE_KEY_CREATE, $service_id);
        
        //サービスIDから共通テンプレートorサービス固有テンプレートを判別
        $template_type = ($service_id == 1) ? 'common' : 'personal';
        $this->view->assign('template_type', $template_type);
        
        //サービス情報を取得
        $service_model = new Inqman_ServiceModel();
        $service = $service_model->getOneService($service_id);
        $this->view->assign('service', $service);
        
        $form  = new Inqman_MailtemplateForm();
        $error_messages = null;
        
        //フォーム入力値の検証
        if(!$form->isValid($_POST)) {
            $error_messages = $form->getMessages();
        }
        
        //エラーがあった場合はメッセージをセットして、入力画面を再表示
        if ($error_messages === null)
        {
            $mail_from = $form->getValue('mail_from');
            if (empty($mail_from)) {
                $form->setValue('mail_from', '{$service.inquiry_mailaddress}');
            }
            $this->view->assign(VIEW_KEY_FORM_INPUT, $form->getValues());
            $this->_helper->viewRenderer->setRender('confirm');
        } else {
            $this->view->assign(VIEW_KEY_ERROR_MESSAGES, $error_messages);
            $this->view->assign(VIEW_KEY_FORM_INPUT, $form->getUnfilteredValues());
            $this->_helper->viewRenderer->setRender('input');  
        }
        
        $mailtemplate_model = new Inqman_MailtemplateModel();
        $sysvar_options = $mailtemplate_model->getSysvarOptions();
        $this->view->assign('sysvar_options', $sysvar_options);
        
        $this->_assignCreateActionValue();
	}
	
   /**
     * メールテンプレート作成実行
     *
     * @access public
     */
    public function createcommitAction()
    {        
        //ページタイトルの設定
        $this->_setupPageTitle('create_commit', 'mailtemplate');
        
        //リクエストパラメータからサービスIDを取得
        $service_id = $this->getRequest()->getParam('service_id');
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_MAILTEMPLATE, ACL_PRIVILEGE_KEY_CREATE, $service_id);
        
        $form  = new Inqman_MailtemplateForm();
        $error_messages = null;
        
        //フォーム入力値の検証
        if(!$form->isValid($_POST)) {
            $error_messages = $form->getMessages();
        }
        
        if ($error_messages === null)
        {
            $values = array(
                    'name'       => $form->getValue(Inqman_MailtemplateForm::NAME),
                    'subject'    => $form->getValue(Inqman_MailtemplateForm::SUBJECT),
                    'mail_from'  => $form->getValue(Inqman_MailtemplateForm::MAIL_FROM),
                    'content'    => $form->getValue(Inqman_MailtemplateForm::CONTENT),
                    'service_id' => $form->getValue(Inqman_MailtemplateForm::SERVICE_ID),
            );
            $model = new Inqman_MailtemplateModel();
//            var_dump($values);
            $model->createMailtemplate($values);
            $this->_helper->viewRenderer->setRender('commit'); 
        }
        //エラーがあった場合はメッセージをセットして、入力画面を再表示
        else {
            $this->view->assign(VIEW_KEY_ERROR_MESSAGES, $error_messages);
            $this->view->assign(VIEW_KEY_FORM_INPUT, $form->getUnfilteredValues());
            $this->_helper->viewRenderer->setRender('input');  
        }
        
        $this->view->assign('service_id', $service_id);
        
        $this->_assignCreateActionValue();
    }
    
    /**
     * メールテンプレート変更入力画面
     * 
     */
    public function modifyinputAction()
    {
        //ページタイトルの設定
        $this->_setupPageTitle('modify_input', 'mailtemplate');
        
        //リクエストパラメータからメールテンプレートIDを取得
        $mailtemplate_id = $this->getRequest()->getParam('mailtemplate_id');
        
        $mailtemplate_model = new Inqman_MailtemplateModel();
        $mailtemplate = $mailtemplate_model->getOneMailtemplate($mailtemplate_id);
        $service_id = $mailtemplate['service_id'];
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_MAILTEMPLATE, ACL_PRIVILEGE_KEY_UPDATE, $service_id);
        
        //サービスIDから共通テンプレートorサービス固有テンプレートを判別
        $template_type = ($service_id == 1) ? 'common' : 'personal';
        $this->view->assign('template_type', $template_type);
        
        //サービス情報を取得
        $service_model = new Inqman_ServiceModel();
        $service = $service_model->getOneService($service_id);
        $this->view->assign('service', $service);
        
        if (!empty($_POST)) {
            //確認画面から戻ってきた場合に、入力フィールドに値を入れる
            $form_input = $_POST;
        } else {
            //フォームの初期入力値を設定
            $form = new Inqman_MailtemplateForm();
            $form->setValue(Inqman_MailtemplateForm::ID, $mailtemplate['id']);
            $form->setValue(Inqman_MailtemplateForm::NAME, $mailtemplate['name']);
            $form->setValue(Inqman_MailtemplateForm::MAIL_FROM, $mailtemplate['mail_from']);
            $form->setValue(Inqman_MailtemplateForm::SUBJECT, $mailtemplate['subject']);
            $form->setValue(Inqman_MailtemplateForm::CONTENT, $mailtemplate['content']);
            $form->setValue(Inqman_MailtemplateForm::SERVICE_ID, $service_id);
            $form_input = $form->getValues();
        }
        $this->view->assign(VIEW_KEY_FORM_INPUT, $form_input);
        
        $sysvar_options = $mailtemplate_model->getSysvarOptions();
        $this->view->assign('sysvar_options', $sysvar_options);
        
        $this->_assignModifyActionValue();
        $this->_helper->viewRenderer->setRender('input');
    }
    
    /**
     * @see AbstractController::modifyconfirmAction()
     * 
     */
    public function modifyconfirmAction()
    {
        //ページタイトルの設定
        $this->_setupPageTitle('modify_confirm', 'mailtemplate');
	    
        //リクエストパラメータからメールテンプレートIDを取得
        $mailtemplate_id = $this->getRequest()->getParam('mailtemplate_id');
        
        $mailtemplate_model = new Inqman_MailtemplateModel();
        $mailtemplate = $mailtemplate_model->getOneMailtemplate($mailtemplate_id);
        $service_id = $mailtemplate['service_id'];
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_MAILTEMPLATE, ACL_PRIVILEGE_KEY_UPDATE, $service_id);
        
        //サービスIDから共通テンプレートorサービス固有テンプレートを判別
        $template_type = ($service_id == 1) ? 'common' : 'personal';
        $this->view->assign('template_type', $template_type);
        
        //サービス情報を取得
        $service_model = new Inqman_ServiceModel();
        $service = $service_model->getOneService($service_id);
        $this->view->assign('service', $service);
        
        $form  = new Inqman_MailtemplateForm();
        $error_messages = null;
        
        //フォーム入力値の検証
        if(!$form->isValid($_POST)) {
            $error_messages = $form->getMessages();
        }
        
        //エラーがあった場合はメッセージをセットして、入力画面を再表示
        if ($error_messages === null)
        {
            $mail_from = $form->getValue('mail_from');
            if (empty($mail_from)) {
                $form->setValue('mail_from', '{$service.inquiry_mailaddress}');
            }
            $this->view->assign(VIEW_KEY_FORM_INPUT, $form->getValues());
            $this->_helper->viewRenderer->setRender('confirm');
        } else {
            $this->view->assign(VIEW_KEY_ERROR_MESSAGES, $error_messages);
            $this->view->assign(VIEW_KEY_FORM_INPUT, $form->getUnfilteredValues());
            $this->_helper->viewRenderer->setRender('input');  
        }
        
        $mailtemplate_model = new Inqman_MailtemplateModel();
        $sysvar_options = $mailtemplate_model->getSysvarOptions();
        $this->view->assign('sysvar_options', $sysvar_options);
        
        $this->view->assign('service_id', $this->getRequest()->getParam('service_id'));
        
        $this->_assignModifyActionValue();
    }
    
    /**
     * @see AbstractController::modifycommitAction()
     * 
     */
    public function modifycommitAction()
    {
        //ページタイトルの設定
        $this->_setupPageTitle('modify_commit', 'mailtemplate');
        
        //リクエストパラメータからメールテンプレートIDを取得
        $mailtemplate_id = $this->getRequest()->getParam('mailtemplate_id');
        
        $mailtemplate_model = new Inqman_MailtemplateModel();
        $mailtemplate = $mailtemplate_model->getOneMailtemplate($mailtemplate_id);
        $service_id = $mailtemplate['service_id'];
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_MAILTEMPLATE, ACL_PRIVILEGE_KEY_UPDATE, $service_id);
        
        $form  = new Inqman_MailtemplateForm();
        $error_messages = null;
        
        //フォーム入力値の検証
        if(!$form->isValid($_POST)) {
            $error_messages = $form->getMessages();
        }
        
        if ($error_messages === null)
        {
            $values = array(
                    'id'		 => $form->getValue('mailtemplate_id'),
                    'name'       => $form->getValue(Inqman_MailtemplateForm::NAME),
                    'subject'    => $form->getValue(Inqman_MailtemplateForm::SUBJECT),
                    'mail_from'  => $form->getValue(Inqman_MailtemplateForm::MAIL_FROM),
                    'content'    => $form->getValue(Inqman_MailtemplateForm::CONTENT),
                    'service_id' => $form->getValue(Inqman_MailtemplateForm::SERVICE_ID),
            );
            $model = new Inqman_MailtemplateModel();
            //var_dump($values);
            $model->updateMailtemplate($mailtemplate_id, $values);
            $this->_helper->viewRenderer->setRender('commit'); 
        }
        //エラーがあった場合はメッセージをセットして、入力画面を再表示
        else {
            $this->view->assign(VIEW_KEY_ERROR_MESSAGES, $error_messages);
            $this->view->assign(VIEW_KEY_FORM_INPUT, $form->getUnfilteredValues());
            $this->_helper->viewRenderer->setRender('input');  
        }
        
        $this->view->assign('service_id', $this->getRequest()->getParam('service_id'));
        
        $this->_assignModifyActionValue();
    }
    
    /**
     * メールテンプレート複製作成
     * 
     * @access public
     */
    public function copyAction()
    {
        //ページタイトルの設定
        $this->_setupPageTitle('create_input', 'mailtemplate');
        
        //リクエストパラメータからサービスIDを取得
        $service_id = $this->getRequest()->getParam('service_id');
        
        //リクエストパラメータからメールテンプレートIDを取得
        $mailtemplate_id = $this->getRequest()->getParam('mailtemplate_id');
        
        $mailtemplate_model = new Inqman_MailtemplateModel();
        $mailtemplate = $mailtemplate_model->getOneMailtemplate($mailtemplate_id);
        $this->view->assign(VIEW_KEY_FORM_INPUT, $mailtemplate);
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_MAILTEMPLATE, ACL_PRIVILEGE_KEY_CREATE, $service_id);
        
        //サービスIDから共通テンプレートorサービス固有テンプレートを判別
        $template_type = ($service_id == 0) ? 'common' : 'personal';
        $this->view->assign('template_type', $template_type);
        
        //サービス情報を取得
        $service_model = new Inqman_ServiceModel();
        $service = $service_model->getOneService($service_id);
        $this->view->assign('service', $service);
        
        if (!empty($_POST)) {
            //確認画面から戻ってきた場合に、入力フィールドに値を入れる
            $form_input = $_POST;
        } else {
            //フォームの初期入力値を設定
            $form = new Inqman_MailtemplateForm();
            $form->setValue(Inqman_MailtemplateForm::ID, 0);
            $form->setValue(Inqman_MailtemplateForm::NAME, $mailtemplate['name']);
            $form->setValue(Inqman_MailtemplateForm::MAIL_FROM, $mailtemplate['mail_from']);
            $form->setValue(Inqman_MailtemplateForm::SUBJECT, $mailtemplate['subject']);
            $form->setValue(Inqman_MailtemplateForm::CONTENT, $mailtemplate['content']);
            $form->setValue(Inqman_MailtemplateForm::SERVICE_ID, $service_id);
            $form_input = $form->getValues();
        }
        $this->view->assign(VIEW_KEY_FORM_INPUT, $form_input);
        
        $mailtemplate_model = new Inqman_MailtemplateModel();
        $sysvar_options = $mailtemplate_model->getSysvarOptions();
        $this->view->assign('sysvar_options', $sysvar_options);
        
        $this->_assignCreateActionValue();
        $this->_helper->viewRenderer->setRender('input');
    }
	
    /**
     * メールテンプレート削除確認画面
     * 
     * @access public
     */
    public function deleteconfirmAction()
    {
        //ロジックインスタンスを生成
        $mailtemplate_model = new Inqman_MailtemplateModel();
        
        //ページタイトルの設定
        $this->_setupPageTitle('delete_confirm', 'mailtemplate');
        
        //リクエストパラメータからメールテンプレートIDを取得
        $mailtemplate_id = $this->getRequest()->getParam('mailtemplate_id');
        $mailtemplate = $mailtemplate_model->getOneMailtemplate($mailtemplate_id);
        
        //メールテンプレート情報からサービスIDを取得
        $service_id = $mailtemplate['service_id'];
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_MAILTEMPLATE, ACL_PRIVILEGE_KEY_DELETE, $service_id);
        
        $this->view->assign('service_id', $service_id);
        $this->view->assign('mailtemplate', $mailtemplate);
    }
    
    /**
     * メールテンプレート削除実行
     * 
     * @access public
     */
    public function deletecommitAction()
    {
        //ロジックインスタンスを生成
        $mailtemplate_model = new Inqman_MailtemplateModel();
        
        //ページタイトルの設定
        $this->_setupPageTitle('delete_commit', 'mailtemplate');
        
        //リクエストパラメータからメールテンプレートIDを取得
        $mailtemplate_id = $this->getRequest()->getParam('mailtemplate_id');
        $mailtemplate = $mailtemplate_model->getOneMailtemplate($mailtemplate_id);
        
        //メールテンプレート情報からサービスIDを取得
        $service_id = $mailtemplate['service_id'];
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_MAILTEMPLATE, ACL_PRIVILEGE_KEY_DELETE, $service_id);
        
        $mailtemplate_model->delete($mailtemplate_id);
        
        $this->view->assign('service_id', $service_id);
        $this->view->assign('mailtemplate', $mailtemplate);
    }
    
}
