<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

require_once MOD_INQMAN_CONTROLLERS_DIR . '/InquiryController.php';

/**
 * CommentController
 * 
 * @author
 * @version 
 */
class Inqman_CommentController extends Inqman_InquiryController
{
    
    /**
     * コメント登録の入力画面を表示する。
     * 
     * @access public
     */
    public function createinputAction()
    {
        //ロジックインスタンスを生成
        $inquiry_model = new Inqman_InquiryModel();
        $reply_model   = new Inqman_ReplyModel();
        
        //ページタイトルの設定
        $this->_setupPageTitle('create_input', 'comment');
        
        //リクエストパラメータから問い合わせIDまたは回答IDを取得
        $inquiry_id = $this->getRequest()->getParam(REQUEST_KEY_INQUIRY_ID);
        $reply_id   = $this->getRequest()->getParam(REQUEST_KEY_PARENT_REPLY_ID);

        $parent_data = null;
        $inquiry = null;
        //回答IDがある場合は、回答へのコメントとして処理
        if (!empty($reply_id)) {
            //コメント対象として指定された回答の情報を取得
            $parent_data = $reply_model->getOneReply($reply_id);
            //回答情報から問い合わせIDを取得
            $inquiry_id = $parent_data['inquiry_id'];
            $inquiry = $inquiry_model->getOneInquiry($inquiry_id);
        } else
        //回答IDがなく質問IDがある場合は質問へのコメントとして処理        
        if (!empty($inquiry_id)) {
            $inquiry = $inquiry_model->getOneInquiry($inquiry_id);
            $parent_data  = $inquiry;
            $reply_id = 0;
        }
        $service_id = $inquiry['service_id'];
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_COMMENT, ACL_PRIVILEGE_KEY_CREATE, $service_id);
        
        //フォーム初期値を設定
        $form_input = array();
        if (!empty($_POST)) {
            $form_input = $_POST;
        } else {
            $form_input['inquiry_id'] = $inquiry_id;
            $form_input['parent_id']  = $reply_id;
            
            //件名は先頭に接頭語[Re:]を付与
            $form_input['subject']    = 'Re: ' . $parent_data['subject'];
            //$form_input['subject'] = $parent_data['subject'];
            //内容は各行頭に引用記号を付与
            $form_input['content']    = preg_replace('/^/m', '> ', $parent_data['content']);
        }
        
        $this->view->assign(VIEW_KEY_FORM_INPUT, $form_input);
        $this->view->assign('service_id', $service_id);
        
        $this->_assignCreateActionValue();
        $this->_helper->viewRenderer->setRender('input');
    }
    
    /**
     * コメント登録の確認画面を表示する。
     * 
     * @access public
     */
    public function createconfirmAction()
    {
        //ロジックインスタンスを生成
        $inquiry_model = new Inqman_InquiryModel();
        $reply_model   = new Inqman_ReplyModel();
        
        //ページタイトルの設定
        $this->_setupPageTitle('create_confirm', 'comment');
        
        //問い合わせIDまたは回答IDを取得
        $inquiry_id = $this->getRequest()->getParam(REQUEST_KEY_INQUIRY_ID);
        $reply_id   = $this->getRequest()->getParam(REQUEST_KEY_PARENT_REPLY_ID);

        $parent_data   = null;
        $inquiry  = null;
        //回答IDがある場合は、回答へのコメントとして処理
        if (!empty($reply_id)) {
            //コメント対象として指定された回答の情報を取得
            $parent_data = $reply_model->getOneReply($reply_id);
            
            //回答情報から問い合わせIDを取得
            $inquiry_id = $parent_data['inquiry_id'];
            $inquiry = $inquiry_model->getOneInquiry($inquiry_id);
        } else
        //回答IDがなく質問IDがある場合は質問へのコメントとして処理        
        if (!empty($inquiry_id)) {
            $inquiry = $inquiry_model->getOneInquiry($inquiry_id);
            $parent_data  = $inquiry;
            $reply_id = 0;
        }
        $service_id = $inquiry['service_id'];
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_COMMENT, ACL_PRIVILEGE_KEY_CREATE, $service_id);
        
        // フォーム入力値が正常でない場合、入力画面に戻る
        $form = new Inqman_CommentForm();
        if(!$form->isValid($_POST)) {
            $this->view->assign(VIEW_KEY_ERROR_MESSAGES, $form->getMessages());
            $this->view->assign(VIEW_KEY_FORM_INPUT,     $form->getUnfilteredValues());
            $this->_helper->viewRenderer->setRender('input');
        } else {
            $this->view->assign(VIEW_KEY_FORM_INPUT, $form->getValues());
            $this->_helper->viewRenderer->setRender('confirm');
        }
        
        $priority_options = $inquiry_model->getPriorityOptions();
        $method_options   = $reply_model->getMethodOptions();
        
        $this->view->assign('priority_options', $priority_options);
        $this->view->assign('method_options', $method_options);
        
        $this->_assignCreateActionValue();
    }
    
    /**
     * コメント登録を実行する。
     * 
     * @access public
     */
    public function createcommitAction()
    {
        //ロジックインスタンスを生成
        $inquiry_model = new Inqman_InquiryModel();
        $reply_model   = new Inqman_ReplyModel();
        
        //ページタイトルの設定
        $this->_setupPageTitle('create_commit', 'comment');
        
        //問い合わせIDまたは回答IDを取得
        $inquiry_id = $this->getRequest()->getParam(REQUEST_KEY_INQUIRY_ID);
        $reply_id   = $this->getRequest()->getParam(REQUEST_KEY_PARENT_REPLY_ID);
        
        $parent_data   = null;
        $inquiry  = null;
        //回答IDがある場合は、回答へのコメントとして処理
        if (!empty($reply_id)) {
            //コメント対象として指定された回答の情報を取得
            $parent_data = $reply_model->getOneReply($reply_id);
            
            //回答情報から問い合わせIDを取得
            $inquiry_id = $parent_data['inquiry_id'];
            $inquiry = $inquiry_model->getOneInquiry($inquiry_id);
        } else
        //回答IDがなく質問IDがある場合は質問へのコメントとして処理        
        if (!empty($inquiry_id)) {
            $inquiry = $inquiry_model->getOneInquiry($inquiry_id);
            $parent_data  = $inquiry;
            $reply_id = 0;
        }
        $service_id = $inquiry['service_id'];
        
        //アクセス権限のチェック
        $this->_checkAcl(ACL_RESOURCE_KEY_COMMENT, ACL_PRIVILEGE_KEY_CREATE, $service_id);     
        
        $form = new Inqman_CommentForm();
        if($form->isValid($_POST)) {
            $inquiry_id = $form->getValue(Inqman_ReplyForm::INQUIRY_ID);
            $user_info = $this->_getUserInfo();
            $values = array(
                    'subject'       => $form->getValue(Inqman_CommentForm::SUBJECT),
                    'content'       => $form->getValue(Inqman_CommentForm::CONTENT),
                    'priority'      => 0,
                    'method'        => 0,
                    'type'          => Inqman_ReplyModel::RES_TYPE_CODE_COMMENT,
                    'inquiry_id'    => $inquiry_id,
                    'parent_id'     => $form->getValue(Inqman_CommentForm::PARENT_ID),
                    'respondent_id' => $user_info->id,
                    'received_from' => "$user_info->name <{$user_info->mailaddress}>",
            );
            $reply_id = $reply_model->createReply($values);
            
            //イベントメール送信
            $criteria = array('service_id'=>$service_id, 'inquiry_id'=>$inquiry_id, 'reply_id'=>$reply_id);
            $reply_model->sendMail(9, $criteria);
            $reply_model->sendMail(10, $criteria);
            
            $this->_helper->viewRenderer->setRender('commit');
        }
        else {
            $this->createconfirmAction();
        }
        
        $this->view->assign('service_id', $service_id);
        $this->view->assign('inquiry_id', $inquiry_id);
        $this->_assignCreateActionValue();
    }
    
}
