<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 起動処理クラス
 * 
 *
 */
class Bootstrap
{   
    /**
     * アプリケーションを実行する
     */
    public function run()
    {
        try {
        	// init!
            $this->_init();            
            
            // run!
            $controller = $this->_setupController();
            $controller->dispatch();
        } catch (Zend_Db_Adapter_Exception $e) {
            echo nl2br("The error occurred when DB was connected. \n {$e->getMessage()}");
        }  catch (Exception $e) {
            echo nl2br($e->__toString());
        }           
    }
    
    /**
     * 初期化処理を行う
     */
	protected function _init()
    {
    	//php設定を行う
    	$this->_setupEnvironment();
    }
	
    /**
     * php.ini設定を行う
     */
    protected function _setupEnvironment()
    {
        //error_reporting(E_ALL|E_STRICT);
        ini_set('display_errors', true);
        ini_set('iconv.internal_encoding', ENV_INTERNAL_ENCODING);
        setlocale(LC_ALL, ENV_SERVER_LOCALE);
    }
	
	/**
	 * FrontController設定を行う
	 */
	protected function _setupController()
	{
        $controller = Zend_Controller_Front::getInstance();
        $controller->setDefaultModule('inqman');
        $controller->addControllerDirectory(MOD_INQMAN_CONTROLLERS_DIR, 'inqman');
        $controller->setParam('prefixDefaultModule', true);
        $this->_setupRouter($controller);
        //$controller->throwExceptions(true);
        $controller->registerPlugin(new Zend_Controller_Plugin_ErrorHandler());
        return $controller;
	}
	
	/**
	 * ルーター設定を行う
	 * 
	 * @param Zend_Controller_Front $controller フロントコントローラーオブジェクト
	 * 
	 */
	protected function _setupRouter($controller)
	{
	    $router = $controller->getRouter();
	    
	    $route = new Zend_Controller_Router_Route(
	           ':controller/:action/*',
	           array(
	               'module'      => null,
	               'controller'  => 'index',
	               'action'      => 'index',
	           )
	    );
	    $router->addRoute('default', $route);	    
	    
	    $route = new Zend_Controller_Router_Route_Static(
            'login',
	        array('controller' => 'account', 'action' => 'login')
	    );	    
	    $router->addRoute('login', $route);
	    
	    $controller->setRouter($router);
	}
	
}

?>
