/*
 * Decompiled with CFR 0.152.
 */
package osm.jp.gpx.matchtime.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import osm.jp.gpx.ImportPicture;
import osm.jp.gpx.matchtime.gui.Command;

public class DoDialog
extends JDialog {
    public static final String TITLE = "Do Command";
    boolean fComponentsAdjusted = false;
    String[] args;
    JFrame parentFrame;
    JPanel buttonPanel;
    JButton closeButton;
    JButton doButton;
    JTextArea textArea;

    public DoDialog(JFrame parentFrame, String[] args) {
        super((Frame)parentFrame, true);
        this.parentFrame = parentFrame;
        this.args = args;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        parentFrame.setVisible(false);
        this.setSize(this.getInsets().left + this.getInsets().right + 980, this.getInsets().top + this.getInsets().bottom + 480);
        this.setTitle(TITLE);
        this.buttonPanel = new JPanel();
        this.doButton = new JButton("\u5b9f\u884c");
        this.doButton.setToolTipText("\u51e6\u7406\u3092\u5b9f\u884c\u3057\u307e\u3059.");
        this.doButton.setEnabled(true);
        this.doButton.addActionListener(event -> {
            this.doButton.setText("\u51e6\u7406\u4e2d...");
            this.doButton.setEnabled(false);
            LongTaskWorker worker = new LongTaskWorker(this.doButton);
            worker.execute();
        });
        this.buttonPanel.add(this.doButton);
        this.closeButton = new JButton("\u9589\u3058\u308b");
        this.closeButton.setToolTipText("\u51e6\u7406\u3092\u7d42\u4e86\u3057\u307e\u3059.");
        this.closeButton.addActionListener(event -> this.dispose());
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add("South", this.buttonPanel);
        this.textArea = new JTextArea();
        JScrollPane sc = new JScrollPane(this.textArea);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.textArea.setTabSize(4);
        this.getContentPane().add("Center", sc);
        try {
            this.textArea.append("> java -cp importPicture.jar osm.jp.gpx.ImportPicture");
            for (String arg : args) {
                this.textArea.append(" '" + arg + "'");
            }
            this.textArea.append("\n\n");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        parentFrame.setVisible(true);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(80, 80);
        }
        super.setVisible(b);
    }

    @Override
    public void addNotify() {
        Component[] components;
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        this.setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        for (Component component : components = this.getComponents()) {
            Point p = component.getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            component.setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    class LongTaskWorker
    extends SwingWorker<Object, Object> {
        private final JButton button;

        public LongTaskWorker(JButton button) {
            this.button = button;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object doInBackground() {
            PrintStream defOut = System.out;
            PrintStream defErr = System.err;
            JTextAreaOutputStream os = new JTextAreaOutputStream(DoDialog.this.textArea, "UTF-8");
            PrintStream stdout = new PrintStream(os, true);
            System.setOut(stdout);
            System.setErr(stdout);
            try {
                Command command = new Command(ImportPicture.class);
                command.setArgs(DoDialog.this.args);
                command.start();
                while (command.isAlive()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Exception e) {
                e.printStackTrace(stdout);
            }
            finally {
                System.setOut(defOut);
                System.setErr(defErr);
                DoDialog.this.doButton.setEnabled(true);
            }
            return null;
        }

        @Override
        protected void done() {
            this.button.setText("\u5b9f\u884c");
            this.button.setEnabled(true);
        }
    }

    public static class JTextAreaOutputStream
    extends OutputStream {
        private final ByteArrayOutputStream os;
        private final JTextArea textArea;
        private final String encode;

        public JTextAreaOutputStream(JTextArea textArea, String encode) {
            this.textArea = textArea;
            this.encode = encode;
            this.os = new ByteArrayOutputStream();
        }

        @Override
        public void write(int arg) throws IOException {
            this.os.write(arg);
        }

        @Override
        public void flush() throws IOException {
            final String str = new String(this.os.toByteArray(), this.encode);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    textArea.append(str);
                }
            });
            this.os.reset();
        }
    }
}

